/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="exportxfdf", header={"Exports AcroForm form data to XFDF"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class ExportXFDF
implements Callable<Integer> {
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to export"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the XFDF data file"}, required=true)
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new ExportXFDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        block28: {
            try (PDDocument pdf = Loader.loadPDF((File)this.infile);){
                PDAcroForm form = pdf.getDocumentCatalog().getAcroForm();
                if (form == null) {
                    this.SYSERR.println("Error: This PDF does not contain a form.");
                    break block28;
                }
                if (this.outfile == null) {
                    String outPath = FilenameUtils.removeExtension((String)this.infile.getAbsolutePath()) + ".xfdf";
                    this.outfile = new File(outPath);
                }
                try (FDFDocument fdf = form.exportFDF();){
                    fdf.saveXFDF(this.outfile);
                }
            }
            catch (IOException ioe) {
                this.SYSERR.println("Error exporting XFDF data [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
                return 4;
            }
        }
        return 0;
    }
}

