/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeSettings;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.StringValue;

public class CheckBoxX
extends CheckBox {
    private final CheckBoxXConfig config = new CheckBoxXConfig();

    public CheckBoxX(String id) {
        this(id, null);
    }

    public CheckBoxX(String id, IModel<Boolean> model) {
        super(id, model);
        this.config.withEnclosedLabel(true);
        this.setOutputMarkupId(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        String value = CheckBoxXConverter.INSTANCE.convertToString((Object)((Boolean)this.getModelObject()), this.getLocale());
        tag.put("value", (CharSequence)value);
    }

    public void convertInput() {
        this.setConvertedInput((Boolean)this.getModelObject());
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new AjaxEventBehavior("change"){

            protected void onEvent(AjaxRequestTarget target) {
                WebRequest request = CheckBoxX.this.getWebRequest();
                IRequestParameters requestParameters = request.getRequestParameters();
                StringValue value = requestParameters.getParameterValue(CheckBoxX.this.getParameterName());
                if (!value.isNull()) {
                    Boolean convertedInput = (Boolean)CheckBoxXConverter.INSTANCE.convertToObject(value.toString(), CheckBoxX.this.getLocale());
                    CheckBoxX.this.setModelObject(convertedInput);
                    CheckBoxX.this.onChange(convertedInput, target);
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setMethod(AjaxRequestAttributes.Method.POST);
                attributes.getDynamicExtraParameters().add("return {'" + CheckBoxX.this.getParameterName() + "': Wicket.$(attrs.c).value}");
            }
        }});
    }

    private String getParameterName() {
        return "checkboxx::" + this.getInputName();
    }

    protected void onChange(Boolean value, AjaxRequestTarget target) {
    }

    public CheckBoxXConfig getConfig() {
        return this.config;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)FontAwesomeSettings.get(Application.get()).getCssResourceReference()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(CheckBoxX.class, "css/checkbox-x.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JQueryPluginResourceReference(CheckBoxX.class, "js/checkbox-x.js")));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.$((Component)this).chain((CharSequence)"checkboxX", (Config)this.getConfig(), new Config[0]).get()));
    }

    private static class CheckBoxXConverter
    implements IConverter<Boolean> {
        private static final IConverter<Boolean> INSTANCE = new CheckBoxXConverter();

        private CheckBoxXConverter() {
        }

        public Boolean convertToObject(String value, Locale locale) {
            if ("1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("0".equals(value)) {
                return Boolean.FALSE;
            }
            return null;
        }

        public String convertToString(Boolean value, Locale locale) {
            String s = value == null ? "" : (Boolean.TRUE.equals(value) ? "1" : "0");
            return s;
        }
    }
}

