/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.model.snapshots;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.Label;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class SnapshotEscaper {
    private SnapshotEscaper() {
    }

    public static MetricSnapshot escapeMetricSnapshot(MetricSnapshot v, EscapingScheme scheme) {
        if (scheme == EscapingScheme.ALLOW_UTF8 || scheme == EscapingScheme.UNDERSCORE_ESCAPING) {
            return v;
        }
        ArrayList<DataPointSnapshot> outDataPoints = new ArrayList<DataPointSnapshot>();
        for (DataPointSnapshot dataPointSnapshot : v.getDataPoints()) {
            if (SnapshotEscaper.snapshotNeedsEscaping(dataPointSnapshot, scheme)) {
                outDataPoints.add(dataPointSnapshot.escape(scheme));
                continue;
            }
            outDataPoints.add(dataPointSnapshot);
        }
        return v.escape(scheme, outDataPoints);
    }

    static boolean snapshotNeedsEscaping(DataPointSnapshot d, EscapingScheme scheme) {
        Labels labels = d.getLabels();
        if (SnapshotEscaper.labelsNeedsEscaping(labels, scheme)) {
            return true;
        }
        if (d instanceof SummarySnapshot.SummaryDataPointSnapshot) {
            return SnapshotEscaper.exemplarsNeedsEscaping(((SummarySnapshot.SummaryDataPointSnapshot)d).getExemplars(), scheme);
        }
        if (d instanceof HistogramSnapshot.HistogramDataPointSnapshot) {
            return SnapshotEscaper.exemplarsNeedsEscaping(((HistogramSnapshot.HistogramDataPointSnapshot)d).getExemplars(), scheme);
        }
        if (d instanceof CounterSnapshot.CounterDataPointSnapshot) {
            return SnapshotEscaper.exemplarNeedsEscaping(((CounterSnapshot.CounterDataPointSnapshot)d).getExemplar(), scheme);
        }
        if (d instanceof UnknownSnapshot.UnknownDataPointSnapshot) {
            return SnapshotEscaper.exemplarNeedsEscaping(((UnknownSnapshot.UnknownDataPointSnapshot)d).getExemplar(), scheme);
        }
        if (d instanceof GaugeSnapshot.GaugeDataPointSnapshot) {
            return SnapshotEscaper.exemplarNeedsEscaping(((GaugeSnapshot.GaugeDataPointSnapshot)d).getExemplar(), scheme);
        }
        return false;
    }

    private static boolean labelsNeedsEscaping(Labels labels, EscapingScheme scheme) {
        for (Label l : labels) {
            if (!PrometheusNaming.needsEscaping(l.getName(), scheme)) continue;
            return true;
        }
        return false;
    }

    private static boolean exemplarNeedsEscaping(@Nullable Exemplar exemplar, EscapingScheme scheme) {
        return exemplar != null && SnapshotEscaper.labelsNeedsEscaping(exemplar.getLabels(), scheme);
    }

    private static boolean exemplarsNeedsEscaping(Exemplars exemplars, EscapingScheme scheme) {
        for (Exemplar exemplar : exemplars) {
            if (!SnapshotEscaper.labelsNeedsEscaping(exemplar.getLabels(), scheme)) continue;
            return true;
        }
        return false;
    }

    public static String getSnapshotLabelName(Labels labels, int index, EscapingScheme scheme) {
        if (scheme == EscapingScheme.UNDERSCORE_ESCAPING) {
            return labels.getPrometheusName(index);
        }
        return labels.getName(index);
    }

    public static String getMetadataName(MetricMetadata metadata, EscapingScheme scheme) {
        if (scheme == EscapingScheme.UNDERSCORE_ESCAPING) {
            return metadata.getPrometheusName();
        }
        return metadata.getName();
    }

    public static Labels escapeLabels(Labels labels, EscapingScheme scheme) {
        Labels.Builder outLabelsBuilder = Labels.builder();
        for (Label l : labels) {
            outLabelsBuilder.label(PrometheusNaming.escapeName(l.getName(), scheme), l.getValue());
        }
        return outLabelsBuilder.build();
    }

    public static Exemplars escapeExemplars(Exemplars exemplars, EscapingScheme scheme) {
        ArrayList<Exemplar> escapedExemplars = new ArrayList<Exemplar>(exemplars.size());
        for (Exemplar exemplar : exemplars) {
            escapedExemplars.add(SnapshotEscaper.escapeExemplar(exemplar, scheme));
        }
        return Exemplars.of(escapedExemplars);
    }

    @Nullable
    public static Exemplar escapeExemplar(@Nullable Exemplar exemplar, EscapingScheme scheme) {
        if (exemplar == null) {
            return null;
        }
        return Exemplar.builder().labels(SnapshotEscaper.escapeLabels(exemplar.getLabels(), scheme)).timestampMillis(exemplar.getTimestampMillis()).value(exemplar.getValue()).build();
    }
}

