/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.kurento.jsonrpc.Prop;
import org.kurento.jsonrpc.PropImpl;

public class Props
implements Iterable<Prop> {
    private final Map<String, Object> props;

    public Props() {
        this.props = new HashMap<String, Object>();
    }

    public Props(Map<String, Object> props) {
        this.props = props;
    }

    public Props(String name, Object value) {
        this();
        this.add(name, value);
    }

    public Object getProp(String name) {
        return this.props.get(name);
    }

    public boolean hasProp(String name) {
        return this.props.keySet().contains(name);
    }

    public Props add(String property, Object value) {
        this.props.put(property, value);
        return this;
    }

    public Map<String, Object> getMap() {
        return this.props;
    }

    @Override
    public Iterator<Prop> iterator() {
        final Iterator<Map.Entry<String, Object>> entries = this.props.entrySet().iterator();
        Iterator<Prop> propsIterator = new Iterator<Prop>(){

            @Override
            public boolean hasNext() {
                return entries.hasNext();
            }

            @Override
            public Prop next() {
                Map.Entry entry = (Map.Entry)entries.next();
                return new PropImpl((String)entry.getKey(), entry.getValue());
            }

            @Override
            public void remove() {
                entries.remove();
            }
        };
        return propsIterator;
    }

    public String toString() {
        return this.props.toString();
    }

    public Object removeProp(String name) {
        return this.props.remove(name);
    }
}

