/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.table;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.table.TableContextType;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TableContextBehavior
extends Behavior {
    private final IModel<TableContextType> type;

    public TableContextBehavior() {
        this(TableContextType.Active);
    }

    public TableContextBehavior(TableContextType type) {
        this((IModel<TableContextType>)Model.of((Serializable)((Object)type)));
    }

    public TableContextBehavior(IModel<TableContextType> type) {
        this.type = type;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "tr", "th", "td");
        Attributes.addClass(tag, this.getType().cssClassName());
    }

    public final TableContextType getType() {
        return (TableContextType)this.type.getObject();
    }

    public final TableContextBehavior setType(TableContextType type) {
        this.type.setObject((Object)type);
        return this;
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
    }
}

