/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.crypt;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.openmeetings.util.crypt.ICrypt;
import org.apache.openmeetings.util.crypt.SHA256Implementation;
import org.bouncycastle.crypto.generators.SCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCryptImplementation
implements ICrypt {
    private static final Logger log = LoggerFactory.getLogger(SCryptImplementation.class);
    private static final String SECURE_RND_ALG = "SHA1PRNG";
    private static final ThreadLocal<SecureRandom> rnd = ThreadLocal.withInitial(() -> {
        SecureRandom sr;
        try {
            sr = SecureRandom.getInstance(SECURE_RND_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Failed to get instance of SecureRandom {}", (Object)SECURE_RND_ALG);
            sr = new SecureRandom();
        }
        return sr;
    });
    private static int cost = 16384;
    private static final int KEY_LENGTH = 512;
    private static final int SALT_LENGTH = 200;

    private static byte[] getSalt(int length) {
        byte[] salt = new byte[length];
        rnd.get().nextBytes(salt);
        return salt;
    }

    SCryptImplementation() {
        try (InputStream is = this.getClass().getResourceAsStream("/openmeetings.properties");){
            Properties props = new Properties();
            props.load(is);
            cost = Integer.valueOf(props.getProperty("scrypt.cost", "" + cost));
        }
        catch (Exception e) {
            log.error("Failed to initialize the cost {}", (Object)e.getMessage());
        }
    }

    private static String hash(String str, byte[] salt) {
        byte[] dk = SCrypt.generate((byte[])str.getBytes(StandardCharsets.UTF_8), (byte[])salt, (int)cost, (int)8, (int)8, (int)512);
        return Base64.encodeBase64String((byte[])dk);
    }

    @Override
    public String hash(String str) {
        if (str == null) {
            return null;
        }
        byte[] salt = SCryptImplementation.getSalt(200);
        String h = SCryptImplementation.hash(str, salt);
        return String.format("%s:%s", h, Base64.encodeBase64String((byte[])salt));
    }

    @Override
    public boolean verify(String str, String hash) {
        if (str == null) {
            return hash == null;
        }
        if (hash == null) {
            return false;
        }
        String[] ss = hash.split(":");
        if (ss.length != 2) {
            return false;
        }
        try {
            String h1 = ss[0];
            byte[] salt = Base64.decodeBase64((String)ss[1]);
            String h2 = SCryptImplementation.hash(str, salt);
            return h2.equals(h1);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean fallback(String str, String hash) {
        return SHA256Implementation.verify(str, hash);
    }

    @Override
    public String randomPassword(int length) {
        return Base64.encodeBase64String((byte[])SCryptImplementation.getSalt(length));
    }
}

