/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.mail;

import jakarta.activation.DataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    public ByteArrayDataSource(InputStream is, String type) {
        this.type = type;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            int ch;
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.data = os.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.data = data;
        this.type = type;
    }

    public ByteArrayDataSource(String data, String type) {
        this.data = data.getBytes(StandardCharsets.UTF_8);
        this.type = type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return "dummy";
    }
}

