/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.models;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadDecision;
import org.apache.pulsar.common.stats.Metrics;

public class UnloadCounter {
    long unloadBrokerCount = 0L;
    long unloadBundleCount = 0L;
    @VisibleForTesting
    final Map<UnloadDecision.Label, Map<UnloadDecision.Reason, AtomicLong>> breakdownCounters = Map.of(UnloadDecision.Label.Success, Map.of(UnloadDecision.Reason.Overloaded, new AtomicLong(), UnloadDecision.Reason.Underloaded, new AtomicLong(), UnloadDecision.Reason.Admin, new AtomicLong()), UnloadDecision.Label.Skip, Map.of(UnloadDecision.Reason.HitCount, new AtomicLong(), UnloadDecision.Reason.NoBundles, new AtomicLong(), UnloadDecision.Reason.CoolDown, new AtomicLong(), UnloadDecision.Reason.OutDatedData, new AtomicLong(), UnloadDecision.Reason.NoLoadData, new AtomicLong(), UnloadDecision.Reason.NoBrokers, new AtomicLong(), UnloadDecision.Reason.Unknown, new AtomicLong()), UnloadDecision.Label.Failure, Map.of(UnloadDecision.Reason.Unknown, new AtomicLong()));
    @VisibleForTesting
    double loadAvg;
    @VisibleForTesting
    double loadStd;
    private volatile long updatedAt = 0L;

    public void update(UnloadDecision decision) {
        if (decision.getLabel() == UnloadDecision.Label.Success) {
            ++this.unloadBundleCount;
        }
        this.breakdownCounters.get((Object)decision.getLabel()).get((Object)decision.getReason()).incrementAndGet();
        this.updatedAt = System.currentTimeMillis();
    }

    public void update(UnloadDecision.Label label, UnloadDecision.Reason reason) {
        if (label == UnloadDecision.Label.Success) {
            ++this.unloadBundleCount;
        }
        this.breakdownCounters.get((Object)label).get((Object)reason).incrementAndGet();
        this.updatedAt = System.currentTimeMillis();
    }

    public void updateLoadData(double loadAvg, double loadStd) {
        this.loadAvg = loadAvg;
        this.loadStd = loadStd;
        this.updatedAt = System.currentTimeMillis();
    }

    public void updateUnloadBrokerCount(int unloadBrokerCount) {
        this.unloadBrokerCount += (long)unloadBrokerCount;
        this.updatedAt = System.currentTimeMillis();
    }

    public List<Metrics> toMetrics(String advertisedBrokerAddress) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("metric", "bundleUnloading");
        dimensions.put("broker", advertisedBrokerAddress);
        Metrics m = Metrics.create(dimensions);
        m.put("brk_lb_unload_broker_total", (Object)this.unloadBrokerCount);
        m.put("brk_lb_unload_bundle_total", (Object)this.unloadBundleCount);
        metrics.add(m);
        for (Map.Entry<UnloadDecision.Label, Map<UnloadDecision.Reason, AtomicLong>> etr : this.breakdownCounters.entrySet()) {
            UnloadDecision.Label result = etr.getKey();
            for (Map.Entry<UnloadDecision.Reason, AtomicLong> counter : etr.getValue().entrySet()) {
                UnloadDecision.Reason reason = counter.getKey();
                long count = counter.getValue().longValue();
                HashMap<String, String> dim = new HashMap<String, String>(dimensions);
                dim.put("result", result.toString());
                dim.put("reason", reason.toString());
                Metrics metric = Metrics.create(dim);
                metric.put("brk_lb_unload_broker_breakdown_total", (Object)count);
                metrics.add(metric);
            }
        }
        if (this.loadAvg > 0.0 && this.loadStd > 0.0) {
            HashMap<String, String> dim = new HashMap<String, String>(dimensions);
            dim.put("feature", "max_ema");
            dim.put("stat", "avg");
            Metrics metric = Metrics.create(dim);
            metric.put("brk_lb_resource_usage_stats", (Object)this.loadAvg);
            metrics.add(metric);
            dim = new HashMap(dimensions);
            dim.put("feature", "max_ema");
            dim.put("stat", "std");
            metric = Metrics.create(dim);
            metric.put("brk_lb_resource_usage_stats", (Object)this.loadStd);
            metrics.add(metric);
        }
        return metrics;
    }

    public long updatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Map<UnloadDecision.Label, Map<UnloadDecision.Reason, AtomicLong>> getBreakdownCounters() {
        return this.breakdownCounters;
    }

    @Generated
    public double getLoadAvg() {
        return this.loadAvg;
    }

    @Generated
    public double getLoadStd() {
        return this.loadStd;
    }
}

