/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.retriever;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;

public class ConfiguredObjectRetriever<C extends ConfiguredObject<?>> {
    public Stream<C> retrieve(C parent, Class<C> category) {
        List<Class<C>> hierarchy = this.hierarchy(category, parent.getModel()).collect(Collectors.toList());
        return this.of(hierarchy, parent, this.retrieval(), category);
    }

    private Stream<Class<C>> hierarchy(Class<C> category, Model model) {
        Class parent = model.getParentType(category);
        return parent == null || Objects.equals(category, Broker.class) ? Stream.empty() : Stream.concat(Stream.of(category), this.hierarchy(parent, model));
    }

    private BiFunction<List<Class<C>>, C, Collection<? extends C>> retrieval() {
        return (hierarchy, co) -> hierarchy.isEmpty() ? new ArrayList() : co.getChildren((Class)hierarchy.get(hierarchy.size() - 1));
    }

    private Stream<C> of(List<Class<C>> hierarchy, C node, BiFunction<List<Class<C>>, C, Collection<? extends C>> retrieval, Class<C> category) {
        return Stream.concat(category.isAssignableFrom(node.getClass()) ? Stream.of(node) : Stream.empty(), retrieval.apply(hierarchy, node).stream().flatMap(n -> this.of(hierarchy.subList(0, hierarchy.size() - 1), n, retrieval, category)));
    }
}

