/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.VLSN;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

abstract class BaseEntry<T extends Loggable>
implements LogEntry {
    private final Constructor<T> noArgsConstructor;
    LogEntryType entryType;

    BaseEntry(Class<T> logClass) {
        this.noArgsConstructor = BaseEntry.getNoArgsConstructor(logClass);
    }

    static <T extends Loggable> Constructor<T> getNoArgsConstructor(Class<T> logClass) {
        try {
            return logClass.getConstructor(null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    T newInstanceOfType() {
        return BaseEntry.newInstanceOfType(this.noArgsConstructor);
    }

    static <T extends Loggable> T newInstanceOfType(Constructor<T> noArgsConstructor) {
        try {
            return (T)((Loggable)noArgsConstructor.newInstance(null));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    BaseEntry() {
        this.noArgsConstructor = null;
    }

    public Class<T> getLogClass() {
        return this.noArgsConstructor != null ? this.noArgsConstructor.getDeclaringClass() : null;
    }

    @Override
    public void setLogType(LogEntryType entryType) {
        this.entryType = entryType;
    }

    @Override
    public LogEntryType getLogType() {
        return this.entryType;
    }

    @Override
    public Object getResolvedItem(DatabaseImpl dbImpl) {
        return this.getMainItem();
    }

    @Override
    public boolean isImmediatelyObsolete(DatabaseImpl dbImpl) {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void postLogWork(LogEntryHeader header, long justLoggedLsn, VLSN vlsn) {
    }

    public void postFetchInit(DatabaseImpl dbImpl) {
    }

    @Override
    public LogEntry clone() {
        try {
            return (LogEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpEntry(sb, true);
        return sb.toString();
    }
}

