/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbitration;

import com.sleepycat.je.Durability;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.arbitration.ArbiterProvider;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Logger;

public class DesignatedPrimaryProvider
implements ArbiterProvider {
    private final RepImpl repImpl;
    private final Logger logger;

    DesignatedPrimaryProvider(RepImpl repImpl) {
        this.repImpl = repImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    @Override
    public boolean attemptActivation() {
        if (this.checkDesignatedPrimary()) {
            LoggerUtils.info(this.logger, this.repImpl, "Primary activated; quorum is one.");
            return true;
        }
        LoggerUtils.fine(this.logger, this.repImpl, "Attempted unsuccessfully to activate designated primary");
        return false;
    }

    @Override
    public boolean activationPossible() {
        return this.checkDesignatedPrimary();
    }

    @Override
    public void endArbitration() {
    }

    private boolean checkDesignatedPrimary() {
        return this.repImpl != null && this.repImpl.isDesignatedPrimary() && this.repImpl.getRepNode().getGroup().getElectableGroupSize() == 2;
    }

    @Override
    public int getElectionQuorumSize(QuorumPolicy quorumPolicy) {
        return 1;
    }

    @Override
    public int getAckCount(Durability.ReplicaAckPolicy ackPolicy) {
        return 0;
    }

    @Override
    public boolean shouldEndArbitration(ReplicationMutableConfig newConfig) {
        return !newConfig.getDesignatedPrimary();
    }
}

