/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.datetime;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.qpid.server.query.engine.evaluator.settings.QuerySettings;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class ExtractExpression<T, R>
extends AbstractFunctionExpression<T, Number> {
    private final FunctionParameterTypePredicate<R> _dateTimeValidator = FunctionParameterTypePredicate.builder().allowDateTimeTypes().allowStrings().build();

    public ExtractExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireParameters(2, args, this);
    }

    @Override
    public Number apply(T value) {
        QuerySettings querySettings = (QuerySettings)this.ctx().get("query.settings");
        ChronoUnit datePart = (ChronoUnit)this.evaluateChild(0, null);
        R dateTime = this.evaluateChild(1, value, this._dateTimeValidator);
        Instant instant = DateTimeConverter.toInstantMapper().apply(dateTime);
        ZonedDateTime zonedDateTime = instant.atZone(querySettings.getZoneId());
        switch (datePart) {
            case YEARS: {
                return zonedDateTime.getYear();
            }
            case MONTHS: {
                return zonedDateTime.getMonthValue();
            }
            case WEEKS: {
                return zonedDateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
            }
            case DAYS: {
                return zonedDateTime.getDayOfMonth();
            }
            case HOURS: {
                return zonedDateTime.get(ChronoField.HOUR_OF_DAY);
            }
            case MINUTES: {
                return zonedDateTime.getMinute();
            }
            case SECONDS: {
                return zonedDateTime.getSecond();
            }
            case MILLIS: {
                return NumberConverter.narrow(zonedDateTime.getLong(ChronoField.MILLI_OF_SECOND));
            }
        }
        throw QueryEvaluationException.of("Datepart '%s' not supported", datePart);
    }
}

