/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport.websocket;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.AcceptingTransport;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.apache.qpid.server.transport.MultiVersionProtocolEngine;
import org.apache.qpid.server.transport.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketProvider
implements AcceptingTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketProvider.class);
    private static final String AMQP_WEBSOCKET_SUBPROTOCOL = "amqp";
    private final Transport _transport;
    private final SslContextFactory.Server _sslContextFactory;
    private final AmqpPort<?> _port;
    private final Broker<?> _broker;
    private final MultiVersionProtocolEngineFactory _factory;
    private Server _server;
    private final List<ConnectionWrapper> _activeConnections = new CopyOnWriteArrayList<ConnectionWrapper>();
    private final WebSocketIdleTimeoutChecker _idleTimeoutChecker = new WebSocketIdleTimeoutChecker();
    private final AtomicBoolean _closed = new AtomicBoolean();

    WebSocketProvider(Transport transport, SSLContext sslContext, AmqpPort<?> port, Set<Protocol> supported, Protocol defaultSupportedProtocolReply) {
        this._transport = transport;
        this._sslContextFactory = transport == Transport.WSS ? this.createSslContextFactory(port) : null;
        this._port = port;
        this._broker = (Broker)port.getParent();
        this._factory = new MultiVersionProtocolEngineFactory(this._broker, supported, defaultSupportedProtocolReply, this._port, this._transport);
    }

    public void start() {
        ServerConnector connector;
        this._idleTimeoutChecker.start();
        this._server = new Server((ThreadPool)new QBBTrackingThreadPool());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
        httpConnectionFactory.getHttpConfiguration().setSendXPoweredBy(false);
        if (this._transport == Transport.WS) {
            connector = new ServerConnector(this._server, new ConnectionFactory[]{httpConnectionFactory});
        } else if (this._transport == Transport.WSS) {
            connector = new ServerConnector(this._server, this._sslContextFactory, new ConnectionFactory[]{httpConnectionFactory});
            connector.addBean((Object)new SslHandshakeListener(){

                public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
                    SSLEngine sslEngine = event.getSSLEngine();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.info("TLS handshake failed: host='{}', port={}", new Object[]{sslEngine.getPeerHost(), sslEngine.getPeerPort(), failure});
                    } else {
                        LOGGER.info("TLS handshake failed: host='{}', port={}: {}", new Object[]{sslEngine.getPeerHost(), sslEngine.getPeerPort(), String.valueOf(failure)});
                    }
                }
            });
        } else {
            throw new IllegalArgumentException("Unexpected transport on port " + this._port.getName() + ":" + String.valueOf(this._transport));
        }
        String bindingAddress = this._port.getBindingAddress();
        if (bindingAddress != null && !bindingAddress.trim().isEmpty() && !"*".equals(bindingAddress.trim())) {
            connector.setHost(bindingAddress.trim());
        }
        connector.setPort(this._port.getPort());
        this._server.addConnector((Connector)connector);
        final JettyWebSocketCreator jettyWebSocketCreator = (request, response) -> {
            response.setAcceptedSubProtocol(AMQP_WEBSOCKET_SUBPROTOCOL);
            return new AmqpWebSocket(request.getCertificates());
        };
        JettyWebSocketServlet websocketServlet = new JettyWebSocketServlet(){

            public void configure(JettyWebSocketServletFactory factory) {
                factory.setMaxBinaryMessageSize(0L);
                factory.setCreator(jettyWebSocketCreator);
            }
        };
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.setContextPath("/");
        servletContextHandler.addServlet(new ServletHolder((Servlet)websocketServlet), "");
        servletContextHandler.setServer(this._server);
        WebSocketServerComponents.ensureWebSocketComponents((Server)this._server, (ContextHandler)servletContextHandler);
        JettyWebSocketServerContainer.ensureContainer((ServletContext)servletContextHandler.getServletContext()).addMapping("/", jettyWebSocketCreator);
        ContextHandlerCollection handlers = new ContextHandlerCollection(new ContextHandler[0]);
        handlers.addHandler((Handler)servletContextHandler);
        handlers.addHandler((Handler)new Handler.Abstract(){

            public boolean handle(Request request, Response response, Callback callback) {
                if (response.isCommitted()) {
                    return false;
                }
                callback.succeeded();
                response.setStatus(403);
                return true;
            }
        });
        this._server.setHandler((Handler)handlers);
        try {
            this._server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerScopedRuntimeException((Throwable)e);
        }
    }

    private SslContextFactory.Server createSslContextFactory(final AmqpPort<?> port) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server(){

            public void customize(SSLEngine sslEngine) {
                super.customize(sslEngine);
                SSLUtil.updateEnabledCipherSuites((SSLEngine)sslEngine, (List)port.getTlsCipherSuiteAllowList(), (List)port.getTlsCipherSuiteDenyList());
                SSLUtil.updateEnabledTlsProtocols((SSLEngine)sslEngine, (List)port.getTlsProtocolAllowList(), (List)port.getTlsProtocolDenyList());
                if (port.getTlsCipherSuiteAllowList() != null && !port.getTlsCipherSuiteAllowList().isEmpty()) {
                    SSLParameters sslParameters = sslEngine.getSSLParameters();
                    sslParameters.setUseCipherSuitesOrder(true);
                    sslEngine.setSSLParameters(sslParameters);
                }
            }
        };
        sslContextFactory.setSslContext(port.getSSLContext());
        sslContextFactory.setNeedClientAuth(port.getNeedClientAuth());
        sslContextFactory.setWantClientAuth(port.getWantClientAuth());
        return sslContextFactory;
    }

    public void close() {
        this._closed.set(true);
        this._idleTimeoutChecker.wakeup();
        try {
            this._server.stop();
        }
        catch (Exception e) {
            LOGGER.warn("Error closing the web socket for : " + this._port.getPort(), (Throwable)e);
            this._server = null;
        }
    }

    public int getAcceptingPort() {
        Server server = this._server;
        return server == null || server.getConnectors().length == 0 || !(server.getConnectors()[0] instanceof ServerConnector) ? this._port.getPort() : ((ServerConnector)server.getConnectors()[0]).getLocalPort();
    }

    public boolean updatesSSLContext() {
        if (this._sslContextFactory != null) {
            try {
                this._sslContextFactory.reload(sslContextFactory -> {
                    SslContextFactory.Server server = (SslContextFactory.Server)sslContextFactory;
                    server.setSslContext(this._port.getSSLContext());
                    server.setNeedClientAuth(this._port.getNeedClientAuth());
                    server.setWantClientAuth(this._port.getWantClientAuth());
                });
                return true;
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Unexpected exception on reload of ssl context factory", (Throwable)e);
            }
        }
        return false;
    }

    private class WebSocketIdleTimeoutChecker
    extends Thread {
        public WebSocketIdleTimeoutChecker() {
            this.setName("WebSocket Idle Checker: " + String.valueOf(WebSocketProvider.this._port));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!WebSocketProvider.this._closed.get()) {
                ConnectionWrapper connectionToTick = null;
                long currentTime = System.currentTimeMillis();
                WebSocketIdleTimeoutChecker webSocketIdleTimeoutChecker = this;
                synchronized (webSocketIdleTimeoutChecker) {
                    long nextTick = Long.MAX_VALUE;
                    for (ConnectionWrapper connection : WebSocketProvider.this._activeConnections) {
                        MultiVersionProtocolEngine engine = connection._protocolEngine;
                        AggregateTicker ticker = engine.getAggregateTicker();
                        long tick = ticker.getTimeToNextTick(currentTime);
                        if (tick <= 0L) {
                            connectionToTick = connection;
                            nextTick = -1L;
                            break;
                        }
                        if (tick >= nextTick) continue;
                        nextTick = tick;
                    }
                    if (nextTick > 0L) {
                        try {
                            this.wait(nextTick);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                if (connectionToTick == null) continue;
                connectionToTick.tick();
            }
        }

        private synchronized void wakeup() {
            this.notifyAll();
        }
    }

    private static class QBBTrackingThreadPool
    extends QueuedThreadPool {
        private final ThreadFactory _threadFactory = QpidByteBuffer.createQpidByteBufferTrackingThreadFactory(x$0 -> QBBTrackingThreadPool.access$001(this, x$0));

        private QBBTrackingThreadPool() {
        }

        public Thread newThread(Runnable runnable) {
            return this._threadFactory.newThread(runnable);
        }
    }

    @WebSocket
    public class AmqpWebSocket {
        final X509Certificate[] _certificates;
        private volatile QpidByteBuffer _netInputBuffer;
        private volatile MultiVersionProtocolEngine _protocolEngine;
        private volatile ConnectionWrapper _connectionWrapper;
        private volatile boolean _unexpectedByteBufferSizeReported;

        AmqpWebSocket(X509Certificate[] certificates) {
            this._netInputBuffer = QpidByteBuffer.allocateDirect((int)WebSocketProvider.this._broker.getNetworkBufferSize());
            this._certificates = certificates;
        }

        @OnWebSocketOpen
        public void onWebSocketConnect(Session session) {
            SocketAddress localAddress = session.getLocalSocketAddress();
            SocketAddress remoteAddress = session.getRemoteSocketAddress();
            this._protocolEngine = WebSocketProvider.this._factory.newProtocolEngine(remoteAddress);
            session.setIdleTimeout(Duration.ZERO);
            this._connectionWrapper = new ConnectionWrapper(session, localAddress, remoteAddress, this._protocolEngine, WebSocketProvider.this._server.getThreadPool());
            if (this._certificates != null && this._certificates.length > 0) {
                this._connectionWrapper.setPeerCertificate(this._certificates[0]);
            }
            this._protocolEngine.setNetworkConnection((ServerNetworkConnection)this._connectionWrapper);
            this._protocolEngine.setWorkListener(object -> WebSocketProvider.this._server.getThreadPool().execute(() -> this._connectionWrapper.doWork()));
            WebSocketProvider.this._activeConnections.add(this._connectionWrapper);
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnWebSocketMessage
        public void onWebSocketBinary(ByteBuffer payload, boolean last, org.eclipse.jetty.websocket.api.Callback callback) {
            ConnectionWrapper connectionWrapper = this._connectionWrapper;
            synchronized (connectionWrapper) {
                this._protocolEngine.clearWork();
                try {
                    this._protocolEngine.setIOThread(Thread.currentThread());
                    Iterator iter = this._protocolEngine.processPendingIterator();
                    while (iter.hasNext()) {
                        ((Runnable)iter.next()).run();
                    }
                    byte[] bytes = new byte[payload.remaining()];
                    payload.get(bytes);
                    int len = bytes.length;
                    int offset = 0;
                    int remaining = len;
                    do {
                        int chunkLen = Math.min(remaining, this._netInputBuffer.remaining());
                        this._netInputBuffer.put(bytes, offset, chunkLen);
                        remaining -= chunkLen;
                        offset += chunkLen;
                        this._netInputBuffer.flip();
                        this._protocolEngine.received(this._netInputBuffer);
                        this._connectionWrapper.doWrite();
                        this.restoreApplicationBufferForWrite();
                    } while (remaining > 0);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Read {} byte(s)", (Object)len);
                    }
                }
                finally {
                    this._protocolEngine.setIOThread(null);
                }
            }
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
        }

        private void restoreApplicationBufferForWrite() {
            try (QpidByteBuffer oldNetInputBuffer = this._netInputBuffer;){
                int unprocessedDataLength = this._netInputBuffer.remaining();
                this._netInputBuffer.limit(this._netInputBuffer.capacity());
                this._netInputBuffer = oldNetInputBuffer.slice();
                this._netInputBuffer.limit(unprocessedDataLength);
            }
            if (this._netInputBuffer.limit() != this._netInputBuffer.capacity()) {
                this._netInputBuffer.position(this._netInputBuffer.limit());
                this._netInputBuffer.limit(this._netInputBuffer.capacity());
            } else {
                try (QpidByteBuffer currentBuffer = this._netInputBuffer;){
                    int newBufSize;
                    if (currentBuffer.capacity() < WebSocketProvider.this._broker.getNetworkBufferSize()) {
                        newBufSize = WebSocketProvider.this._broker.getNetworkBufferSize();
                    } else {
                        newBufSize = currentBuffer.capacity() + WebSocketProvider.this._broker.getNetworkBufferSize();
                        this.reportUnexpectedByteBufferSizeUsage();
                    }
                    this._netInputBuffer = QpidByteBuffer.allocateDirect((int)newBufSize);
                    this._netInputBuffer.put(currentBuffer);
                }
            }
        }

        private void reportUnexpectedByteBufferSizeUsage() {
            if (!this._unexpectedByteBufferSizeReported) {
                LOGGER.info("At least one frame unexpectedly does not fit into default byte buffer size ({}B) on a connection {}.", (Object)WebSocketProvider.this._broker.getNetworkBufferSize(), (Object)this);
                this._unexpectedByteBufferSizeReported = true;
            }
        }

        @OnWebSocketMessage
        public void onWebSocketText(Session sess, String text) {
            LOGGER.info("Unexpected websocket text message received, closing connection");
            sess.close();
        }

        @OnWebSocketClose
        public void onWebSocketClose(int statusCode, String reason) {
            if (this._protocolEngine != null) {
                this._protocolEngine.closed();
            }
            WebSocketProvider.this._activeConnections.remove(this._connectionWrapper);
            WebSocketProvider.this._idleTimeoutChecker.wakeup();
            this._netInputBuffer.dispose();
        }
    }

    private class ConnectionWrapper
    implements ServerNetworkConnection,
    ByteBufferSender {
        private final Session _connection;
        private final SocketAddress _localAddress;
        private final SocketAddress _remoteAddress;
        private final ConcurrentLinkedQueue<QpidByteBuffer> _buffers = new ConcurrentLinkedQueue();
        private final MultiVersionProtocolEngine _protocolEngine;
        private final ThreadPool _threadPool;
        private final Runnable _tickJob;
        private Certificate _certificate;
        private long _maxWriteIdleMillis;
        private long _maxReadIdleMillis;

        public ConnectionWrapper(Session connection, SocketAddress localAddress, SocketAddress remoteAddress, MultiVersionProtocolEngine protocolEngine, ThreadPool threadPool) {
            this._connection = connection;
            this._localAddress = localAddress;
            this._remoteAddress = remoteAddress;
            this._protocolEngine = protocolEngine;
            this._threadPool = threadPool;
            this._tickJob = () -> {
                ConnectionWrapper connectionWrapper = this;
                synchronized (connectionWrapper) {
                    protocolEngine.getAggregateTicker().tick(System.currentTimeMillis());
                    this.doWrite();
                }
            };
        }

        public ByteBufferSender getSender() {
            return this;
        }

        public void start() {
        }

        public boolean isDirectBufferPreferred() {
            return false;
        }

        public void send(QpidByteBuffer msg) {
            if (msg.remaining() > 0) {
                this._buffers.add(msg.duplicate());
            }
            msg.position(msg.limit());
        }

        public void flush() {
        }

        public void close() {
            this._connection.close();
        }

        public SocketAddress getRemoteAddress() {
            return this._remoteAddress;
        }

        public SocketAddress getLocalAddress() {
            return this._localAddress;
        }

        public void setMaxWriteIdleMillis(long millis) {
            this._maxWriteIdleMillis = millis;
        }

        public void setMaxReadIdleMillis(long millis) {
            this._maxReadIdleMillis = millis;
        }

        public Principal getPeerPrincipal() {
            return this._certificate instanceof X509Certificate ? ((X509Certificate)this._certificate).getSubjectX500Principal() : null;
        }

        public Certificate getPeerCertificate() {
            return this._certificate;
        }

        public long getMaxReadIdleMillis() {
            return this._maxReadIdleMillis;
        }

        public long getMaxWriteIdleMillis() {
            return this._maxWriteIdleMillis;
        }

        public void addSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        }

        public void removeSchedulingDelayNotificationListeners(SchedulingDelayNotificationListener listener) {
        }

        public String getTransportInfo() {
            return this._connection.getProtocolVersion();
        }

        public long getScheduledTime() {
            return 0L;
        }

        public String getSelectedHost() {
            return null;
        }

        void setPeerCertificate(Certificate certificate) {
            this._certificate = certificate;
        }

        public synchronized void doWrite() {
            QpidByteBuffer buf;
            int size = 0;
            ArrayList<QpidByteBuffer> toBeWritten = new ArrayList<QpidByteBuffer>(this._buffers.size());
            while ((buf = this._buffers.poll()) != null) {
                size += buf.remaining();
                toBeWritten.add(buf);
            }
            byte[] data = new byte[size];
            int offset = 0;
            for (QpidByteBuffer tmp : toBeWritten) {
                int remaining = tmp.remaining();
                tmp.get(data, offset, remaining);
                tmp.dispose();
                offset += remaining;
            }
            if (size > 0) {
                this._connection.sendBinary(ByteBuffer.wrap(data), org.eclipse.jetty.websocket.api.Callback.NOOP);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Written {} byte(s)", (Object)data.length);
                }
            }
        }

        public synchronized void doWork() {
            this._protocolEngine.clearWork();
            try {
                this._protocolEngine.setIOThread(Thread.currentThread());
                Iterator iter = this._protocolEngine.processPendingIterator();
                while (iter.hasNext()) {
                    ((Runnable)iter.next()).run();
                }
                this.doWrite();
                WebSocketProvider.this._idleTimeoutChecker.wakeup();
            }
            finally {
                this._protocolEngine.setIOThread(null);
            }
        }

        public void tick() {
            this._threadPool.execute(this._tickJob);
        }
    }
}

