/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.statcap.StatUtils;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.utilint.StatLogger;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class EnvStatsLogger
implements EnvConfigObserver {
    private final EnvironmentImpl env;
    private StatLogger stlog;
    public static final String STATFILENAME = "je.config";
    public static final String STATFILEEXT = "csv";
    private static final String DELIMITER = ",";
    private static final String QUOTE = "\"";
    private static final int MAXROWCOUNT = 1000;
    private static final int MAXFILECOUNT = 2;
    private final StringBuffer sb = new StringBuffer();
    private final StringBuffer valb = new StringBuffer();
    private final Logger logger;

    public EnvStatsLogger(EnvironmentImpl env) {
        this.env = env;
        this.logger = LoggerUtils.getLogger(this.getClass());
        String statdir = env.getConfigManager().get(EnvironmentParams.STATS_FILE_DIRECTORY);
        File statdirf = statdir == null || statdir.equals("") ? env.getEnvironmentHome() : new File(statdir);
        try {
            this.stlog = new StatLogger(statdirf, STATFILENAME, STATFILEEXT, 2, 1000);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error accessing statistics capture file je.config.csv IO Exception: " + e);
        }
    }

    public void log() {
        TreeMap<String, String> envConfigMap = new TreeMap<String, String>();
        EnvironmentConfig mc = this.env.cloneConfig();
        for (String string : EnvironmentParams.SUPPORTED_PARAMS.keySet()) {
            envConfigMap.put("envcfg:" + string, mc.getConfigParam(string));
        }
        this.addSystemStats(envConfigMap);
        this.sb.setLength(0);
        this.valb.setLength(0);
        this.sb.append("time");
        this.valb.append(StatUtils.getDate(System.currentTimeMillis()));
        for (Map.Entry entry : envConfigMap.entrySet()) {
            if (this.sb.length() != 0) {
                this.sb.append(DELIMITER);
                this.valb.append(DELIMITER);
            }
            this.sb.append((String)entry.getKey());
            this.valb.append(QUOTE + (String)entry.getValue() + QUOTE);
        }
        try {
            this.stlog.setHeader(this.sb.toString());
            this.stlog.logDelta(this.valb.toString());
        }
        catch (IOException e) {
            LoggerUtils.warning(this.logger, this.env, " Error accessing environment statistics file je.config.csv IO Exception: " + e);
        }
        this.sb.setLength(0);
        this.valb.setLength(0);
    }

    @Override
    public void envConfigUpdate(DbConfigManager configMgr, EnvironmentMutableConfig newConfig) {
        this.log();
    }

    private void addSystemStats(Map<String, String> statmap) {
        OperatingSystemMXBean osbean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        statmap.put("je:version", JEVersion.CURRENT_VERSION.getVersionString());
        statmap.put("java:version", System.getProperty("java.version"));
        statmap.put("java:vendor", System.getProperty("java.vendor"));
        statmap.put("os:name", osbean.getName());
        statmap.put("os:version", osbean.getVersion());
        statmap.put("mc:arch", osbean.getArch());
        statmap.put("mc:processors", Integer.toString(osbean.getAvailableProcessors()));
        statmap.put("java:minMemory", Long.toString(memoryBean.getHeapMemoryUsage().getInit()));
        statmap.put("java:maxMemory", Long.toString(memoryBean.getHeapMemoryUsage().getMax()));
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        this.sb.setLength(0);
        for (String arg : args) {
            this.sb.append(" " + arg);
        }
        statmap.put("java:args", this.sb.toString());
        this.sb.setLength(0);
    }
}

