/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.CollectionUtils;
import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class MapStat<T, C extends MapStatComponent<T, C>>
extends Stat<String> {
    private static final long serialVersionUID = 1L;
    protected final Map<String, C> statMap = new TreeMap<String, C>();

    protected MapStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapStat(MapStat<T, C> other) {
        super(other.definition);
        MapStat mapStat = this;
        synchronized (mapStat) {
            MapStat<T, C> mapStat2 = other;
            synchronized (mapStat2) {
                for (Map.Entry<String, C> entry : other.statMap.entrySet()) {
                    this.statMap.put(entry.getKey(), ((MapStatComponent)entry.getValue()).copy());
                }
            }
        }
    }

    public synchronized void removeStat(String key) {
        assert (key != null);
        this.statMap.remove(key);
    }

    public synchronized SortedMap<String, T> getMap() {
        TreeMap ret = null;
        for (Map.Entry<String, C> entry : this.statMap.entrySet()) {
            MapStatComponent stat = (MapStatComponent)entry.getValue();
            if (stat.isNotSet()) continue;
            if (ret == null) {
                ret = new TreeMap();
            }
            ret.put(entry.getKey(), stat.get());
        }
        if (ret == null) {
            return CollectionUtils.emptySortedMap();
        }
        return ret;
    }

    @Override
    public String get() {
        return this.getFormattedValue(false);
    }

    @Override
    public synchronized void clear() {
        if (this.definition.getType() == StatDefinition.StatType.INCREMENTAL) {
            for (MapStatComponent stat : this.statMap.values()) {
                stat.clear();
            }
        }
    }

    @Override
    protected String getFormattedValue() {
        return this.getFormattedValue(true);
    }

    private synchronized String getFormattedValue(boolean useCommas) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, C> entry : this.statMap.entrySet()) {
            MapStatComponent value = (MapStatComponent)entry.getValue();
            if (value.isNotSet()) continue;
            if (!first) {
                sb.append(';');
            } else {
                first = false;
            }
            sb.append(entry.getKey()).append('=');
            String formattedValue = value.getFormattedValue(useCommas);
            assert (useCommas || formattedValue.indexOf(44) == -1) : "Formatted value doesn't obey useCommas: " + formattedValue;
            sb.append(formattedValue);
        }
        return sb.toString();
    }

    @Override
    public synchronized boolean isNotSet() {
        for (MapStatComponent stat : this.statMap.values()) {
            if (stat.isNotSet()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void set(String value) {
        throw new UnsupportedOperationException("The set method is not supported");
    }

    @Override
    public void add(Stat<String> other) {
        throw new UnsupportedOperationException("The add method is not supported");
    }

    @Override
    public synchronized Stat<String> copyAndClear() {
        return super.copyAndClear();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

