/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelVersion {
    private static final Pattern MODEL_VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)$");
    private final int _major;
    private final int _minor;

    public static ModelVersion fromString(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("Cannot parse null");
        }
        Matcher matcher = MODEL_VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Could not parse model version string '%s'", versionString));
        }
        return new ModelVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
    }

    public ModelVersion(int major, int minor) {
        this._major = major;
        this._minor = minor;
    }

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public boolean lessThan(ModelVersion other) {
        return this.getMajor() < other.getMajor() || this.getMajor() == other.getMajor() && this.getMinor() < other.getMinor();
    }

    public String toString() {
        return this._major + "." + this._minor;
    }
}

