/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.limit;

import java.util.Optional;

@FunctionalInterface
public interface ConnectionSlot
extends Runnable {
    public void free();

    @Override
    default public void run() {
        this.free();
    }

    default public ConnectionSlot chainTo(ConnectionSlot secondarySlot) {
        if (secondarySlot == null || secondarySlot instanceof FreeSlot) {
            return this;
        }
        ConnectionSlot primarySlot = this;
        return () -> {
            try {
                secondarySlot.free();
            }
            finally {
                primarySlot.free();
            }
        };
    }

    public static final class FreeSlot
    implements ConnectionSlot {
        public static final FreeSlot INSTANCE = new FreeSlot();

        private FreeSlot() {
        }

        @Override
        public void free() {
        }

        @Override
        public ConnectionSlot chainTo(ConnectionSlot secondarySlot) {
            return Optional.ofNullable(secondarySlot).orElse(this);
        }
    }
}

