/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.server.store.serializer.v1.Deserializer;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

class VersionRecord
implements Record {
    private final byte[] _versionBytes = "v1.0".getBytes(StandardCharsets.UTF_8);

    VersionRecord() {
    }

    @Override
    public RecordType getType() {
        return RecordType.VERSION;
    }

    @Override
    public void writeData(Serializer output) throws IOException {
        output.writeInt(this._versionBytes.length);
        output.write(this._versionBytes);
    }

    public static VersionRecord read(Deserializer deserializer) throws IOException {
        byte[] data = deserializer.readBytes(deserializer.readInt());
        String version = new String(data, StandardCharsets.UTF_8);
        if (!version.equals("v1.0")) {
            throw new IllegalArgumentException("Unsupported version: " + version);
        }
        return new VersionRecord();
    }
}

