/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl;

import com.alipay.remoting.CustomSerializer;
import com.alipay.remoting.CustomSerializerManager;
import com.alipay.remoting.rpc.RpcConfigManager;
import com.alipay.sofa.jraft.rpc.ProtobufSerializer;
import com.alipay.sofa.jraft.rpc.RaftRpcFactory;
import com.alipay.sofa.jraft.rpc.RpcClient;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.alipay.sofa.jraft.rpc.impl.BoltRpcClient;
import com.alipay.sofa.jraft.rpc.impl.BoltRpcServer;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.SPI;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI
public class BoltRaftRpcFactory
implements RaftRpcFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BoltRaftRpcFactory.class);
    static final int CHANNEL_WRITE_BUF_LOW_WATER_MARK = SystemPropertyUtil.getInt("bolt.channel_write_buf_low_water_mark", 262144);
    static final int CHANNEL_WRITE_BUF_HIGH_WATER_MARK = SystemPropertyUtil.getInt("bolt.channel_write_buf_high_water_mark", 524288);

    @Override
    public void registerProtobufSerializer(String className, Object ... args) {
        CustomSerializerManager.registerCustomSerializer((String)className, (CustomSerializer)ProtobufSerializer.INSTANCE);
    }

    @Override
    public RpcClient createRpcClient(RaftRpcFactory.ConfigHelper<RpcClient> helper) {
        com.alipay.remoting.rpc.RpcClient boltImpl = new com.alipay.remoting.rpc.RpcClient();
        BoltRpcClient rpcClient = new BoltRpcClient(boltImpl);
        if (helper != null) {
            helper.config(rpcClient);
        }
        return rpcClient;
    }

    @Override
    public RpcServer createRpcServer(Endpoint endpoint, RaftRpcFactory.ConfigHelper<RpcServer> helper) {
        int port = Requires.requireNonNull(endpoint, "endpoint").getPort();
        Requires.requireTrue(port > 0 && port < 65535, "port out of range:" + port);
        com.alipay.remoting.rpc.RpcServer boltImpl = new com.alipay.remoting.rpc.RpcServer(port, true, false);
        BoltRpcServer rpcServer = new BoltRpcServer(boltImpl);
        if (helper != null) {
            helper.config(rpcServer);
        }
        return rpcServer;
    }

    @Override
    public void ensurePipeline() {
        if (RpcConfigManager.dispatch_msg_list_in_default_executor()) {
            System.setProperty("bolt.rpc.dispatch-msg-list-in-default-executor", "false");
            LOG.warn("JRaft SET {} to be false for replicator pipeline optimistic.", (Object)"bolt.rpc.dispatch-msg-list-in-default-executor");
        }
    }
}

