/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.sedona.common.Functions;
import org.apache.sedona.common.enums.FileDataSplitter;
import org.apache.sedona.common.enums.GeometryType;
import org.apache.sedona.common.utils.FormatUtils;
import org.apache.sedona.common.utils.GeoHashDecoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.gml2.GMLReader;
import org.locationtech.jts.io.kml.KMLReader;
import org.xml.sax.SAXException;

public class Constructors {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();

    public static Geometry geomFromWKT(String wkt, int srid) throws ParseException {
        if (wkt == null) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry geomFromEWKT(String ewkt) throws ParseException {
        if (ewkt == null) {
            return null;
        }
        int SRID = 0;
        String wkt = ewkt;
        int index = ewkt.indexOf("SRID=");
        if (index != -1) {
            int semicolonIndex = ewkt.indexOf(59, index);
            if (semicolonIndex != -1) {
                SRID = Integer.parseInt(ewkt.substring(index + 5, semicolonIndex));
                wkt = ewkt.substring(semicolonIndex + 1);
            } else {
                throw new ParseException("Invalid EWKT string");
            }
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), SRID);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry geomFromWKB(byte[] wkb) throws ParseException {
        return Constructors.geomFromWKB(wkb, -1);
    }

    public static Geometry geomFromWKB(byte[] wkb, int SRID) throws ParseException {
        Geometry geom = new WKBReader().read(wkb);
        if (geom.getFactory().getSRID() != geom.getSRID() || SRID >= 0 && geom.getSRID() != SRID) {
            if (SRID < 0) {
                SRID = geom.getSRID();
            }
            return Functions.setSRID(geom, SRID);
        }
        return geom;
    }

    public static Geometry pointFromWKB(byte[] wkb) throws ParseException {
        return Constructors.pointFromWKB(wkb, -1);
    }

    public static Geometry pointFromWKB(byte[] wkb, int srid) throws ParseException {
        Geometry geom = Constructors.geomFromWKB(wkb, srid);
        if (!(geom instanceof Point)) {
            return null;
        }
        return geom;
    }

    public static Geometry lineFromWKB(byte[] wkb) throws ParseException {
        return Constructors.lineFromWKB(wkb, -1);
    }

    public static Geometry lineFromWKB(byte[] wkb, int srid) throws ParseException {
        Geometry geom = Constructors.geomFromWKB(wkb, srid);
        if (!(geom instanceof LineString)) {
            return null;
        }
        return geom;
    }

    public static Geometry mPointFromText(String wkt, int srid) throws ParseException {
        if (wkt == null || !wkt.startsWith("MULTIPOINT")) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry mLineFromText(String wkt, int srid) throws ParseException {
        if (wkt == null || !wkt.startsWith("MULTILINESTRING")) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry mPolyFromText(String wkt, int srid) throws ParseException {
        if (wkt == null || !wkt.startsWith("MULTIPOLYGON")) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry geomCollFromText(String wkt, int srid) throws ParseException {
        if (wkt == null || !wkt.startsWith("GEOMETRYCOLLECTION")) {
            return null;
        }
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return new WKTReader(geometryFactory).read(wkt);
    }

    public static Geometry point(double x, double y) {
        return GEOMETRY_FACTORY.createPoint(new Coordinate(x, y));
    }

    public static Geometry makePointM(double x, double y, double m3) {
        return GEOMETRY_FACTORY.createPoint(new CoordinateXYM(x, y, m3));
    }

    public static Geometry makePoint(Double x, Double y, Double z, Double m3) {
        GeometryFactory geometryFactory = GEOMETRY_FACTORY;
        if (x == null || y == null) {
            return null;
        }
        if (z == null && m3 == null) {
            return geometryFactory.createPoint(new Coordinate(x, y));
        }
        if (z != null && m3 == null) {
            return geometryFactory.createPoint(new Coordinate(x, y, z));
        }
        if (z == null) {
            return geometryFactory.createPoint(new CoordinateXYZM(x, y, 0.0, m3));
        }
        return geometryFactory.createPoint(new CoordinateXYZM(x, y, z, m3));
    }

    public static Geometry pointZ(double x, double y, double z, int srid) {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return geometryFactory.createPoint(new Coordinate(x, y, z));
    }

    public static Geometry pointM(double x, double y, double m3, int srid) {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return geometryFactory.createPoint(new CoordinateXYZM(x, y, 0.0, m3));
    }

    public static Geometry pointZM(double x, double y, double z, double m3, int srid) {
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        return geometryFactory.createPoint(new CoordinateXYZM(x, y, z, m3));
    }

    public static Geometry geomFromText(String geomString, String geomFormat, GeometryType geometryType) {
        FileDataSplitter fileDataSplitter = FileDataSplitter.getFileDataSplitter(geomFormat);
        FormatUtils formatMapper = new FormatUtils(fileDataSplitter, false, geometryType);
        try {
            return formatMapper.readGeometry(geomString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry geomFromText(String geomString, FileDataSplitter fileDataSplitter) {
        FormatUtils formatMapper = new FormatUtils(fileDataSplitter, false);
        try {
            return formatMapper.readGeometry(geomString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry pointFromText(String geomString, String geomFormat) {
        return Constructors.geomFromText(geomString, geomFormat, GeometryType.POINT);
    }

    public static Geometry polygonFromText(String geomString, String geomFormat) {
        return Constructors.geomFromText(geomString, geomFormat, GeometryType.POLYGON);
    }

    public static Geometry lineStringFromText(String geomString, String geomFormat) {
        return Constructors.geomFromText(geomString, geomFormat, GeometryType.LINESTRING);
    }

    public static Geometry lineFromText(String geomString) {
        FileDataSplitter fileDataSplitter = FileDataSplitter.WKT;
        Geometry geometry = Constructors.geomFromText(geomString, fileDataSplitter);
        if (geometry.getGeometryType().contains("LineString")) {
            return geometry;
        }
        return null;
    }

    public static Geometry polygonFromEnvelope(double minX, double minY, double maxX, double maxY) {
        Coordinate[] coordinates;
        coordinates = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), coordinates[0]};
        return GEOMETRY_FACTORY.createPolygon(coordinates);
    }

    public static Geometry makeEnvelope(double minX, double minY, double maxX, double maxY, int srid) {
        Geometry envelope = Constructors.polygonFromEnvelope(minX, minY, maxX, maxY);
        envelope.setSRID(srid);
        return envelope;
    }

    public static Geometry makeEnvelope(double minX, double minY, double maxX, double maxY) {
        return Constructors.makeEnvelope(minX, minY, maxX, maxY, 0);
    }

    public static Geometry geomFromGeoHash(String geoHash, Integer precision) {
        try {
            return GeoHashDecoder.decode(geoHash, precision);
        }
        catch (GeoHashDecoder.InvalidGeoHashException e) {
            return null;
        }
    }

    public static Geometry pointFromGeoHash(String geoHash, Integer precision) {
        return Constructors.geomFromGeoHash(geoHash, precision).getCentroid();
    }

    public static Geometry geomFromGML(String gml) throws IOException, ParserConfigurationException, SAXException {
        return new GMLReader().read(gml, GEOMETRY_FACTORY);
    }

    public static Geometry geomFromKML(String kml) throws ParseException {
        return new KMLReader().read(kml);
    }

    public static Geometry geomFromMySQL(byte[] binary) throws ParseException {
        ByteBuffer buffer = ByteBuffer.wrap(binary);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int srid = buffer.getInt();
        byte[] wkb = new byte[buffer.remaining()];
        buffer.get(wkb);
        Geometry geom = Constructors.geomFromWKB(wkb);
        geom.setSRID(srid);
        return geom;
    }
}

