/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2BuilderGraph;
import org.apache.sedona.shaded.s2.S2BuilderLayer;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2PolygonDegeneracyFinder;
import org.apache.sedona.shaded.s2.primitives.IdSetLexicon;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public final class S2ClosedSetNormalizer {
    private final Options options;
    private final NormalizedLayer normalizedPointLayer = new NormalizedLayer();
    private final NormalizedLayer normalizedLineLayer = new NormalizedLayer();
    private final NormalizedLayer normalizedPolygonLayer = new NormalizedLayer();
    private IntVector polygonInputEdgeIds = null;
    private boolean[] excludeFromPointOutput = null;

    public S2ClosedSetNormalizer(Options options, S2BuilderLayer pointLayer, S2BuilderLayer lineLayer, S2BuilderLayer polygonLayer) {
        this.normalizedPointLayer.outputLayer = pointLayer;
        this.normalizedLineLayer.outputLayer = lineLayer;
        this.normalizedPolygonLayer.outputLayer = polygonLayer;
        S2Builder.GraphOptions pointGraphOptions = pointLayer.graphOptions();
        S2Builder.GraphOptions lineGraphOptions = lineLayer.graphOptions();
        S2Builder.GraphOptions polygonGraphOptions = polygonLayer.graphOptions();
        assert (pointGraphOptions.edgeType() == S2Builder.EdgeType.DIRECTED);
        assert (lineGraphOptions.siblingPairs() != S2Builder.GraphOptions.SiblingPairs.CREATE);
        assert (lineGraphOptions.siblingPairs() != S2Builder.GraphOptions.SiblingPairs.REQUIRE);
        assert (polygonGraphOptions.edgeType() == S2Builder.EdgeType.DIRECTED);
        this.options = options;
        this.normalizedPointLayer.outputGraphOptions = pointGraphOptions;
        this.normalizedLineLayer.outputGraphOptions = lineGraphOptions;
        this.normalizedPolygonLayer.outputGraphOptions = polygonGraphOptions;
        this.normalizedPointLayer.inputGraphOptions = new S2Builder.GraphOptions(pointGraphOptions);
        this.normalizedLineLayer.inputGraphOptions = new S2Builder.GraphOptions(lineGraphOptions);
        this.normalizedPolygonLayer.inputGraphOptions = new S2Builder.GraphOptions(polygonGraphOptions);
        this.normalizedPointLayer.inputGraphOptions.setAllowVertexFiltering(false);
        this.normalizedLineLayer.inputGraphOptions.setAllowVertexFiltering(false);
        this.normalizedLineLayer.inputGraphOptions.setDegenerateEdges(S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS);
        this.normalizedPolygonLayer.inputGraphOptions.setAllowVertexFiltering(false);
        this.normalizedPolygonLayer.inputGraphOptions.setDegenerateEdges(S2Builder.GraphOptions.DegenerateEdges.DISCARD_EXCESS);
        this.normalizedPolygonLayer.inputGraphOptions.setSiblingPairs(S2Builder.GraphOptions.SiblingPairs.DISCARD_EXCESS);
    }

    public S2ClosedSetNormalizer(S2BuilderLayer pointLayer, S2BuilderLayer lineLayer, S2BuilderLayer polygonLayer) {
        this(new Options(), pointLayer, lineLayer, polygonLayer);
    }

    public S2BuilderLayer pointLayer() {
        return this.normalizedPointLayer.inputLayer;
    }

    public S2BuilderLayer lineLayer() {
        return this.normalizedLineLayer.inputLayer;
    }

    public S2BuilderLayer polygonLayer() {
        return this.normalizedPolygonLayer.inputLayer;
    }

    private void maybeRun(S2Error error) {
        if (this.normalizedPointLayer.inputGraph == null || this.normalizedLineLayer.inputGraph == null || this.normalizedPolygonLayer.inputGraph == null) {
            return;
        }
        this.run(error);
    }

    private void run(S2Error error) {
        boolean pointsModified;
        S2BuilderGraph pointGraph = this.normalizedPointLayer.inputGraph;
        S2BuilderGraph lineGraph = this.normalizedLineLayer.inputGraph;
        S2BuilderGraph polygonGraph = this.normalizedPolygonLayer.inputGraph;
        assert (pointGraph.options().equals(this.normalizedPointLayer.inputGraphOptions));
        assert (lineGraph.options().equals(this.normalizedLineLayer.inputGraphOptions));
        assert (polygonGraph.options().equals(this.normalizedPolygonLayer.inputGraphOptions));
        if (this.options.suppressLowerDimensions()) {
            this.polygonInputEdgeIds = polygonGraph.getInEdgeIds();
            this.excludeFromPointOutput = new boolean[pointGraph.numVertices()];
            Arrays.fill(this.excludeFromPointOutput, false);
            this.initExcludeFromPointOutput(lineGraph);
            this.initExcludeFromPointOutput(polygonGraph);
        }
        this.normalizeEdges();
        boolean polygonsModified = this.normalizedPolygonLayer.newEdges.size() != polygonGraph.numEdges();
        boolean linesModified = polygonsModified || this.normalizedLineLayer.newEdges.size() != lineGraph.numEdges();
        boolean bl = pointsModified = linesModified || this.normalizedPointLayer.newEdges.size() != pointGraph.numEdges();
        if (!(pointsModified || linesModified || polygonsModified)) {
            this.normalizedPointLayer.outputGraph = S2ClosedSetNormalizer.copyGraphWithOptions(pointGraph, this.normalizedPointLayer.outputGraphOptions);
            this.normalizedLineLayer.outputGraph = S2ClosedSetNormalizer.copyGraphWithOptions(lineGraph, this.normalizedLineLayer.outputGraphOptions);
            this.normalizedPolygonLayer.outputGraph = S2ClosedSetNormalizer.copyGraphWithOptions(polygonGraph, this.normalizedPolygonLayer.outputGraphOptions);
        } else {
            IdSetLexicon inputEdgeIdSetLexicon;
            this.normalizedPointLayer.newInputEdgeIdSetLexicon = inputEdgeIdSetLexicon = new IdSetLexicon(pointGraph.inputEdgeIdSetLexicon());
            this.normalizedLineLayer.newInputEdgeIdSetLexicon = inputEdgeIdSetLexicon;
            this.normalizedPolygonLayer.newInputEdgeIdSetLexicon = inputEdgeIdSetLexicon;
            S2ClosedSetNormalizer.buildOutputGraph(pointGraph, this.normalizedPointLayer, pointsModified, error);
            S2ClosedSetNormalizer.buildOutputGraph(lineGraph, this.normalizedLineLayer, linesModified, error);
            S2ClosedSetNormalizer.buildOutputGraph(polygonGraph, this.normalizedPolygonLayer, polygonsModified, error);
        }
        boolean unused = this.normalizedPointLayer.outputLayer.build(this.normalizedPointLayer.outputGraph, error) && this.normalizedLineLayer.outputLayer.build(this.normalizedLineLayer.outputGraph, error) && this.normalizedPolygonLayer.outputLayer.build(this.normalizedPolygonLayer.outputGraph, error);
    }

    private void initExcludeFromPointOutput(S2BuilderGraph graph) {
        for (int e = 0; e < graph.numEdges(); ++e) {
            int second;
            int first = graph.edges().getFirst(e);
            if (first == (second = graph.edges().getSecond(e))) continue;
            this.excludeFromPointOutput[first] = true;
            this.excludeFromPointOutput[second] = true;
        }
    }

    private boolean isExcludedFromPointOutput(int vertex) {
        return this.options.suppressLowerDimensions() && this.excludeFromPointOutput[vertex];
    }

    @VisibleForTesting
    static S2BuilderGraph copyGraphWithOptions(S2BuilderGraph graph, S2Builder.GraphOptions options) {
        IntVector inputEdgeIdSetIds = new IntVector();
        inputEdgeIdSetIds.addAll(graph.inputEdgeIdSetIds());
        IntVector labelSetIds = new IntVector();
        labelSetIds.addAll(graph.labelSetIds());
        return new S2BuilderGraph(new S2Builder.GraphOptions(options), new ArrayList<S2Point>(graph.vertices()), new S2BuilderGraph.EdgeList(graph.edges()), inputEdgeIdSetIds, new IdSetLexicon(graph.inputEdgeIdSetLexicon()), labelSetIds, new IdSetLexicon(graph.labelSetLexicon()), graph.isFullPolygonPredicate());
    }

    private static void buildOutputGraph(S2BuilderGraph inputGraph, NormalizedLayer outputLayer, boolean modified, S2Error error) {
        if (modified) {
            S2BuilderGraph.processEdges(outputLayer.outputGraphOptions, outputLayer.newEdges, outputLayer.newInputEdgeIds, outputLayer.newInputEdgeIdSetLexicon, error);
        }
        IntVector labelSetIds = new IntVector();
        labelSetIds.addAll(inputGraph.labelSetIds());
        outputLayer.outputGraph = new S2BuilderGraph(outputLayer.outputGraphOptions, new ArrayList<S2Point>(inputGraph.vertices()), outputLayer.newEdges, outputLayer.newInputEdgeIds, outputLayer.newInputEdgeIdSetLexicon, labelSetIds, new IdSetLexicon(inputGraph.labelSetLexicon()), inputGraph.isFullPolygonPredicate());
    }

    private static int advance(S2BuilderGraph graph, int index, S2BuilderGraph.Edge out) {
        if (++index >= graph.numEdges()) {
            out.setSentinel();
            return Integer.MAX_VALUE;
        }
        graph.edges().get(index, out);
        return index;
    }

    private int advanceIncoming(S2BuilderGraph graph, int index, S2BuilderGraph.Edge out) {
        if (this.polygonInputEdgeIds == null || ++index >= this.polygonInputEdgeIds.size()) {
            out.setSentinel();
            return Integer.MAX_VALUE;
        }
        graph.edges().getReverse(this.polygonInputEdgeIds.get(index), out);
        return index;
    }

    private void normalizeEdges() {
        S2BuilderGraph pointGraph = this.normalizedPointLayer.inputGraph;
        S2BuilderGraph lineGraph = this.normalizedLineLayer.inputGraph;
        S2BuilderGraph polygonGraph = this.normalizedPolygonLayer.inputGraph;
        S2PolygonDegeneracyFinder.PolygonDegeneracyList degeneracies = S2PolygonDegeneracyFinder.findPolygonDegeneracies(polygonGraph);
        int iDegeneracy = 0;
        S2BuilderGraph.Edge ePoint = new S2BuilderGraph.Edge();
        int iPoint = S2ClosedSetNormalizer.advance(pointGraph, -1, ePoint);
        S2BuilderGraph.Edge eLine = new S2BuilderGraph.Edge();
        int iLine = S2ClosedSetNormalizer.advance(lineGraph, -1, eLine);
        S2BuilderGraph.Edge ePolygon = new S2BuilderGraph.Edge();
        int iPolygon = S2ClosedSetNormalizer.advance(polygonGraph, -1, ePolygon);
        S2BuilderGraph.Edge eIncoming = new S2BuilderGraph.Edge();
        int iIncoming = this.advanceIncoming(polygonGraph, -1, eIncoming);
        while (true) {
            if (!eLine.isLessThan(ePolygon) && !ePoint.isLessThan(ePolygon)) {
                if (ePolygon.isSentinel()) break;
                if (iDegeneracy >= degeneracies.size() || degeneracies.edgeId(iDegeneracy) != iPolygon) {
                    S2ClosedSetNormalizer.addEdge(polygonGraph, iPolygon, this.normalizedPolygonLayer);
                    while (this.options.suppressLowerDimensions() && eLine.isEqualTo(ePolygon)) {
                        iLine = S2ClosedSetNormalizer.advance(lineGraph, iLine, eLine);
                    }
                } else if (!degeneracies.isHole(iDegeneracy++)) {
                    if (ePolygon.srcId != ePolygon.dstId) {
                        S2ClosedSetNormalizer.addEdge(polygonGraph, iPolygon, this.normalizedLineLayer);
                        while (eLine.isEqualTo(ePolygon)) {
                            S2ClosedSetNormalizer.addEdge(lineGraph, iLine, this.normalizedLineLayer);
                            iLine = S2ClosedSetNormalizer.advance(lineGraph, iLine, eLine);
                        }
                    } else if (!this.isExcludedFromPointOutput(ePolygon.srcId)) {
                        S2ClosedSetNormalizer.addEdge(polygonGraph, iPolygon, this.normalizedPointLayer);
                    }
                }
                iPolygon = S2ClosedSetNormalizer.advance(polygonGraph, iPolygon, ePolygon);
                continue;
            }
            if (!ePoint.isLessThan(eLine)) {
                if (eLine.srcId != eLine.dstId) {
                    while (eIncoming.isLessThan(eLine)) {
                        iIncoming = this.advanceIncoming(polygonGraph, iIncoming, eIncoming);
                    }
                    if (!eLine.isEqualTo(eIncoming)) {
                        S2ClosedSetNormalizer.addEdge(lineGraph, iLine, this.normalizedLineLayer);
                    }
                } else {
                    if (!this.isExcludedFromPointOutput(eLine.srcId)) {
                        S2ClosedSetNormalizer.addEdge(lineGraph, iLine, this.normalizedPointLayer);
                    }
                    if (lineGraph.options().edgeType() == S2Builder.EdgeType.UNDIRECTED) {
                        ++iLine;
                    }
                }
                iLine = S2ClosedSetNormalizer.advance(lineGraph, iLine, eLine);
                continue;
            }
            if (!this.isExcludedFromPointOutput(ePoint.srcId)) {
                S2ClosedSetNormalizer.addEdge(pointGraph, iPoint, this.normalizedPointLayer);
            }
            iPoint = S2ClosedSetNormalizer.advance(pointGraph, iPoint, ePoint);
        }
    }

    private static void addEdge(S2BuilderGraph in, int edgeId, NormalizedLayer out) {
        out.newEdges.add(in.edges().getSrcId(edgeId), in.edges().getDstId(edgeId));
        out.newInputEdgeIds.add(in.inputEdgeIdSetId(edgeId));
    }

    private class DimensionLayer
    implements S2BuilderLayer {
        private final NormalizedLayer layerData;

        public DimensionLayer(NormalizedLayer layerData) {
            this.layerData = layerData;
        }

        @Override
        public S2Builder.GraphOptions graphOptions() {
            return this.layerData.inputGraphOptions;
        }

        @Override
        public boolean build(S2BuilderGraph graph, S2Error error) {
            this.layerData.inputGraph = graph;
            S2ClosedSetNormalizer.this.maybeRun(error);
            return error.ok();
        }
    }

    private class NormalizedLayer {
        public S2Builder.GraphOptions inputGraphOptions = null;
        public S2Builder.GraphOptions outputGraphOptions = null;
        public final S2BuilderGraph.EdgeList newEdges = new S2BuilderGraph.EdgeList();
        public final IntVector newInputEdgeIds = new IntVector();
        public IdSetLexicon newInputEdgeIdSetLexicon = null;
        public S2BuilderGraph inputGraph = null;
        public final S2BuilderLayer inputLayer = new DimensionLayer(this);
        public S2BuilderGraph outputGraph = null;
        public S2BuilderLayer outputLayer = null;

        private NormalizedLayer() {
        }
    }

    public static class Options {
        private boolean suppressLowerDimensions;

        public Options(boolean suppressLowerDimensions) {
            this.suppressLowerDimensions = suppressLowerDimensions;
        }

        public Options() {
            this(true);
        }

        @CanIgnoreReturnValue
        public Options setSuppressLowerDimensions(boolean suppressLowerDimensions) {
            this.suppressLowerDimensions = suppressLowerDimensions;
            return this;
        }

        public boolean suppressLowerDimensions() {
            return this.suppressLowerDimensions;
        }
    }
}

