/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.monitoring;

import org.apache.spark.util.AccumulatorV2;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class EnvelopeAccumulator
extends AccumulatorV2<Envelope, Geometry> {
    private final GeometryFactory gf = new GeometryFactory();
    private Envelope env = new Envelope();

    public boolean isZero() {
        return this.env.isNull();
    }

    public AccumulatorV2<Envelope, Geometry> copy() {
        EnvelopeAccumulator newAcc = new EnvelopeAccumulator();
        newAcc.env = new Envelope(this.env);
        return newAcc;
    }

    public void reset() {
        this.env = new Envelope();
    }

    public void add(Envelope v) {
        this.env.expandToInclude(v);
    }

    public void merge(AccumulatorV2<Envelope, Geometry> other) {
        this.env.expandToInclude(((Geometry)other.value()).getEnvelopeInternal());
    }

    public Geometry value() {
        return this.gf.toGeometry(this.env);
    }
}

