/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.jpostal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class DataDownloadUtils {
    private static final String LIBPOSTAL_DATA_FILE = "libpostal_data.tar.gz";
    private static final String LIBPOSTAL_PARSER_FILE = "parser.tar.gz";
    private static final String LIBPOSTAL_LANG_CLASS_FILE = "language_classifier.tar.gz";
    private static final String[] LIBPOST_ARCHIVES = new String[]{"libpostal_data.tar.gz", "parser.tar.gz", "language_classifier.tar.gz"};

    public static Boolean isDataDirPopulated(String dataDir) {
        Path dataPath = Paths.get(dataDir, new String[0]);
        return Files.exists(dataPath.resolve("transliteration"), new LinkOption[0]) && Files.exists(dataPath.resolve("numex"), new LinkOption[0]) && Files.exists(dataPath.resolve("address_parser"), new LinkOption[0]) && Files.exists(dataPath.resolve("address_expansions"), new LinkOption[0]) && Files.exists(dataPath.resolve("language_classifier"), new LinkOption[0]);
    }

    public static synchronized void populateDataDir(String dst, Boolean senzing) {
        String versionUrlParam;
        String originUrl;
        if (dst == null || dst.isEmpty()) {
            throw new IllegalArgumentException("Data directory must not be null or empty");
        }
        if (senzing.booleanValue()) {
            originUrl = "https://public-read-libpostal-data.s3.amazonaws.com";
            versionUrlParam = "/v1.1.0/";
        } else {
            originUrl = "https://github.com/openvenues/libpostal/releases/download";
            versionUrlParam = "/v1.0.0/";
        }
        Path dataDir = Paths.get(dst, new String[0]);
        try {
            if (!Files.exists(dataDir, new LinkOption[0])) {
                Files.createDirectories(dataDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create data directory", e);
        }
        for (String archive : LIBPOST_ARCHIVES) {
            Path archivePath = dataDir.resolve(archive);
            String archiveUrl = originUrl + versionUrlParam + archive;
            try {
                DataDownloadUtils.downloadFile(archiveUrl, archivePath);
                DataDownloadUtils.extractTarGz(archivePath, dataDir);
                Files.deleteIfExists(archivePath);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to download or extract " + archive, e);
            }
        }
    }

    private static void downloadFile(String urlStr, Path dest) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "jpostal-java");
        conn.setConnectTimeout(15000);
        conn.setReadTimeout(30000);
        try (InputStream in = conn.getInputStream();){
            Files.copy(in, dest, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractTarGz(Path tarGzPath, Path destDir) throws IOException {
        try (InputStream fi = Files.newInputStream(tarGzPath, new OpenOption[0]);
             GZIPInputStream gzi = new GZIPInputStream(fi);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzi);){
            TarArchiveEntry entry;
            block20: while ((entry = tarIn.getNextTarEntry()) != null) {
                Path entryPath = destDir.resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                    continue;
                }
                if (!Files.exists(entryPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                }
                OutputStream out = Files.newOutputStream(entryPath, new OpenOption[0]);
                try {
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int len;
                        if ((len = tarIn.read(buffer)) == -1) continue block20;
                        out.write(buffer, 0, len);
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            return;
        }
    }

    public static void populateDataDir(String dst) {
        DataDownloadUtils.populateDataDir(dst, false);
    }
}

