/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.fastutil.objects.ObjectAVLTreeSet;
import org.apache.sedona.shaded.fastutil.objects.ObjectBidirectionalIterator;
import org.apache.sedona.shaded.guava.base.Function;
import org.apache.sedona.shaded.guava.primitives.UnsignedLongs;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2ShapeIndex;

@JsType
public interface S2Iterator<T extends Entry> {
    public static <T extends Entry> ListIterator<T> fromList(List<T> entries) {
        return new ListIterator<T>(entries);
    }

    public S2Iterator<T> copy();

    public void restart();

    default public int compareTo(S2CellId cellId) {
        return UnsignedLongs.compare(this.entry().id(), cellId.id());
    }

    default public S2CellId id() {
        return new S2CellId(this.entry().id());
    }

    public T entry();

    default public S2Point center() {
        return this.id().toPoint();
    }

    @CanIgnoreReturnValue
    public boolean next();

    @CanIgnoreReturnValue
    public boolean prev();

    public boolean done();

    public boolean atBegin();

    public void seek(S2CellId var1);

    default public void seekForward(S2CellId target) {
        if (!this.done() && this.compareTo(target) < 0) {
            this.seek(target);
        }
    }

    public void finish();

    @JsIgnore
    default public boolean locate(S2Point targetPoint) {
        S2CellId target = S2CellId.fromPoint(targetPoint);
        this.seek(target);
        if (!this.done() && this.id().rangeMin().lessOrEquals(target)) {
            return true;
        }
        if (!this.atBegin()) {
            this.prev();
            if (this.id().rangeMax().greaterOrEquals(target)) {
                return true;
            }
        }
        return false;
    }

    default public S2ShapeIndex.CellRelation locate(S2CellId target) {
        this.seek(target.rangeMin());
        if (!this.done()) {
            if (this.id().greaterOrEquals(target) && this.id().rangeMin().lessOrEquals(target)) {
                return S2ShapeIndex.CellRelation.INDEXED;
            }
            if (this.id().lessOrEquals(target.rangeMax())) {
                return S2ShapeIndex.CellRelation.SUBDIVIDED;
            }
        }
        if (!this.atBegin()) {
            this.prev();
            if (this.id().rangeMax().greaterOrEquals(target)) {
                return S2ShapeIndex.CellRelation.INDEXED;
            }
        }
        return S2ShapeIndex.CellRelation.DISJOINT;
    }

    public static class AvlSetIterator<T extends Entry>
    implements S2Iterator<T> {
        private final ObjectAVLTreeSet<T> entries;
        private final Function<S2CellId, T> min;
        private ObjectBidirectionalIterator<T> setIter;
        private T entry;

        public AvlSetIterator(ObjectAVLTreeSet<T> entries, Function<S2CellId, T> min2) {
            this.entries = entries;
            this.min = min2;
            this.restart();
        }

        @Override
        public void restart() {
            this.setIter = this.entries.iterator();
            this.entry = this.setIter.hasNext() ? (Entry)this.setIter.next() : null;
        }

        @Override
        public void finish() {
            this.setIter = this.entries.isEmpty() ? this.entries.iterator() : this.entries.iterator((Entry)this.entries.last());
            this.entry = null;
        }

        private void set(T entry) {
            assert (this.entries.contains(entry));
            this.setIter = this.entries.iterator(entry);
            this.entry = entry;
        }

        @Override
        public S2Iterator<T> copy() {
            AvlSetIterator<T> result = new AvlSetIterator<T>(this.entries, this.min);
            result.set(this.entry);
            assert (result.isEqualTo(this));
            return result;
        }

        @Override
        public T entry() {
            return this.entry;
        }

        @Override
        public boolean atBegin() {
            return this.entries.isEmpty() || ((Entry)this.entries.first()).equals(this.entry);
        }

        @Override
        public boolean next() {
            if (this.setIter.hasNext()) {
                this.entry = (Entry)this.setIter.next();
                return true;
            }
            this.entry = null;
            return false;
        }

        @Override
        public boolean prev() {
            if (!this.setIter.hasPrevious()) {
                return false;
            }
            if (this.entry == null) {
                this.entry = (Entry)this.setIter.previous();
                return true;
            }
            this.setIter.previous();
            if (this.setIter.hasPrevious()) {
                this.entry = (Entry)this.setIter.previous();
                this.setIter.next();
                return true;
            }
            this.setIter.next();
            return false;
        }

        @Override
        public boolean done() {
            return this.entry == null;
        }

        @Override
        public void seek(S2CellId target) {
            this.setIter = this.entries.iterator((Entry)this.min.apply(target));
            this.entry = this.setIter.hasNext() ? (Entry)this.setIter.next() : null;
        }

        public boolean isEqualTo(AvlSetIterator<T> other) {
            if (this.entries != other.entries) {
                return false;
            }
            if (this.min != other.min) {
                return false;
            }
            if (this.entry == null != (other.entry == null)) {
                return false;
            }
            if (this.entry != null && this.entry != other.entry) {
                return false;
            }
            if (this.setIter.hasNext() != other.setIter.hasNext()) {
                return false;
            }
            return this.setIter.hasPrevious() == other.setIter.hasPrevious();
        }
    }

    public static class ListIterator<T extends Entry>
    implements S2Iterator<T> {
        private final List<T> entries;
        protected int pos;

        ListIterator(List<T> entries) {
            this.entries = entries;
        }

        @Override
        public S2Iterator<T> copy() {
            ListIterator<T> it = new ListIterator<T>(this.entries);
            it.pos = this.pos;
            return it;
        }

        @Override
        public void restart() {
            this.pos = 0;
        }

        @Override
        public T entry() {
            assert (!this.done());
            return (T)((Entry)this.entries.get(this.pos));
        }

        @Override
        public boolean next() {
            if (this.pos < this.entries.size()) {
                ++this.pos;
                return true;
            }
            return false;
        }

        @Override
        public boolean prev() {
            if (this.pos > 0) {
                --this.pos;
                return true;
            }
            return false;
        }

        @Override
        public boolean done() {
            return this.pos == this.entries.size();
        }

        @Override
        public boolean atBegin() {
            return this.pos == 0;
        }

        @Override
        public void seek(S2CellId target) {
            this.seek(0, target);
        }

        @Override
        public void seekForward(S2CellId target) {
            this.seek(this.pos, target);
        }

        private void seek(int start, S2CellId target) {
            int end = this.entries.size() - 1;
            while (start <= end) {
                this.pos = (start + end) / 2;
                int result = this.id().compareTo(target);
                if (result > 0) {
                    end = this.pos - 1;
                    continue;
                }
                if (result < 0) {
                    start = this.pos + 1;
                    continue;
                }
                if (start != this.pos) {
                    end = this.pos;
                    continue;
                }
                return;
            }
            this.pos = start;
        }

        @Override
        public void finish() {
            this.pos = this.entries.size();
        }
    }

    @JsType
    public static interface Entry {
        public long id();
    }
}

