/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.guava.primitives.Ints;
import org.apache.sedona.shaded.guava.primitives.UnsignedLongs;
import org.apache.sedona.shaded.s2.EncodedInts;
import org.apache.sedona.shaded.s2.PrimitiveArrays;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2CellIdVector;
import org.apache.sedona.shaded.s2.S2CellIdVectorCoder;
import org.apache.sedona.shaded.s2.S2Coder;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.apache.sedona.shaded.s2.S2ShapeUtil;
import org.apache.sedona.shaded.s2.VectorCoder;
import org.jspecify.annotations.Nullable;

@JsType
public class S2ShapeIndexCoder
implements S2Coder<S2ShapeIndex> {
    public static final S2ShapeIndexCoder INSTANCE = new S2ShapeIndexCoder(null);
    private final List<S2Shape> shapes;
    private static final S2Shape UNDECODED_SHAPE = new S2ShapeUtil.S2EdgeVectorShape();

    public S2ShapeIndexCoder(@Nullable List<S2Shape> shapes) {
        this.shapes = shapes;
    }

    public S2ShapeIndexCoder preloaded() {
        return new S2ShapeIndexCoder(this.shapes){

            @Override
            public List<S2Shape> cacheShapes(List<S2Shape> shapes) {
                return ImmutableList.copyOf(shapes);
            }

            @Override
            public List<S2ShapeIndex.S2ClippedShape[]> cacheClippedShapes(List<S2ShapeIndex.S2ClippedShape[]> clippedShapes) {
                return ImmutableList.copyOf(clippedShapes);
            }
        };
    }

    public S2ShapeIndexCoder uncached() {
        return new S2ShapeIndexCoder(this.shapes){

            @Override
            public List<S2Shape> cacheShapes(List<S2Shape> shapes) {
                return shapes;
            }

            @Override
            public List<S2ShapeIndex.S2ClippedShape[]> cacheClippedShapes(List<S2ShapeIndex.S2ClippedShape[]> clippedShapes) {
                return clippedShapes;
            }
        };
    }

    @Override
    @JsIgnore
    public void encode(S2ShapeIndex value, OutputStream output) throws IOException {
        try (Encoder encoder = new Encoder(value.options());){
            encoder.init(value.getShapes(), output);
            S2Iterator.ListIterator<S2ShapeIndex.Cell> it = value.iterator();
            while (!it.done()) {
                encoder.addCell((S2ShapeIndex.Cell)it.entry());
                it.next();
            }
        }
    }

    public List<S2Shape> cacheShapes(List<S2Shape> shapes) {
        Object[] cachedShapes = new S2Shape[Ints.checkedCast(shapes.size())];
        Arrays.fill(cachedShapes, UNDECODED_SHAPE);
        return new AbstractList<S2Shape>((S2Shape[])cachedShapes, shapes){
            final /* synthetic */ S2Shape[] val$cachedShapes;
            final /* synthetic */ List val$shapes;
            {
                this.val$cachedShapes = s2ShapeArray;
                this.val$shapes = list;
            }

            @Override
            public int size() {
                return this.val$cachedShapes.length;
            }

            @Override
            public synchronized S2Shape get(int i) {
                return this.val$cachedShapes[i] == UNDECODED_SHAPE ? (S2Shape)this.val$shapes.get(i) : this.val$cachedShapes[i];
            }
        };
    }

    public List<S2ShapeIndex.S2ClippedShape[]> cacheClippedShapes(final List<S2ShapeIndex.S2ClippedShape[]> clippedShapes) {
        final S2ShapeIndex.S2ClippedShape[][] cache = new S2ShapeIndex.S2ClippedShape[clippedShapes.size()][];
        return new AbstractList<S2ShapeIndex.S2ClippedShape[]>(){

            @Override
            public int size() {
                return cache.length;
            }

            @Override
            public synchronized S2ShapeIndex.S2ClippedShape[] get(int i) {
                if (cache[i] == null) {
                    cache[i] = (S2ShapeIndex.S2ClippedShape[])clippedShapes.get(i);
                }
                return cache[i];
            }
        };
    }

    @Override
    public S2ShapeIndex decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        Preconditions.checkNotNull(this.shapes);
        long maxEdgesVersion = data.readVarint64(cursor);
        int version = (int)maxEdgesVersion & 3;
        Preconditions.checkArgument(version == 0, "Unknown encoding.");
        S2ShapeIndex.Options options = new S2ShapeIndex.Options();
        options.setMaxEdgesPerCell(Ints.checkedCast(maxEdgesVersion >> 2));
        try {
            S2CellIdVector encodedCellIds = S2CellIdVectorCoder.INSTANCE.decode(data, cursor);
            Object encodedCells = new VectorCoder<S2ShapeIndex.S2ClippedShape[]>(new ClippedShapeCoder(this.shapes)).decode(data, cursor);
            return new EncodedS2ShapeIndex(options, this.cacheShapes(this.shapes), encodedCellIds, this.cacheClippedShapes((List<S2ShapeIndex.S2ClippedShape[]>)encodedCells));
        }
        catch (IOException e) {
            throw new IllegalStateException("Underlying bad data / IO error ", e);
        }
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    private static void encodeCell(boolean oneShape, S2ShapeIndex.Cell cell, OutputStream output) throws IOException {
        Preconditions.checkArgument(cell.numShapes() < 0x10000000, "Too many shapes.");
        if (oneShape) {
            int containsCenter;
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(0);
            int n = clipped.numEdges();
            Preconditions.checkArgument(n < 0x20000000, "Too many edges.");
            int n2 = containsCenter = clipped.containsCenter() ? 1 : 0;
            if (n >= 2 && n <= 17 && clipped.edge(n - 1) - clipped.edge(0) == n - 1) {
                EncodedInts.writeVarint64(output, clipped.edge(0) << 6 | n - 2 << 2 | containsCenter << 1);
            } else if (n == 1) {
                EncodedInts.writeVarint64(output, clipped.edge(0) << 3 | containsCenter << 2 | 1);
            } else {
                EncodedInts.writeVarint64(output, n << 3 | containsCenter << 2 | 3);
                S2ShapeIndexCoder.encodeEdges(clipped, output);
            }
        } else {
            if (cell.numShapes() > 1) {
                EncodedInts.writeVarint64(output, cell.numShapes() << 3 | 3);
            }
            int shapeIdBase = 0;
            for (int i = 0; i < cell.numShapes(); ++i) {
                S2ShapeIndex.S2ClippedShape clipped = cell.clipped(i);
                int containsCenter = clipped.containsCenter() ? 1 : 0;
                int clippedShapeId = clipped.shapeId();
                assert (clippedShapeId >= shapeIdBase);
                int shapeDelta = clippedShapeId - shapeIdBase;
                shapeIdBase = clippedShapeId + 1;
                int n = clipped.numEdges();
                Preconditions.checkArgument(n < 0x20000000, "Too many edges.");
                if (n >= 1 && n <= 16 && clipped.edge(n - 1) - clipped.edge(0) == n - 1) {
                    EncodedInts.writeVarint64(output, clipped.edge(0) << 2 | containsCenter << 1);
                    EncodedInts.writeVarint64(output, shapeDelta << 4 | n - 1);
                    continue;
                }
                if (n == 0) {
                    EncodedInts.writeVarint64(output, shapeDelta << 4 | containsCenter << 3 | 7);
                    continue;
                }
                EncodedInts.writeVarint64(output, n - 1 << 3 | containsCenter << 2 | 1);
                EncodedInts.writeVarint64(output, shapeDelta);
                S2ShapeIndexCoder.encodeEdges(clipped, output);
            }
        }
    }

    private static void encodeEdges(S2ShapeIndex.S2ClippedShape clipped, OutputStream output) throws IOException {
        int edgeIdBase = 0;
        int numEdges = clipped.numEdges();
        for (int i = 0; i < numEdges; ++i) {
            int edgeId = clipped.edge(i);
            assert (edgeId >= edgeIdBase);
            int delta = edgeId - edgeIdBase;
            if (i + 1 == numEdges) {
                EncodedInts.writeVarint64(output, delta);
                continue;
            }
            int count = 1;
            while (i + 1 < numEdges && clipped.edge(i + 1) == edgeId + count) {
                ++count;
                ++i;
            }
            if (count < 8) {
                EncodedInts.writeVarint64(output, delta << 3 | count - 1);
            } else {
                EncodedInts.writeVarint64(output, count - 8 << 3 | 7);
                EncodedInts.writeVarint64(output, delta);
            }
            edgeIdBase = edgeId + count;
        }
    }

    private static int[] decodeEdges(int numEdges, PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        int[] edges = new int[numEdges];
        int edgeId = 0;
        int i = 0;
        while (i < numEdges) {
            long delta = data.readVarint64(cursor);
            if (i + 1 == numEdges) {
                edges[i++] = Ints.checkedCast((long)edgeId + delta);
                continue;
            }
            long count = (delta & 7L) + 1L;
            delta >>>= 3;
            if (count == 8L) {
                count = delta + 8L;
                delta = data.readVarint64(cursor);
            }
            edgeId += Ints.checkedCast(delta);
            while (count > 0L) {
                edges[i] = edgeId++;
                --count;
                ++i;
            }
        }
        return edges;
    }

    private static S2ShapeIndex.S2ClippedShape[] decodeClippedShapes(List<S2Shape> shapes, PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        if (shapes.size() == 1) {
            S2ShapeIndex.S2ClippedShape[] clippedShapes = new S2ShapeIndex.S2ClippedShape[1];
            int header = data.readVarint32(cursor);
            if ((header & 1) == 0) {
                int numEdges = (header >>> 2 & 0xF) + 2;
                boolean center = (header & 2) != 0;
                clippedShapes[0] = S2ShapeIndex.S2ClippedShape.create(null, 0, center, header >>> 6, numEdges);
            } else if ((header & 2) == 0) {
                boolean center = (header & 4) != 0;
                clippedShapes[0] = S2ShapeIndex.S2ClippedShape.create(null, 0, center, header >>> 3, 1);
            } else {
                int numEdges = Ints.checkedCast(header >> 3);
                int[] edges = S2ShapeIndexCoder.decodeEdges(numEdges, data, cursor);
                boolean center = (header & 4) != 0;
                clippedShapes[0] = S2ShapeIndex.S2ClippedShape.ManyEdges.create(null, 0, center, edges);
            }
            return clippedShapes;
        }
        int header = data.readVarint32(cursor);
        int numClipped = 1;
        if ((header & 7) == 3) {
            numClipped = Ints.checkedCast(header >>> 3);
            header = data.readVarint32(cursor);
        }
        S2ShapeIndex.S2ClippedShape[] clippedShapes = new S2ShapeIndex.S2ClippedShape[numClipped];
        int shapeId = 0;
        int j = 0;
        while (j < numClipped) {
            int numEdges;
            if (j > 0) {
                header = data.readVarint32(cursor);
            }
            if ((header & 1) == 0) {
                int shapeIdCount = data.readVarint32(cursor);
                shapeId = Math.addExact(shapeId, shapeIdCount >> 4);
                numEdges = (shapeIdCount & 0xF) + 1;
                boolean center = (header & 2) != 0;
                clippedShapes[j] = S2ShapeIndex.S2ClippedShape.create(null, shapeId, center, header >>> 2, numEdges);
            } else if ((header & 7) == 7) {
                shapeId = Math.addExact(shapeId, header >> 4);
                boolean center = (header & 8) != 0;
                clippedShapes[j] = S2ShapeIndex.S2ClippedShape.create(null, shapeId, center, 0, 0);
            } else {
                assert ((header & 3) == 1);
                int shapeDelta = data.readVarint32(cursor);
                shapeId = Math.addExact(shapeId, shapeDelta);
                numEdges = (header >>> 3) + 1;
                int[] edges = S2ShapeIndexCoder.decodeEdges(numEdges, data, cursor);
                boolean center = (header & 4) != 0;
                clippedShapes[j] = S2ShapeIndex.S2ClippedShape.ManyEdges.create(null, shapeId, center, edges);
            }
            ++j;
            ++shapeId;
        }
        return clippedShapes;
    }

    private static final class ClippedShapeCoder
    implements S2Coder<S2ShapeIndex.S2ClippedShape[]> {
        private final List<S2Shape> shapes;

        public ClippedShapeCoder(List<S2Shape> shapes) {
            this.shapes = shapes;
        }

        @Override
        @JsIgnore
        public void encode(S2ShapeIndex.S2ClippedShape[] values, OutputStream output) {
            throw new UnsupportedOperationException();
        }

        @Override
        public S2ShapeIndex.S2ClippedShape[] decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
            return S2ShapeIndexCoder.decodeClippedShapes(this.shapes, data, cursor);
        }

        @Override
        public boolean isLazy() {
            return true;
        }
    }

    private static final class EncodedS2ShapeIndex
    extends S2ShapeIndex {
        private final S2CellIdVector encodedCellIds;
        private final List<S2ShapeIndex.S2ClippedShape[]> encodedCells;

        @JsConstructor
        EncodedS2ShapeIndex(S2ShapeIndex.Options options, List<S2Shape> shapes, S2CellIdVector cellIds, List<S2ShapeIndex.S2ClippedShape[]> cells) {
            super(options);
            this.shapes = shapes;
            this.encodedCellIds = cellIds;
            this.encodedCells = cells;
        }

        @Override
        public void add(S2Shape shape) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(S2Shape shape) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public S2Iterator.ListIterator<S2ShapeIndex.Cell> iterator() {
            AbstractList<S2ShapeIndex.Cell> cells = new AbstractList<S2ShapeIndex.Cell>(){

                @Override
                public int size() {
                    return encodedCells.size();
                }

                @Override
                public S2ShapeIndex.Cell get(int i) {
                    return new LazyCell(((S2CellId)encodedCellIds.get(i)).id(), encodedCells.get(i));
                }
            };
            return new S2Iterator.ListIterator<S2ShapeIndex.Cell>((List)cells){

                @Override
                public S2CellId id() {
                    return (S2CellId)encodedCellIds.get(this.pos);
                }
            };
        }

        @Override
        public boolean isFresh() {
            return true;
        }

        @Override
        public void applyUpdates() {
        }

        public static final class LazyCell
        extends S2ShapeIndex.Cell {
            private final long cachedCellId;
            private final S2ShapeIndex.S2ClippedShape[] cachedClippedShapes;

            @JsConstructor
            LazyCell(long cellId, S2ShapeIndex.S2ClippedShape[] clippedShapes) {
                this.cachedCellId = cellId;
                this.cachedClippedShapes = clippedShapes;
            }

            @Override
            public long id() {
                return this.cachedCellId;
            }

            @Override
            public int numShapes() {
                return this.cachedClippedShapes.length;
            }

            @Override
            public S2ShapeIndex.S2ClippedShape clipped(int i) {
                return this.cachedClippedShapes[i];
            }
        }
    }

    public static class Encoder
    implements AutoCloseable {
        private final S2ShapeIndex.Options options;
        private final List<S2CellId> cellIds = new ArrayList<S2CellId>();
        private final List<byte[]> encodedCells = new ArrayList<byte[]>();
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private boolean oneShape;
        private S2ShapeIndex.Cell last;
        private OutputStream output;

        public Encoder(S2ShapeIndex.Options options) {
            this.options = options;
        }

        @CanIgnoreReturnValue
        public Encoder init(List<S2Shape> shapes, OutputStream output) throws IOException {
            this.output = output;
            this.oneShape = shapes.size() == 1;
            long maxEdges = this.options.getMaxEdgesPerCell();
            EncodedInts.writeVarint64(output, maxEdges << 2 | 0L);
            return this;
        }

        public void addCell(S2ShapeIndex.Cell cell) throws IOException {
            Preconditions.checkArgument(this.last == null || UnsignedLongs.compare(this.last.id(), cell.id()) < 0);
            this.last = cell;
            this.cellIds.add(new S2CellId(cell.id()));
            S2ShapeIndexCoder.encodeCell(this.oneShape, cell, this.baos);
            this.encodedCells.add(this.baos.toByteArray());
            this.baos.reset();
        }

        @Override
        public void close() throws IOException {
            S2CellIdVectorCoder.INSTANCE.encode(this.cellIds, this.output);
            this.cellIds.clear();
            VectorCoder.BYTE_ARRAY.encode(this.encodedCells, this.output);
            this.encodedCells.clear();
            this.output = null;
            this.last = null;
        }
    }
}

