/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.Serializable;
import org.apache.spark.graphx.Graph;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.graphframes.lib.GraphXConversions$;
import org.graphframes.lib.Pregel;
import org.graphframes.lib.Pregel$;
import org.graphframes.lib.ShortestPaths$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ShortestPaths$
implements Logging {
    public static final ShortestPaths$ MODULE$ = new ShortestPaths$();
    private static final String DISTANCE_ID;
    private static transient Logger org$graphframes$Logging$$logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$(MODULE$);
        DISTANCE_ID = "distances";
    }

    @Override
    public void logDebug(Function0<String> s2) {
        Logging.logDebug$(this, s2);
    }

    @Override
    public void logWarn(Function0<String> s2) {
        Logging.logWarn$(this, s2);
    }

    @Override
    public void logInfo(Function0<String> s2) {
        Logging.logInfo$(this, s2);
    }

    @Override
    public void logTrace(Function0<String> s2) {
        Logging.logTrace$(this, s2);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        ShortestPaths$ shortestPaths$ = this;
        synchronized (shortestPaths$) {
            if (!bitmap$trans$0) {
                org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                bitmap$trans$0 = true;
            }
        }
        return org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        if (!bitmap$trans$0) {
            return this.org$graphframes$Logging$$logger$lzycompute();
        }
        return org$graphframes$Logging$$logger;
    }

    public Dataset<Row> org$graphframes$lib$ShortestPaths$$runInGraphX(GraphFrame graph, Seq<Object> landmarks) {
        Column column2;
        Map longIdToLandmark = ((IterableOnceOps)landmarks.map((Function1 & Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)GraphXConversions$.MODULE$.integralId(graph, l))), l))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Graph gx = org.apache.spark.graphx.lib.ShortestPaths$.MODULE$.run(graph.cachedTopologyGraphX(), (Seq)longIdToLandmark.keys().toSeq().sorted((Ordering)Ordering.Long$.MODULE$), (ClassTag)ClassTag$.MODULE$.Unit());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_lib_ShortestPaths$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.graphx").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.graphx.lib")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphx.lib.ShortestPaths")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphx.lib.ShortestPaths").asModule().moduleClass(), "SPMap"), (List)Nil$.MODULE$);
            }

            public Org_graphframes_lib_ShortestPaths$$typecreator1$1() {
            }
        }
        GraphFrame g2 = GraphXConversions$.MODULE$.fromGraphX(graph, gx, (Seq<String>)new .colon.colon((Object)this.DISTANCE_ID(), (List)Nil$.MODULE$), GraphXConversions$.MODULE$.fromGraphX$default$4(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_lib_ShortestPaths$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Unit());
        if (graph.hasIntegralIdType()) {
            column2 = g2.vertices().apply(this.DISTANCE_ID());
        } else {
            Seq longIdToLandmarkFlatten = ((IterableOnceOps)longIdToLandmark.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    long k = tuple2._1$mcJ$sp();
                    Object v = tuple2._2();
                    if (true) {
                        long l = k;
                        if (v instanceof Object) {
                            Object object = v;
                            return new .colon.colon((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)l)), (List)new .colon.colon((Object)functions$.MODULE$.lit(object), (List)Nil$.MODULE$));
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            })).toSeq();
            Column longIdToLandmarkColumn = functions$.MODULE$.map(longIdToLandmarkFlatten);
            column2 = functions$.MODULE$.transform_keys(functions$.MODULE$.col(this.DISTANCE_ID()), (Function2 & Serializable)(longId, x$1) -> longIdToLandmarkColumn.apply(longId));
        }
        Column distanceCol = column2;
        Column[] cols = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])graph.vertices().columns()), (Function1 & Serializable)column -> GraphFrame$.MODULE$.quote((String)column), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)colName -> functions$.MODULE$.col(colName), ClassTag$.MODULE$.apply(Column.class))), (Object)distanceCol.as(this.DISTANCE_ID()), ClassTag$.MODULE$.apply(Column.class));
        return g2.vertices().select(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])cols)));
    }

    public Dataset<Row> org$graphframes$lib$ShortestPaths$$runInGraphFrames(GraphFrame graph, Seq<Object> landmarks, int checkpointInterval, boolean isDirected) {
        this.logWarn((Function0<String>)(Function0 & Serializable)() -> "The GraphFrames based implementation is slow and considered experimental!");
        DataType vertexType = graph.vertices().schema().apply(GraphFrame$.MODULE$.ID()).dataType();
        Column srcDistanceCol = Pregel$.MODULE$.src(this.DISTANCE_ID());
        Column dstDistanceCol = Pregel$.MODULE$.dst(this.DISTANCE_ID());
        Column initialActiveVerticesExpr = functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).isInCollection(landmarks);
        Column updateActiveVierticesExpr = ShortestPaths$.isDistanceImprovedWithMessage$1(Pregel$.MODULE$.msg(), functions$.MODULE$.col(this.DISTANCE_ID()));
        Pregel pregel = graph.pregel().setMaxIter(Integer.MAX_VALUE).withVertexColumn(this.DISTANCE_ID(), functions$.MODULE$.when(functions$.MODULE$.col(GraphFrame$.MODULE$.ID()).isInCollection(landmarks), (Object)ShortestPaths$.initDistancesMap$1(functions$.MODULE$.col(GraphFrame$.MODULE$.ID()), landmarks)).otherwise((Object)functions$.MODULE$.map((Seq)Nil$.MODULE$).cast((DataType)MapType$.MODULE$.apply(vertexType, (DataType)IntegerType$.MODULE$))), ShortestPaths$.concatMaps$1(functions$.MODULE$.col(this.DISTANCE_ID()), Pregel$.MODULE$.msg())).sendMsgToSrc(functions$.MODULE$.when(ShortestPaths$.isDistanceImprovedWithMessage$1(ShortestPaths$.incrementDistances$1(dstDistanceCol), srcDistanceCol), (Object)ShortestPaths$.incrementDistances$1(dstDistanceCol))).aggMsgs(ShortestPaths$.aggregateArrayOfDistanceMaps$1(functions$.MODULE$.collect_list(Pregel$.MODULE$.msg()), vertexType)).setEarlyStopping(true).setInitialActiveVertexExpression(initialActiveVerticesExpr).setUpdateActiveVertexExpression(updateActiveVierticesExpr).setStopIfAllNonActiveVertices(true).setSkipMessagesFromNonActiveVertices(true);
        if (isDirected) {
            return pregel.run();
        }
        return pregel.sendMsgToDst(functions$.MODULE$.when(ShortestPaths$.isDistanceImprovedWithMessage$1(ShortestPaths$.incrementDistances$1(srcDistanceCol), dstDistanceCol), (Object)ShortestPaths$.incrementDistances$1(srcDistanceCol))).run();
    }

    public boolean org$graphframes$lib$ShortestPaths$$runInGraphFrames$default$4() {
        return true;
    }

    private String DISTANCE_ID() {
        return DISTANCE_ID;
    }

    private static final Column initDistancesMap$1(Column vertexId, Seq landmarks$1) {
        Column firstLmarkCol = functions$.MODULE$.lit(landmarks$1.head());
        ObjectRef initCol = ObjectRef.create((Object)functions$.MODULE$.when(vertexId.$eq$eq$eq((Object)firstLmarkCol), (Object)functions$.MODULE$.map((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{firstLmarkCol, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))}))));
        ((IterableOnceOps)landmarks$1.tail()).foreach((Function1 & Serializable)lmark -> {
            initCol.elem = ((Column)initCol.elem).when(vertexId.$eq$eq$eq((Object)functions$.MODULE$.lit(lmark)), (Object)functions$.MODULE$.map((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit(lmark), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))})));
            return BoxedUnit.UNIT;
        });
        return (Column)initCol.elem;
    }

    private static final Column concatMaps$1(Column distancesLeft, Column distancesRight) {
        return functions$.MODULE$.when(distancesLeft.isNull(), (Object)distancesRight).when(distancesRight.isNull(), (Object)distancesLeft).otherwise((Object)functions$.MODULE$.map_zip_with(distancesLeft, distancesRight, (Function3 & Serializable)(x$2, leftDistance, rightDistance) -> functions$.MODULE$.when(leftDistance.isNull().$bar$bar((Object)leftDistance.$greater(rightDistance)), rightDistance).otherwise(leftDistance)));
    }

    private static final Column incrementDistances$1(Column distancesMap) {
        return functions$.MODULE$.transform_values(distancesMap, (Function2 & Serializable)(x$3, distance) -> distance.$plus((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))));
    }

    private static final Column aggregateArrayOfDistanceMaps$1(Column arrayCol, DataType vertexType$1) {
        return functions$.MODULE$.reduce(arrayCol, functions$.MODULE$.lit(null).cast((DataType)MapType$.MODULE$.apply(vertexType$1, (DataType)IntegerType$.MODULE$)), (Function2 & Serializable)(distancesLeft, distancesRight) -> ShortestPaths$.concatMaps$1(distancesLeft, distancesRight));
    }

    private static final Column isDistanceImprovedWithMessage$1(Column newMap, Column oldMap) {
        return functions$.MODULE$.reduce(functions$.MODULE$.map_values(functions$.MODULE$.map_zip_with(newMap, oldMap, (Function3 & Serializable)(x$4, newDistance, rightDistance) -> newDistance.isNotNull().$amp$amp((Object)rightDistance.isNull()).$bar$bar((Object)newDistance.$less(rightDistance)))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function2 & Serializable)(left, right) -> left.$bar$bar(right));
    }

    private ShortestPaths$() {
    }
}

