/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.S2Point;

public final class Matrix {
    private final double[] values;
    private final int rows;
    private final int cols;

    public static Matrix fromCols(S2Point ... columns) {
        Matrix result = new Matrix(3, columns.length);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, columns[col].get(row));
            }
        }
        return result;
    }

    public static Matrix fromCols(List<S2Point> frame) {
        return Matrix.fromCols(frame.toArray(new S2Point[0]));
    }

    public Matrix(int cols, double ... values) {
        Preconditions.checkArgument(cols >= 0, "Negative cols not allowed.");
        this.rows = values.length / cols;
        this.cols = cols;
        Preconditions.checkArgument(this.rows * cols == values.length, "Values not an even multiple of 'cols'");
        this.values = values;
    }

    public Matrix(int rows, int cols) {
        Preconditions.checkArgument(rows >= 0, "Negative rows not allowed.");
        Preconditions.checkArgument(cols >= 0, "Negative cols not allowed.");
        this.rows = rows;
        this.cols = cols;
        this.values = new double[rows * cols];
    }

    public static Matrix fromOuter(S2Point ma, S2Point mb) {
        return new Matrix(3, ma.x * mb.x, ma.x * mb.y, ma.x * mb.z, ma.y * mb.x, ma.y * mb.y, ma.y * mb.z, ma.z * mb.x, ma.z * mb.y, ma.z * mb.z);
    }

    public static Matrix identity3x3() {
        return new Matrix(3, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public void set(int row, int col, double value) {
        this.values[row * this.cols + col] = value;
    }

    public double get(int row, int col) {
        return this.values[row * this.cols + col];
    }

    @CheckReturnValue
    public Matrix transpose() {
        Matrix result = new Matrix(this.cols, this.rows);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, this.get(col, row));
            }
        }
        return result;
    }

    public static Matrix householder(S2Point normal) {
        S2Point unit = normal.normalize();
        return Matrix.identity3x3().sub(Matrix.fromOuter(unit, unit).mult(2.0));
    }

    @CheckReturnValue
    public Matrix add(Matrix m3) {
        Preconditions.checkArgument(this.rows == m3.rows && this.cols == m3.cols);
        Matrix result = new Matrix(this.rows, this.cols);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, this.get(row, col) + m3.get(row, col));
            }
        }
        return result;
    }

    @CheckReturnValue
    public Matrix sub(Matrix m3) {
        Preconditions.checkArgument(this.rows == m3.rows && this.cols == m3.cols);
        Matrix result = new Matrix(this.rows, this.cols);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                result.set(row, col, this.get(row, col) - m3.get(row, col));
            }
        }
        return result;
    }

    @CheckReturnValue
    public Matrix mult(Matrix m3) {
        Preconditions.checkArgument(this.cols == m3.rows);
        Matrix result = new Matrix(this.rows, m3.cols);
        for (int row = 0; row < result.rows; ++row) {
            for (int col = 0; col < result.cols; ++col) {
                double sum = 0.0;
                for (int i = 0; i < this.cols; ++i) {
                    sum += this.get(row, i) * m3.get(i, col);
                }
                result.set(row, col, sum);
            }
        }
        return result;
    }

    @CheckReturnValue
    public S2Point mult(S2Point v) {
        Preconditions.checkArgument(this.rows == 3);
        Preconditions.checkArgument(this.cols == 3);
        return new S2Point(this.get(0, 0) * v.get(0) + this.get(0, 1) * v.get(1) + this.get(0, 2) * v.get(2), this.get(1, 0) * v.get(0) + this.get(1, 1) * v.get(1) + this.get(1, 2) * v.get(2), this.get(2, 0) * v.get(0) + this.get(2, 1) * v.get(1) + this.get(2, 2) * v.get(2));
    }

    @CheckReturnValue
    public Matrix mult(double k) {
        Matrix result = new Matrix(this.rows, this.cols);
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                result.set(row, col, this.get(row, col) * k);
            }
        }
        return result;
    }

    public S2Point getCol(int col) {
        Preconditions.checkState(this.rows == 3);
        Preconditions.checkArgument(0 <= col && col < this.cols);
        return new S2Point(this.values[col], this.values[this.cols + col], this.values[2 * this.cols + col]);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Matrix)) {
            return false;
        }
        Matrix m3 = (Matrix)o;
        if (this.rows != m3.rows || this.cols != m3.cols) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == m3.values[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long hash = 37L * (long)this.cols;
        for (int i = 0; i < this.values.length; ++i) {
            hash = 37L * hash + Platform.doubleHash(this.values[i]);
        }
        return (int)hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Matrix(");
        sb.append(this.rows);
        sb.append("x");
        sb.append(this.cols);
        sb.append("): ");
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                sb.append(this.get(row, col));
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

