/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.guava.base.Strings;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2Builder;
import org.apache.sedona.shaded.s2.S2BuilderGraph;
import org.apache.sedona.shaded.s2.S2BuilderShapesLayer;
import org.apache.sedona.shaded.s2.S2Error;
import org.apache.sedona.shaded.s2.S2Loop;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Polygon;
import org.apache.sedona.shaded.s2.primitives.IdSetLexicon;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class S2PolygonLayer
implements S2BuilderShapesLayer {
    private final Options options;
    private S2Polygon polygon = null;
    private final IntVector labelSetIds;
    private final ArrayList<IntVector> labelSetIdsForLoops;
    private final ArrayList<IntVector> newLabelSetIdsForLoops;
    private IdSetLexicon labelSetLexicon;
    private S2BuilderGraph.LabelFetcher fetcher = null;
    private ArrayList<S2Loop> loops = new ArrayList();
    private ArrayList<int[]> edgeLoops = new ArrayList();

    public S2PolygonLayer() {
        this.options = new Options();
        this.labelSetIds = null;
        this.labelSetIdsForLoops = null;
        this.newLabelSetIdsForLoops = null;
        this.labelSetLexicon = null;
    }

    public S2PolygonLayer(Options options) {
        Preconditions.checkNotNull(options);
        this.options = options;
        this.labelSetIds = null;
        this.labelSetIdsForLoops = null;
        this.newLabelSetIdsForLoops = null;
        this.labelSetLexicon = null;
    }

    public S2PolygonLayer(Options options, IdSetLexicon labelSetLexicon, IntVector labelSetIds) {
        Preconditions.checkNotNull(options);
        Preconditions.checkNotNull(labelSetLexicon);
        Preconditions.checkNotNull(labelSetIds);
        this.options = options;
        this.labelSetIds = labelSetIds;
        this.labelSetLexicon = labelSetLexicon;
        this.labelSetIdsForLoops = new ArrayList();
        this.newLabelSetIdsForLoops = new ArrayList();
        this.fetcher = new S2BuilderGraph.LabelFetcher();
    }

    public void setPolygon(S2Polygon polygon) {
        this.polygon = polygon;
    }

    public S2Polygon getPolygon() {
        Preconditions.checkNotNull(this.polygon, "Must call build() first.");
        return this.polygon;
    }

    public String toString() {
        return "S2PolygonLayer with options " + this.options;
    }

    public Iterable<S2Polygon.Shape> shapes() {
        return ImmutableList.of(this.getPolygon().shape());
    }

    @VisibleForTesting
    ArrayList<IntVector> getLabelSetIdsForLoops() {
        Preconditions.checkNotNull(this.labelSetIdsForLoops, "Must call build() first.");
        return this.labelSetIdsForLoops;
    }

    @Override
    public S2Builder.GraphOptions graphOptions() {
        return new S2Builder.GraphOptions(this.options.edgeType(), S2Builder.GraphOptions.DegenerateEdges.DISCARD, S2Builder.GraphOptions.DuplicateEdges.KEEP, S2Builder.GraphOptions.SiblingPairs.DISCARD);
    }

    @Override
    public boolean build(S2BuilderGraph g2, S2Error error) {
        if (this.labelSetIdsForLoops != null) {
            this.labelSetIds.clear();
            this.labelSetIdsForLoops.clear();
            this.labelSetLexicon.clear();
        }
        LoopMap loopMap = new LoopMap();
        this.loops.clear();
        this.edgeLoops.clear();
        if (this.polygon == null) {
            this.polygon = new S2Polygon();
        }
        if (g2.numEdges() == 0) {
            ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
            if (g2.isFullPolygonPredicate().test(g2)) {
                loops.add(S2Loop.full());
            }
            this.polygon.init(loops);
        } else if (g2.options().edgeType() == S2Builder.EdgeType.DIRECTED) {
            if (!g2.getDirectedLoops(S2BuilderGraph.LoopType.SIMPLE, this.edgeLoops, error)) {
                return false;
            }
            this.appendS2Loops(g2, this.edgeLoops, this.loops);
            this.appendEdgeLabels(g2, this.edgeLoops);
            this.edgeLoops.clear();
            this.initLoopMap(this.loops, loopMap);
            this.polygon.initOriented(this.loops);
        } else {
            ArrayList<S2BuilderGraph.UndirectedComponent> components = new ArrayList<S2BuilderGraph.UndirectedComponent>();
            if (!g2.getUndirectedComponents(S2BuilderGraph.LoopType.SIMPLE, components, error)) {
                return false;
            }
            for (S2BuilderGraph.UndirectedComponent component : components) {
                this.appendS2Loops(g2, component.getComplement(0), this.loops);
                this.appendEdgeLabels(g2, component.getComplement(0));
            }
            components.clear();
            this.initLoopMap(this.loops, loopMap);
            for (S2Loop loop : this.loops) {
                loop.normalize();
            }
            this.polygon.initNested(this.loops);
        }
        this.reorderEdgeLabels(loopMap);
        if (this.labelSetIdsForLoops != null) {
            for (int loopId = 0; loopId < this.polygon.numLoops(); ++loopId) {
                S2Loop loop = this.polygon.loop(loopId);
                for (int offset = 0; offset < loop.numVertices(); ++offset) {
                    this.labelSetIds.add(this.labelSetIdsForLoops.get(loopId).get(S2PolygonLayer.orientedEdge(loop, offset)));
                }
            }
        }
        if (this.options.validate()) {
            return !this.polygon.findValidationError(error);
        }
        return true;
    }

    private static int orientedEdge(S2Loop loop, int offset) {
        if (loop.isHole() && loop.numVertices() > 2 && offset < loop.numVertices() - 1) {
            offset = loop.numVertices() - offset - 2;
        }
        return offset;
    }

    private void appendS2Loops(S2BuilderGraph g2, List<int[]> edgeLoops, List<S2Loop> outLoops) {
        for (int[] edgeLoop : edgeLoops) {
            S2Point[] vertices = new S2Point[edgeLoop.length];
            int j = 0;
            for (int edgeId : edgeLoop) {
                vertices[j++] = g2.vertex(g2.edgeSrcId(edgeId));
            }
            S2Loop l = new S2Loop(vertices);
            outLoops.add(l);
        }
    }

    private void appendEdgeLabels(S2BuilderGraph g2, List<int[]> edgeLoops) {
        if (this.labelSetIdsForLoops == null) {
            return;
        }
        this.fetcher.init(g2, this.options.edgeType());
        IntVector edgeLabelSet = new IntVector();
        for (int[] edgeLoop : edgeLoops) {
            IntVector loopLabelSetIds = new IntVector();
            loopLabelSetIds.ensureCapacity(edgeLoop.length);
            for (int edgeId : edgeLoop) {
                this.fetcher.fetch(edgeId, edgeLabelSet);
                loopLabelSetIds.add(this.labelSetLexicon.add(edgeLabelSet));
            }
            this.labelSetIdsForLoops.add(loopLabelSetIds);
        }
    }

    private void initLoopMap(List<S2Loop> loops, LoopMap loopMap) {
        if (this.labelSetIdsForLoops == null) {
            return;
        }
        for (int i = 0; i < loops.size(); ++i) {
            S2Loop loop = loops.get(i);
            loopMap.put(loop, LoopData.of(i, loop.containsOrigin()));
        }
    }

    private void reorderEdgeLabels(LoopMap loopMap) {
        if (this.labelSetIdsForLoops == null) {
            return;
        }
        this.newLabelSetIdsForLoops.clear();
        this.newLabelSetIdsForLoops.ensureCapacity(this.labelSetIdsForLoops.size());
        for (int i = 0; i < this.polygon.numLoops(); ++i) {
            S2Loop loop = this.polygon.loop(i);
            LoopData old = (LoopData)loopMap.get(loop);
            Preconditions.checkState(old != null, "Loop #%s", i);
            IntVector edgeLabelSets = this.labelSetIdsForLoops.get(old.index);
            Preconditions.checkState(edgeLabelSets != null, "Loop #%s with old index %s", i, old.index);
            if (loop.containsOrigin() != old.containsOrigin && edgeLabelSets.size() > 2) {
                edgeLabelSets.reverse(0, edgeLabelSets.size() - 1);
            }
            this.newLabelSetIdsForLoops.add(edgeLabelSets);
        }
        this.labelSetIdsForLoops.clear();
        this.labelSetIdsForLoops.addAll(this.newLabelSetIdsForLoops);
    }

    public static class Options {
        private S2Builder.EdgeType edgeType;
        private boolean validate;

        public Options() {
            this.edgeType = S2Builder.EdgeType.DIRECTED;
            this.validate = false;
        }

        public Options(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull(edgeType);
            this.edgeType = edgeType;
            this.validate = false;
        }

        public String toString() {
            return Strings.lenientFormat("EdgeType %s, Validate=%s", new Object[]{this.edgeType, this.validate});
        }

        @CanIgnoreReturnValue
        public Options setEdgeType(S2Builder.EdgeType edgeType) {
            Preconditions.checkNotNull(edgeType);
            this.edgeType = edgeType;
            return this;
        }

        public S2Builder.EdgeType edgeType() {
            return this.edgeType;
        }

        @CanIgnoreReturnValue
        public Options setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        public boolean validate() {
            return this.validate;
        }
    }

    private static class LoopMap
    extends IdentityHashMap<S2Loop, LoopData> {
        private LoopMap() {
        }
    }

    private static class LoopData {
        final int index;
        final boolean containsOrigin;

        LoopData(int index, boolean containsOrigin) {
            this.index = index;
            this.containsOrigin = containsOrigin;
        }

        static LoopData of(int index, boolean containsOrigin) {
            return new LoopData(index, containsOrigin);
        }
    }
}

