/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.QueryExecutionErrors$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SchemaMergeUtils$
implements Logging {
    public static SchemaMergeUtils$ MODULE$;
    private Option<Method> mergeMethodWithCaseSensitive;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new SchemaMergeUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Method> mergeMethodWithCaseSensitive$lzycompute() {
        SchemaMergeUtils$ schemaMergeUtils$ = this;
        synchronized (schemaMergeUtils$) {
            if (!this.bitmap$0) {
                None$ none$;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> StructType.class.getMethod("merge", StructType.class, Boolean.TYPE));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Method method = (Method)success.value();
                    none$ = new Some((Object)method);
                } else if (try_ instanceof Failure) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
                this.mergeMethodWithCaseSensitive = none$;
                this.bitmap$0 = true;
            }
        }
        return this.mergeMethodWithCaseSensitive;
    }

    private Option<Method> mergeMethodWithCaseSensitive() {
        return !this.bitmap$0 ? this.mergeMethodWithCaseSensitive$lzycompute() : this.mergeMethodWithCaseSensitive;
    }

    private StructType safeMerge(StructType schema1, StructType schema2, boolean caseSensitive) {
        StructType structType;
        Option<Method> option = this.mergeMethodWithCaseSensitive();
        if (option instanceof Some) {
            Some some = (Some)option;
            Method method = (Method)some.value();
            structType = (StructType)method.invoke((Object)schema1, schema2, BoxesRunTime.boxToBoolean((boolean)caseSensitive));
        } else if (None$.MODULE$.equals(option)) {
            structType = schema1.merge(schema2);
        } else {
            throw new MatchError(option);
        }
        return structType;
    }

    public Option<StructType> mergeSchemasInParallel(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files, Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>> schemaReader) {
        None$ none$;
        Configuration hadoopConf = sparkSession.sessionState().newHadoopConfWithOptions(parameters);
        hadoopConf.set("spark.databricks.scan.modTimeCheck.enabled", "false");
        SerializableConfiguration serializedConf = new SerializableConfiguration(hadoopConf);
        Seq partialFileStatusInfo = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath().toString(), (Object)BoxesRunTime.boxToLong((long)f.getLen())), Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(Math.max(partialFileStatusInfo.size(), 1), sparkSession.sparkContext().defaultParallelism());
        boolean ignoreCorruptFiles = BoxesRunTime.unboxToBoolean((Object)CaseInsensitiveMap$.MODULE$.apply(parameters).get("ignoreCorruptFiles").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaMergeUtils$.$anonfun$mergeSchemasInParallel$2(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> PortableSQLConf$.MODULE$.get().ignoreCorruptFiles()));
        boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        RDD qual$1 = sparkSession.sparkContext().parallelize(partialFileStatusInfo, numParallelism, ClassTag$.MODULE$.apply(Tuple2.class));
        Function1 & Serializable & scala.Serializable x$12 = (Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            Seq fakeFileStatuses = iterator.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String path = (String)tuple2._1();
                long length = tuple2._2$mcJ$sp();
                FileStatus fileStatus = new FileStatus(length, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
                return fileStatus;
            }).toSeq();
            Seq schemas = (Seq)schemaReader.apply((Object)fakeFileStatuses, (Object)serializedConf.value(), (Object)BoxesRunTime.boxToBoolean((boolean)ignoreCorruptFiles));
            if (schemas.isEmpty()) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                ObjectRef mergedSchema = ObjectRef.create((Object)((StructType)schemas.head()));
                ((IterableLike)schemas.tail()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                    SchemaMergeUtils$.$anonfun$mergeSchemasInParallel$6(mergedSchema, caseSensitive, schema);
                    return BoxedUnit.UNIT;
                });
                iterator2 = package$.MODULE$.Iterator().single((Object)((StructType)mergedSchema.elem));
            }
            return iterator2;
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        StructType[] partiallyMergedSchemas = (StructType[])qual$1.mapPartitions((Function1)x$12, x$2, ClassTag$.MODULE$.apply(StructType.class)).collect();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ObjectRef finalSchema = ObjectRef.create((Object)((StructType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).head()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).tail())).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                SchemaMergeUtils$.$anonfun$mergeSchemasInParallel$7(finalSchema, caseSensitive, schema);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)((StructType)finalSchema.elem));
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$mergeSchemasInParallel$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$6(ObjectRef mergedSchema$1, boolean caseSensitive$1, StructType schema) {
        try {
            mergedSchema$1.elem = MODULE$.safeMerge((StructType)mergedSchema$1.elem, schema, caseSensitive$1);
        }
        catch (SparkException cause) {
            throw QueryExecutionErrors$.MODULE$.failedMergingSchemaError((StructType)mergedSchema$1.elem, schema, cause);
        }
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$7(ObjectRef finalSchema$1, boolean caseSensitive$1, StructType schema) {
        try {
            finalSchema$1.elem = MODULE$.safeMerge((StructType)finalSchema$1.elem, schema, caseSensitive$1);
        }
        catch (SparkException cause) {
            throw QueryExecutionErrors$.MODULE$.failedMergingSchemaError((StructType)finalSchema$1.elem, schema, cause);
        }
    }

    private SchemaMergeUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

