/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.infra.exception;

import com.google.common.base.Preconditions;
import java.util.Properties;
import lombok.Generated;

public final class PropertiesPreconditions {
    public static void checkRequired(Properties props, String key) {
        Preconditions.checkArgument((boolean)props.containsKey(key), (String)"The property `%s` is required.", (Object)key);
    }

    public static void checkPositiveInteger(Properties props, String key) {
        int integerValue;
        String propertyValue = props.getProperty(key);
        if (null == propertyValue) {
            return;
        }
        try {
            integerValue = Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException(String.format("The property `%s` should be integer.", key));
        }
        Preconditions.checkArgument((integerValue > 0 ? 1 : 0) != 0, (String)"The property `%s` should be positive.", (Object)key);
    }

    @Generated
    private PropertiesPreconditions() {
    }
}

