/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.dubbo.common.function.Predicates;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.StringUtils;

public interface AnnotationUtils {
    public static <A extends Annotation> Class<A> resolveAnnotationType(AnnotatedElement annotatedElement, String annotationClassName) {
        ClassLoader classLoader = annotatedElement.getClass().getClassLoader();
        Class<?> annotationType = ClassUtils.resolveClass(annotationClassName, classLoader);
        if (annotationType == null || !Annotation.class.isAssignableFrom(annotationType)) {
            return null;
        }
        return annotationType;
    }

    public static boolean isType(AnnotatedElement annotatedElement) {
        return annotatedElement instanceof Class;
    }

    public static boolean isSameType(Annotation annotation, Class<? extends Annotation> annotationType) {
        if (annotation == null || annotationType == null) {
            return false;
        }
        return Objects.equals(annotation.annotationType(), annotationType);
    }

    public static Predicate<Annotation> excludedType(Class<? extends Annotation> excludedAnnotationType) {
        return annotation -> !AnnotationUtils.isSameType(annotation, excludedAnnotationType);
    }

    public static <T> T getAttribute(Annotation annotation, String attributeName) throws IllegalArgumentException {
        return annotation == null ? null : (T)MethodUtils.invokeMethod(annotation, attributeName, new Object[0]);
    }

    public static <T> T getValue(Annotation annotation) throws IllegalArgumentException {
        return AnnotationUtils.getAttribute(annotation, "value");
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, String annotationClassName) throws ClassCastException {
        Class<A> annotationType = AnnotationUtils.resolveAnnotationType(annotatedElement, annotationClassName);
        if (annotationType == null) {
            return null;
        }
        return annotatedElement.getAnnotation(annotationType);
    }

    public static List<Annotation> getDeclaredAnnotations(AnnotatedElement annotatedElement, Predicate<Annotation> ... annotationsToFilter) {
        if (annotatedElement == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Streams.filterAll(Arrays.asList(annotatedElement.getDeclaredAnnotations()), annotationsToFilter));
    }

    public static List<Annotation> getAllDeclaredAnnotations(AnnotatedElement annotatedElement, Predicate<Annotation> ... annotationsToFilter) {
        if (AnnotationUtils.isType(annotatedElement)) {
            return AnnotationUtils.getAllDeclaredAnnotations((Class)annotatedElement, annotationsToFilter);
        }
        return AnnotationUtils.getDeclaredAnnotations(annotatedElement, annotationsToFilter);
    }

    public static List<Annotation> getAllDeclaredAnnotations(Class<?> type, Predicate<Annotation> ... annotationsToFilter) {
        if (type == null) {
            return Collections.emptyList();
        }
        LinkedList<Annotation> allAnnotations = new LinkedList<Annotation>();
        LinkedHashSet allTypes = new LinkedHashSet();
        allTypes.add(type);
        allTypes.addAll(ClassUtils.getAllInheritedTypes(type, t -> !Object.class.equals(t)));
        for (Class clazz : allTypes) {
            allAnnotations.addAll(AnnotationUtils.getDeclaredAnnotations(clazz, annotationsToFilter));
        }
        return Collections.unmodifiableList(allAnnotations);
    }

    public static List<Annotation> getMetaAnnotations(Class<? extends Annotation> annotationType, Predicate<Annotation> ... metaAnnotationsToFilter) {
        return AnnotationUtils.getDeclaredAnnotations(annotationType, AnnotationUtils.excludedType(Target.class), AnnotationUtils.excludedType(Retention.class), AnnotationUtils.excludedType(Documented.class), Predicates.and(metaAnnotationsToFilter));
    }

    public static List<Annotation> getAllMetaAnnotations(Class<? extends Annotation> annotationType, Predicate<Annotation> ... annotationsToFilter) {
        LinkedList<Annotation> allMetaAnnotations = new LinkedList<Annotation>();
        List<Annotation> metaAnnotations = AnnotationUtils.getMetaAnnotations(annotationType, new Predicate[0]);
        allMetaAnnotations.addAll(metaAnnotations);
        for (Annotation metaAnnotation : metaAnnotations) {
            allMetaAnnotations.addAll(AnnotationUtils.getAllMetaAnnotations(metaAnnotation.annotationType(), new Predicate[0]));
        }
        return Collections.unmodifiableList(Streams.filterAll(allMetaAnnotations, annotationsToFilter));
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, String annotationClassName) {
        return AnnotationUtils.findAnnotation(annotatedElement, AnnotationUtils.resolveAnnotationType(annotatedElement, annotationClassName));
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return (A)Streams.filterFirst(AnnotationUtils.getAllDeclaredAnnotations(annotatedElement, new Predicate[0]), a -> AnnotationUtils.isSameType(a, annotationType));
    }

    public static <A extends Annotation> List<A> findMetaAnnotations(Class<? extends Annotation> annotationType, Class<A> metaAnnotationType) {
        return AnnotationUtils.getAllMetaAnnotations(annotationType, a -> AnnotationUtils.isSameType(a, metaAnnotationType));
    }

    public static <A extends Annotation> List<A> findMetaAnnotations(AnnotatedElement annotatedElement, Class<A> metaAnnotationType) {
        LinkedList<A> metaAnnotations = new LinkedList<A>();
        for (Annotation annotation : AnnotationUtils.getAllDeclaredAnnotations(annotatedElement, new Predicate[0])) {
            metaAnnotations.addAll(AnnotationUtils.findMetaAnnotations(annotation.annotationType(), metaAnnotationType));
        }
        return Collections.unmodifiableList(metaAnnotations);
    }

    public static <A extends Annotation> A findMetaAnnotation(AnnotatedElement annotatedElement, String metaAnnotationClassName) {
        return AnnotationUtils.findMetaAnnotation(annotatedElement, AnnotationUtils.resolveAnnotationType(annotatedElement, metaAnnotationClassName));
    }

    public static <A extends Annotation> A findMetaAnnotation(Class<? extends Annotation> annotationType, Class<A> metaAnnotationType) {
        return (A)((Annotation)CollectionUtils.first(AnnotationUtils.findMetaAnnotations(annotationType, metaAnnotationType)));
    }

    public static <A extends Annotation> A findMetaAnnotation(AnnotatedElement annotatedElement, Class<A> metaAnnotationType) {
        return (A)((Annotation)CollectionUtils.first(AnnotationUtils.findMetaAnnotations(annotatedElement, metaAnnotationType)));
    }

    public static boolean isAnnotationPresent(Class<?> type, boolean matchAll, Class<? extends Annotation> ... annotationTypes) {
        int size;
        int n = size = annotationTypes == null ? 0 : annotationTypes.length;
        if (size < 1) {
            return false;
        }
        int presentCount = 0;
        for (int i = 0; i < size; ++i) {
            Class<? extends Annotation> annotationType = annotationTypes[i];
            if (AnnotationUtils.findAnnotation(type, annotationType) == null && AnnotationUtils.findMetaAnnotation(type, annotationType) == null) continue;
            ++presentCount;
        }
        return matchAll ? presentCount == size : presentCount > 0;
    }

    public static boolean isAnnotationPresent(Class<?> type, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.isAnnotationPresent(type, true, annotationType);
    }

    public static boolean isAnnotationPresent(AnnotatedElement annotatedElement, String annotationClassName) {
        ClassLoader classLoader = annotatedElement.getClass().getClassLoader();
        Class<?> resolvedType = ClassUtils.resolveClass(annotationClassName, classLoader);
        if (resolvedType == null || !Annotation.class.isAssignableFrom(resolvedType)) {
            return false;
        }
        return AnnotationUtils.isAnnotationPresent(annotatedElement, resolvedType);
    }

    public static boolean isAnnotationPresent(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        if (AnnotationUtils.isType(annotatedElement)) {
            return AnnotationUtils.isAnnotationPresent((Class)annotatedElement, annotationType);
        }
        return annotatedElement.isAnnotationPresent(annotationType) || AnnotationUtils.findMetaAnnotation(annotatedElement, annotationType) != null;
    }

    public static boolean isAllAnnotationPresent(Class<?> type, Class<? extends Annotation> ... annotationTypes) {
        return AnnotationUtils.isAnnotationPresent(type, true, annotationTypes);
    }

    public static boolean isAnyAnnotationPresent(Class<?> type, Class<? extends Annotation> ... annotationTypes) {
        return AnnotationUtils.isAnnotationPresent(type, false, annotationTypes);
    }

    public static <T> T getDefaultValue(Annotation annotation, String attributeName) {
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static <T> T getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        Method method = MethodUtils.findMethod(annotationType, attributeName);
        return (T)(method == null ? null : method.getDefaultValue());
    }

    public static Map<String, Object> filterDefaultValues(Class<? extends Annotation> annotationType, Map<String, Object> attributes) {
        LinkedHashMap<String, Object> filteredAttributes = new LinkedHashMap<String, Object>(attributes.size());
        attributes.forEach((key, val) -> {
            if (!Objects.deepEquals(val, AnnotationUtils.getDefaultValue(annotationType, key))) {
                filteredAttributes.put((String)key, val);
            }
        });
        Object interfaceClassValue = filteredAttributes.get("interfaceClass");
        if (interfaceClassValue instanceof String && StringUtils.isEquals((String)interfaceClassValue, "void")) {
            filteredAttributes.remove("interfaceClass");
        }
        return filteredAttributes;
    }

    public static Map<String, Object> filterDefaultValues(Annotation annotation, Map<String, Object> attributes) {
        return AnnotationUtils.filterDefaultValues(annotation.annotationType(), attributes);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, boolean filterDefaultValue) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Method[] methods = annotationType.getMethods();
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(methods.length);
        for (Method method : methods) {
            try {
                if (method.getDeclaringClass() == Annotation.class) continue;
                String name = method.getName();
                Object value = method.invoke((Object)annotation, new Object[0]);
                if (filterDefaultValue && Objects.deepEquals(value, method.getDefaultValue())) continue;
                attributes.put(name, value);
            }
            catch (Exception e) {
                throw new IllegalStateException("get attribute value of annotation failed: " + method, e);
            }
        }
        return attributes;
    }
}

