/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server;

import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.filter.FilterChain;
import com.alipay.sofa.rpc.filter.ProviderInvoker;
import com.alipay.sofa.rpc.invoke.Invoker;

public class ProviderProxyInvoker
implements Invoker {
    private final ProviderConfig providerConfig;
    private final FilterChain filterChain;

    public ProviderProxyInvoker(ProviderConfig providerConfig) {
        this.providerConfig = providerConfig;
        this.filterChain = FilterChain.buildProviderChain(providerConfig, new ProviderInvoker(providerConfig));
    }

    @Override
    public SofaResponse invoke(SofaRequest request) throws SofaRpcException {
        RpcInvokeContext.getContext().put("_provider_filter_start_time_nano", System.nanoTime());
        SofaResponse sofaResponse = this.filterChain.invoke(request);
        RpcInvokeContext.getContext().put("_provider_filter_end_time_nano", System.nanoTime());
        this.calculateProviderFilterTime();
        return sofaResponse;
    }

    private void calculateProviderFilterTime() {
        Long filterStartTime = (Long)RpcInvokeContext.getContext().get("_provider_filter_start_time_nano");
        Long filterEndTime = (Long)RpcInvokeContext.getContext().get("_provider_filter_end_time_nano");
        Long invokerStartTime = (Long)RpcInvokeContext.getContext().get("_provider_invoke_start_time_nano");
        Long invokerEndTime = (Long)RpcInvokeContext.getContext().get("_provider_invoke_end_time_nano");
        if (filterStartTime != null && filterEndTime != null && invokerStartTime != null && invokerEndTime != null) {
            RpcInvokeContext.getContext().put("_server_filter_time_nano", filterEndTime - filterStartTime - (invokerEndTime - invokerStartTime));
        }
    }

    public ProviderConfig getProviderConfig() {
        return this.providerConfig;
    }
}

