/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.session;

import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpServerSession;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.model.ToolContext;

public class McpSessionHelper {
    public static McpSyncServerExchange getMcpSyncServerExchange(ToolContext toolContext) {
        if (Objects.isNull(toolContext)) {
            throw new IllegalArgumentException("ToolContext is required");
        }
        Map contextMap = toolContext.getContext();
        if (Objects.isNull(contextMap) || contextMap.isEmpty()) {
            throw new IllegalArgumentException("ToolContext is required");
        }
        McpSyncServerExchange mcpSyncServerExchange = (McpSyncServerExchange)contextMap.get("exchange");
        if (Objects.isNull(mcpSyncServerExchange)) {
            throw new IllegalArgumentException("McpSyncServerExchange is required in ToolContext");
        }
        return mcpSyncServerExchange;
    }

    public static String getSessionId(McpSyncServerExchange mcpSyncServerExchange) throws NoSuchFieldException, IllegalAccessException {
        Field asyncExchangeField = mcpSyncServerExchange.getClass().getDeclaredField("exchange");
        asyncExchangeField.setAccessible(true);
        Object session = McpSessionHelper.getSession(mcpSyncServerExchange, asyncExchangeField);
        if (Objects.isNull(session)) {
            throw new IllegalArgumentException("Session is required in McpAsyncServerExchange");
        }
        McpServerSession mcpServerSession = (McpServerSession)session;
        return mcpServerSession.getId();
    }

    public static McpServerSession getSession(McpSyncServerExchange mcpSyncServerExchange) throws NoSuchFieldException, IllegalAccessException {
        Field asyncExchangeField = mcpSyncServerExchange.getClass().getDeclaredField("exchange");
        asyncExchangeField.setAccessible(true);
        Object session = McpSessionHelper.getSession(mcpSyncServerExchange, asyncExchangeField);
        if (Objects.isNull(session)) {
            throw new IllegalArgumentException("Session is required in McpAsyncServerExchange");
        }
        return (McpServerSession)session;
    }

    private static Object getSession(McpSyncServerExchange mcpSyncServerExchange, Field asyncExchangeField) throws IllegalAccessException, NoSuchFieldException {
        Object asyncExchange = asyncExchangeField.get(mcpSyncServerExchange);
        if (Objects.isNull(asyncExchange)) {
            throw new IllegalArgumentException("McpAsyncServerExchange is required in McpSyncServerExchange");
        }
        McpAsyncServerExchange mcpAsyncServerExchange = (McpAsyncServerExchange)asyncExchange;
        Field sessionField = mcpAsyncServerExchange.getClass().getDeclaredField("session");
        sessionField.setAccessible(true);
        return sessionField.get(mcpAsyncServerExchange);
    }
}

