/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -3374522920399590093L;
    final byte dimension;
    final boolean hasZ;
    final boolean hasM;

    PackedCoordinateSequence(PackedCoordinateSequence original) {
        this.dimension = original.dimension;
        this.hasZ = original.hasZ;
        this.hasM = original.hasM;
    }

    PackedCoordinateSequence(int dimension, int measures) {
        ArgumentChecks.ensureBetween((String)"measures", (int)0, (int)100, (int)measures);
        ArgumentChecks.ensureBetween((String)"dimension", (int)(2 + measures), (int)(3 + measures), (int)dimension);
        this.dimension = (byte)dimension;
        this.hasM = measures != 0;
        this.hasZ = dimension - measures >= 3;
    }

    public final int getDimension() {
        return this.dimension;
    }

    public final int getMeasures() {
        return this.dimension - (this.hasZ ? 3 : 2);
    }

    public final boolean hasZ() {
        return this.hasZ;
    }

    public final boolean hasM() {
        return this.hasM;
    }

    public final double getX(int index) {
        return this.coordinate(index * this.dimension + 0);
    }

    public final double getY(int index) {
        return this.coordinate(index * this.dimension + 1);
    }

    public final double getZ(int index) {
        return this.hasZ ? this.coordinate(index * this.dimension + 2) : java.lang.Double.NaN;
    }

    public final double getM(int index) {
        return this.hasM ? this.coordinate(index * this.dimension + (this.hasZ ? 3 : 2)) : java.lang.Double.NaN;
    }

    public final Coordinate getCoordinate(int index) {
        double x = this.coordinate(index *= this.dimension);
        double y = this.coordinate(++index);
        if (!(this.hasZ | this.hasM)) {
            return new CoordinateXY(x, y);
        }
        double z = this.coordinate(++index);
        if (!this.hasM) {
            return new Coordinate(x, y, z);
        }
        if (!this.hasZ) {
            return new CoordinateXYM(x, y, z);
        }
        return new CoordinateXYZM(x, y, z, this.coordinate(++index));
    }

    public final void getCoordinate(int index, Coordinate dest) {
        dest.x = this.coordinate(index *= this.dimension);
        dest.y = this.coordinate(++index);
        if (this.hasZ) {
            dest.setZ(this.coordinate(++index));
        }
        if (this.hasM) {
            dest.setM(this.coordinate(++index));
        }
    }

    public final Coordinate getCoordinateCopy(int index) {
        return this.getCoordinate(index);
    }

    public final double getOrdinate(int index, int dim) {
        return this.coordinate(index * this.dimension + dim);
    }

    abstract double coordinate(int var1);

    abstract void setCoordinates(Coordinate[] var1);

    void setCoordinates(CoordinateSequence values) {
        this.setCoordinates(values.toCoordinateArray());
    }

    public final Coordinate[] toCoordinateArray() {
        Coordinate[] coordinates = new Coordinate[this.size()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = this.getCoordinate(i);
        }
        return coordinates;
    }

    public final String toString() {
        return CoordinateSequences.toString((CoordinateSequence)this);
    }

    public int hashCode() {
        return 37 * this.dimension ^ (this.hasZ ? 3 : 7) ^ (this.hasM ? 11 : 17);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            PackedCoordinateSequence other = (PackedCoordinateSequence)obj;
            return other.dimension == this.dimension && other.hasZ == this.hasZ && other.hasM == this.hasM;
        }
        return false;
    }

    @Deprecated
    public final Object clone() {
        return this.copy();
    }

    static final class Float
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 2625498691139718968L;
        private final float[] coordinates;

        private Float(Float original) {
            super(original);
            this.coordinates = (float[])original.coordinates.clone();
        }

        Float(float[] array, int length) {
            super(2, 0);
            this.coordinates = Arrays.copyOf(array, length);
        }

        Float(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coordinates = new float[Math.multiplyExact(size, dimension)];
        }

        public int size() {
            return this.coordinates.length / this.dimension;
        }

        @Override
        double coordinate(int index) {
            return this.coordinates[index];
        }

        public void setOrdinate(int index, int dim, double value) {
            this.coordinates[index * this.dimension + dim] = (float)value;
        }

        @Override
        void setCoordinates(Coordinate[] values) {
            int t = 0;
            int skip = this.getMeasures();
            if (this.hasM) {
                --skip;
            }
            for (Coordinate c : values) {
                this.coordinates[t++] = (float)c.getX();
                this.coordinates[t++] = (float)c.getY();
                if (this.hasZ) {
                    this.coordinates[t++] = (float)c.getZ();
                }
                if (this.hasM) {
                    this.coordinates[t++] = (float)c.getM();
                }
                t += skip;
            }
            assert (t == this.coordinates.length);
        }

        @Override
        void setCoordinates(CoordinateSequence values) {
            if (values instanceof PackedCoordinateSequence.Float) {
                System.arraycopy(((PackedCoordinateSequence.Float)values).getRawCoordinates(), 0, this.coordinates, 0, this.coordinates.length);
            } else {
                super.setCoordinates(values);
            }
        }

        public Envelope expandEnvelope(Envelope envelope) {
            for (int i = 0; i < this.coordinates.length; i += this.dimension) {
                envelope.expandToInclude((double)this.coordinates[i], (double)this.coordinates[i + 1]);
            }
            return envelope;
        }

        public CoordinateSequence copy() {
            return new Float(this);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.coordinates) + super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Arrays.equals(((Float)obj).coordinates, this.coordinates);
        }
    }

    static final class Double
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 1940132733783453171L;
        private final double[] coordinates;

        private Double(Double original) {
            super(original);
            this.coordinates = (double[])original.coordinates.clone();
        }

        Double(double[] array, int length) {
            super(2, 0);
            this.coordinates = Arrays.copyOf(array, length);
        }

        Double(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coordinates = new double[Math.multiplyExact(size, dimension)];
        }

        public int size() {
            return this.coordinates.length / this.dimension;
        }

        @Override
        double coordinate(int index) {
            return this.coordinates[index];
        }

        public void setOrdinate(int index, int dim, double value) {
            this.coordinates[index * this.dimension + dim] = value;
        }

        @Override
        void setCoordinates(Coordinate[] values) {
            int t = 0;
            int skip = this.getMeasures();
            if (this.hasM) {
                --skip;
            }
            for (Coordinate c : values) {
                this.coordinates[t++] = c.getX();
                this.coordinates[t++] = c.getY();
                if (this.hasZ) {
                    this.coordinates[t++] = c.getZ();
                }
                if (this.hasM) {
                    this.coordinates[t++] = c.getM();
                }
                t += skip;
            }
            assert (t == this.coordinates.length);
        }

        @Override
        void setCoordinates(CoordinateSequence values) {
            if (values instanceof PackedCoordinateSequence.Double) {
                System.arraycopy(((PackedCoordinateSequence.Double)values).getRawCoordinates(), 0, this.coordinates, 0, this.coordinates.length);
            } else {
                super.setCoordinates(values);
            }
        }

        public Envelope expandEnvelope(Envelope envelope) {
            for (int i = 0; i < this.coordinates.length; i += this.dimension) {
                envelope.expandToInclude(this.coordinates[i], this.coordinates[i + 1]);
            }
            return envelope;
        }

        public CoordinateSequence copy() {
            return new Double(this);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.coordinates) + super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Arrays.equals(((Double)obj).coordinates, this.coordinates);
        }
    }
}

