/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.NumberType;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.resources.Errors;

public final class Numbers {
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte BIG_DECIMAL = 11;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte BIG_INTEGER = 10;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte FRACTION = 7;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte DOUBLE = 9;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte FLOAT = 8;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte LONG = 6;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte INTEGER = 5;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte SHORT = 4;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte BYTE = 3;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte CHARACTER = 2;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte BOOLEAN = 1;
    @Deprecated(since="1.6", forRemoval=true)
    public static final byte OTHER = 0;
    private static final Map<Class<?>, Object> NIL_VALUES = Map.of(Map.class, Collections.EMPTY_MAP, Set.class, Collections.EMPTY_SET, List.class, Collections.EMPTY_LIST, Queue.class, Containers.emptyQueue(), SortedSet.class, Collections.emptySortedSet(), NavigableSet.class, Collections.emptyNavigableSet());

    private Numbers() {
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static boolean isFloat(Class<?> type) {
        return NumberType.isFractional(type);
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static boolean isInteger(Class<?> type) {
        return NumberType.isInteger(type);
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static boolean isNumber(Class<?> type) {
        return NumberType.isReal(type);
    }

    public static boolean isNaN(Number value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Float) {
            return ((Float)value).isNaN();
        }
        if (value instanceof Fraction) {
            return ((Fraction)value).isNaN();
        }
        if (value instanceof DoubleDouble) {
            return ((DoubleDouble)value).isNaN();
        }
        return false;
    }

    public static long round(Number value) {
        long n;
        NumberType mapping = NumberType.forNumberClass(value.getClass());
        switch (mapping) {
            case DOUBLE_DOUBLE: {
                return value.longValue();
            }
            case BIG_DECIMAL: {
                return ((BigDecimal)value).longValueExact();
            }
            case BIG_INTEGER: {
                return ((BigInteger)value).longValueExact();
            }
        }
        if (mapping.isInteger()) {
            return value.longValue();
        }
        double v = value.doubleValue();
        if (Math.abs(v - (double)(n = Math.round(v))) <= 0.5) {
            return n;
        }
        throw new ArithmeticException(Errors.format((short)12, value, Long.TYPE));
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static int primitiveBitCount(Class<?> type) throws IllegalArgumentException {
        if (type == null) {
            return 0;
        }
        return NumberType.forNumberClass(type).size().orElseThrow();
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static <N> Class<N> primitiveToWrapper(Class<N> type) {
        return NumberType.primitiveToWrapper(type);
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static <N> Class<N> wrapperToPrimitive(Class<N> type) {
        return NumberType.wrapperToPrimitive(type);
    }

    public static Class<? extends Number> widestClass(Number n1, Number n2) throws IllegalArgumentException {
        return Numbers.widestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class<? extends Number> widestClass(Class<? extends Number> c1, Class<? extends Number> c2) throws IllegalArgumentException {
        if (c1 == c2) {
            return c2;
        }
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return NumberType.forNumberClass(c1).isWiderThan(NumberType.forNumberClass(c2)) ? c1 : c2;
    }

    public static Class<? extends Number> narrowestClass(Number n1, Number n2) throws IllegalArgumentException {
        return Numbers.narrowestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class<? extends Number> narrowestClass(Class<? extends Number> c1, Class<? extends Number> c2) throws IllegalArgumentException {
        if (c1 == c2) {
            return c2;
        }
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return NumberType.forNumberClass(c1).isNarrowerThan(NumberType.forNumberClass(c2)) ? c1 : c2;
    }

    public static Class<? extends Number> narrowestClass(Number value) {
        if (value == null) {
            return null;
        }
        boolean isFloat = false;
        long longValue = value.longValue();
        switch (NumberType.forNumberClass(value.getClass())) {
            default: {
                double doubleValue = value.doubleValue();
                float floatValue = (float)doubleValue;
                boolean bl = isFloat = Double.doubleToLongBits(floatValue) == Double.doubleToLongBits(doubleValue);
                if (doubleValue != (double)longValue) {
                    return isFloat ? Float.class : Double.class;
                }
            }
            case LONG: {
                if ((long)((int)longValue) != longValue) {
                    return isFloat ? Float.class : Long.class;
                }
            }
            case INTEGER: {
                if ((long)((short)longValue) != longValue) {
                    return Integer.class;
                }
            }
            case SHORT: {
                if ((long)((byte)longValue) == longValue) break;
                return Short.class;
            }
            case BYTE: 
        }
        return Byte.class;
    }

    public static Number narrowestNumber(Number value) {
        Number candidate;
        if (value == null) {
            return null;
        }
        boolean isFloat = false;
        long longValue = value.longValue();
        switch (NumberType.forNumberClass(value.getClass())) {
            default: {
                double doubleValue = value.doubleValue();
                float floatValue = (float)doubleValue;
                boolean bl = isFloat = Double.doubleToLongBits(floatValue) == Double.doubleToLongBits(doubleValue);
                if (doubleValue != (double)longValue) {
                    if (isFloat) {
                        candidate = Float.valueOf(floatValue);
                        break;
                    }
                    candidate = doubleValue;
                    break;
                }
            }
            case LONG: {
                if ((long)((int)longValue) != longValue) {
                    if (isFloat) {
                        candidate = Float.valueOf(longValue);
                        break;
                    }
                    candidate = longValue;
                    break;
                }
            }
            case INTEGER: {
                if ((long)((short)longValue) != longValue) {
                    candidate = (int)longValue;
                    break;
                }
            }
            case SHORT: {
                if ((long)((byte)longValue) != longValue) {
                    candidate = (short)longValue;
                    break;
                }
            }
            case BYTE: {
                candidate = (byte)longValue;
            }
        }
        return value.equals(candidate) ? (Number)value : (Number)candidate;
    }

    public static Number narrowestNumber(String value) throws NumberFormatException {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return Numbers.narrowestNumber(Double.valueOf(value));
        }
        return Numbers.narrowestNumber(Long.valueOf(value));
    }

    public static <N extends Number> N cast(Number number, Class<N> type) throws IllegalArgumentException {
        if (number == null || type.isInstance(number)) {
            return (N)number;
        }
        try {
            return (N)((Number)type.cast(NumberType.forNumberClass(type).cast(number)));
        }
        catch (ArithmeticException | UnsupportedOperationException e) {
            throw new IllegalArgumentException(Errors.format((short)138, type), e);
        }
    }

    public static <N extends Number> N wrap(double value, Class<N> type) throws IllegalArgumentException {
        try {
            return (N)((Number)type.cast(NumberType.forNumberClass(type).wrapExact(value)));
        }
        catch (ArithmeticException | UnsupportedOperationException e) {
            throw new IllegalArgumentException(Errors.format((short)12, value, type), e);
        }
    }

    public static <N extends Number> N wrap(long value, Class<N> type) throws IllegalArgumentException {
        try {
            return (N)((Number)type.cast(NumberType.forNumberClass(type).wrapExact(value)));
        }
        catch (ArithmeticException | UnsupportedOperationException e) {
            throw new IllegalArgumentException(Errors.format((short)12, value, type), e);
        }
    }

    public static <T> T valueOf(String text, Class<T> type) throws IllegalArgumentException, NumberFormatException {
        Object value = text == null || type == String.class ? text : NumberType.forNumberClass(type).parse(text);
        return type.cast(value);
    }

    public static <T> T valueOfNil(Class<T> type) {
        if (type == null) {
            return null;
        }
        Comparable<?> value = NumberType.forClass(type).orElse(NumberType.NULL).nilValue();
        if (value == null && (value = NIL_VALUES.get(type)) == null && type != Object.class) {
            if (type.isAssignableFrom(Set.class)) {
                value = Collections.EMPTY_SET;
            } else {
                Class<?> element = type.getComponentType();
                if (element != null) {
                    value = Array.newInstance(element, 0);
                }
            }
        }
        return type.cast(value);
    }

    @Deprecated(since="1.6", forRemoval=true)
    public static byte getEnumConstant(Class<?> type) {
        switch (NumberType.forClass(type).orElse(NumberType.NULL)) {
            case BIG_DECIMAL: {
                return 11;
            }
            case BIG_INTEGER: {
                return 10;
            }
            case FRACTION: {
                return 7;
            }
            case DOUBLE: {
                return 9;
            }
            case FLOAT: {
                return 8;
            }
            case LONG: {
                return 6;
            }
            case INTEGER: {
                return 5;
            }
            case SHORT: {
                return 4;
            }
            case BYTE: {
                return 3;
            }
            case CHARACTER: {
                return 2;
            }
            case BOOLEAN: {
                return 1;
            }
        }
        return 0;
    }
}

