/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.Locale;

@Internal
public class VariableDefaultValuesOfCorrectType
extends AbstractRule {
    public VariableDefaultValuesOfCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkVariableDefinition(VariableDefinition variableDefinition) {
        GraphQLInputType inputType = this.getValidationContext().getInputType();
        if (inputType == null) {
            return;
        }
        if (variableDefinition.getDefaultValue() != null && !this.getValidationUtil().isValidLiteralValue(variableDefinition.getDefaultValue(), inputType, this.getValidationContext().getSchema(), this.getValidationContext().getGraphQLContext(), Locale.getDefault())) {
            String message = this.i18n(ValidationErrorType.BadValueForDefaultArg, "VariableDefaultValuesOfCorrectType.badDefault", variableDefinition.getDefaultValue(), GraphQLTypeUtil.simplePrint(inputType));
            this.addError(ValidationErrorType.BadValueForDefaultArg, variableDefinition.getSourceLocation(), message);
        }
    }
}

