/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.IntervalMathUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0013'\u0001NB\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011!I\u0005A!f\u0001\n\u0003Q\u0005\u0002C*\u0001\u0005#\u0005\u000b\u0011B&\t\u000bQ\u0003A\u0011A+\t\u000bQ\u0003A\u0011\u0001.\t\u000bu\u0003A\u0011\t0\t\u000b\u0015\u0004A\u0011\t4\t\u000bI\u0004A\u0011\t4\t\u000bM\u0004A\u0011\t;\t\r\u0005\u001d\u0001\u0001\"\u0011g\u0011)\tI\u0001\u0001EC\u0002\u0013%\u00111\u0002\u0005\b\u0003K\u0001A\u0011KA\u0014\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!a\u000f\u0001\t#\ni\u0004C\u0005\u0002H\u0001\t\t\u0011\"\u0001\u0002J!I\u0011\u0011\u000b\u0001\u0012\u0002\u0013\u0005\u00111\u000b\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003'B\u0011\"a\u001b\u0001#\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CAB\u0001\u0005\u0005I\u0011AAC\u0011%\t9\tAA\u0001\n\u0003\tI\tC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0011\u0002\u0012\"I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0015\u0005\n\u0003W\u0003\u0011\u0011!C!\u0003[;\u0011\"!5'\u0003\u0003E\t!a5\u0007\u0011\u00152\u0013\u0011!E\u0001\u0003+Da\u0001V\u000f\u0005\u0002\u0005\r\b\"CAs;\u0005\u0005IQIAt\u0011%\tI/HA\u0001\n\u0003\u000bY\u000fC\u0005\u0002tv\t\n\u0011\"\u0001\u0002n!I\u0011Q_\u000f\u0002\u0002\u0013\u0005\u0015q\u001f\u0005\n\u0005\u000bi\u0012\u0013!C\u0001\u0003[B\u0011Ba\u0002\u001e\u0003\u0003%IA!\u0003\u0003\u0011M+(\r\u001e:bGRT!a\n\u0015\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003S)\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003W1\n1a]9m\u0015\tic&A\u0003ta\u0006\u00148N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0005\u0001QBd\b\u0005\u00026m5\ta%\u0003\u00028M\t\u0001\")\u001b8bef\f%/\u001b;i[\u0016$\u0018n\u0019\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\b!J|G-^2u!\tIt(\u0003\u0002Au\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005\u0019\u0005CA\u001bE\u0013\t)eE\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013\u0001C3wC2lu\u000eZ3\u0016\u0003-\u0003\"\u0001T(\u000f\u0005Uj\u0015B\u0001('\u0003!)e/\u00197N_\u0012,\u0017B\u0001)R\u0005\u00151\u0016\r\\;f\u0013\t\u0011&HA\u0006F]VlWM]1uS>t\u0017!C3wC2lu\u000eZ3!\u0003\u0019a\u0014N\\5u}Q!ak\u0016-Z!\t)\u0004\u0001C\u0003B\u000f\u0001\u00071\tC\u0003H\u000f\u0001\u00071\tC\u0004J\u000fA\u0005\t\u0019A&\u0015\u0007Y[F\fC\u0003B\u0011\u0001\u00071\tC\u0003H\u0011\u0001\u00071)A\u0005j]B,H\u000fV=qKV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002cU\u0005)A/\u001f9fg&\u0011A-\u0019\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\faa]=nE>dW#A4\u0011\u0005!|gBA5n!\tQ'(D\u0001l\u0015\ta''\u0001\u0004=e>|GOP\u0005\u0003]j\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011aNO\u0001\u000eI\u0016\u001c\u0017.\\1m\u001b\u0016$\bn\u001c3\u0002#I,7/\u001e7u\t\u0016\u001c\u0017.\\1m)f\u0004X\r\u0006\u0004vqv|\u00181\u0001\t\u0003AZL!a^1\u0003\u0017\u0011+7-[7bYRK\b/\u001a\u0005\u0006s2\u0001\rA_\u0001\u0003aF\u0002\"!O>\n\u0005qT$aA%oi\")a\u0010\u0004a\u0001u\u0006\u00111/\r\u0005\u0007\u0003\u0003a\u0001\u0019\u0001>\u0002\u0005A\u0014\u0004BBA\u0003\u0019\u0001\u0007!0\u0001\u0002te\u000512-\u00197f]\u0012\f'/\u00138uKJ4\u0018\r\\'fi\"|G-A\u0004ok6,'/[2\u0016\u0005\u00055\u0001CBA\b\u00033\tyB\u0004\u0003\u0002\u0012\u0005Uab\u00016\u0002\u0014%\t1(C\u0002\u0002\u0018i\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0005u!a\u0002(v[\u0016\u0014\u0018n\u0019\u0006\u0004\u0003/Q\u0004cA\u001d\u0002\"%\u0019\u00111\u0005\u001e\u0003\u0007\u0005s\u00170\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0004\u0002 \u0005%\u0012Q\u0006\u0005\b\u0003Wy\u0001\u0019AA\u0010\u0003\u0019Ig\u000e];uc!9\u0011qF\bA\u0002\u0005}\u0011AB5oaV$('A\bfq\u0006\u001cG/T1uQ6+G\u000f[8e+\t\t)\u0004\u0005\u0003:\u0003o9\u0017bAA\u001du\t1q\n\u001d;j_:\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bY\u000by$a\u0011\t\r\u0005\u0005\u0013\u00031\u0001D\u0003\u001dqWm\u001e'fMRDa!!\u0012\u0012\u0001\u0004\u0019\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\b-\u0006-\u0013QJA(\u0011\u001d\t%\u0003%AA\u0002\rCqa\u0012\n\u0011\u0002\u0003\u00071\tC\u0004J%A\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000b\u0016\u0004\u0007\u0006]3FAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r$(\u0001\u0006b]:|G/\u0019;j_:LA!a\u001a\u0002^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA8U\rY\u0015qK\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0005!!.\u0019<b\u0013\r\u0001\u0018\u0011P\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002u\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0010\u0003\u0017C\u0001\"!$\u0019\u0003\u0003\u0005\rA_\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0005CBAK\u00037\u000by\"\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0006]%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a)\u0002*B\u0019\u0011(!*\n\u0007\u0005\u001d&HA\u0004C_>dW-\u00198\t\u0013\u00055%$!AA\u0002\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002$\u0006=\u0006\"CAG7\u0005\u0005\t\u0019AA\u0010QM\u0001\u00111WA]\u0003w\u000by,!1\u0002F\u0006\u001d\u00171ZAg!\r)\u0014QW\u0005\u0004\u0003o3#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003{\u000bQ&\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t1fqB\u0014\u0018\u0007Y\u0017aKb\u0004(O\r1/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAb\u0003UR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006E\r\u0011`\rVs5i\u0018\u00112w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005%\u0017!B\u0019/a9\u0002\u0014!B4s_V\u0004\u0018EAAh\u0003)i\u0017\r\u001e5`MVt7m]\u0001\t'V\u0014GO]1diB\u0011Q'H\n\u0005;\u0005]g\b\u0005\u0005\u0002Z\u0006}7iQ&W\u001b\t\tYNC\u0002\u0002^j\nqA];oi&lW-\u0003\u0003\u0002b\u0006m'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011\u00111[\u0001\ti>\u001cFO]5oOR\u0011\u0011QO\u0001\u0006CB\u0004H.\u001f\u000b\b-\u00065\u0018q^Ay\u0011\u0015\t\u0005\u00051\u0001D\u0011\u00159\u0005\u00051\u0001D\u0011\u001dI\u0005\u0005%AA\u0002-\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tIP!\u0001\u0011\u000be\n9$a?\u0011\re\nipQ\"L\u0013\r\tyP\u000f\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t\r!%!AA\u0002Y\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0001\u0005\u0003\u0002x\t5\u0011\u0002\u0002B\b\u0003s\u0012aa\u00142kK\u000e$\b")
public class Subtract
extends BinaryArithmetic {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private final Enumeration.Value evalMode;
    private volatile boolean bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$3() {
        return Subtract$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Enumeration.Value>> unapply(Subtract subtract) {
        return Subtract$.MODULE$.unapply(subtract);
    }

    public static Enumeration.Value apply$default$3() {
        return Subtract$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Enumeration.Value>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Enumeration.Value, Subtract>>> curried() {
        return Subtract$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Enumeration.Value evalMode() {
        return this.evalMode;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int resultScale = package$.MODULE$.max(s1, s2);
        int resultPrecision = package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1;
        if (this.allowPrecisionLoss()) {
            return DecimalType$.MODULE$.adjustPrecisionScale(resultPrecision, resultScale);
        }
        return DecimalType$.MODULE$.bounded(resultPrecision, resultScale);
    }

    @Override
    public String calendarIntervalMethod() {
        if (this.failOnError()) {
            return "subtractExact";
        }
        return "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return this.checkDecimalOverflow((Decimal)this.numeric().minus(input1, input2), precision, scale);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                return IntervalUtils$.MODULE$.subtractExact((CalendarInterval)input1, (CalendarInterval)input2);
            }
        }
        if (bl) {
            return IntervalUtils$.MODULE$.subtract((CalendarInterval)input1, (CalendarInterval)input2);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalMathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return BoxesRunTime.boxToInteger((int)IntervalMathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2)));
        }
        if (dataType2 instanceof IntegerType && this.failOnError()) {
            return BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2), this.getContextOrNull()));
        }
        if (dataType2 instanceof LongType && this.failOnError()) {
            return BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2), this.getContextOrNull()));
        }
        return this.numeric().minus(input1, input2);
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    @Override
    public Subtract withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Subtract copy(Expression left, Expression right, Enumeration.Value evalMode) {
        return new Subtract(left, right, evalMode);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Enumeration.Value copy$default$3() {
        return this.evalMode();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalMode();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Enumeration.Value value = this.evalMode();
        Enumeration.Value value2 = subtract.evalMode();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right, Enumeration.Value evalMode) {
        this.left = left;
        this.right = right;
        this.evalMode = evalMode;
    }

    public Subtract(Expression left, Expression right) {
        this(left, right, EvalMode$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

