/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impurity;

import org.apache.spark.mllib.tree.impurity.EntropyCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityAggregator;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3Q!\u0002\u0004\u0001\u0019IA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006E\u0001!\ta\t\u0005\u0006M\u0001!\ta\n\u0005\u0006w\u0001!\t\u0001\u0010\u0002\u0012\u000b:$(o\u001c9z\u0003\u001e<'/Z4bi>\u0014(BA\u0004\t\u0003!IW\u000e];sSRL(BA\u0005\u000b\u0003\u0011!(/Z3\u000b\u0005-a\u0011!B7mY&\u0014'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0014\u0007\u0001\u0019r\u0003\u0005\u0002\u0015+5\ta!\u0003\u0002\u0017\r\t\u0011\u0012*\u001c9ve&$\u00180Q4he\u0016<\u0017\r^8s!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)qW/\\\"mCN\u001cXm]\u0002\u0001!\tA\u0002%\u0003\u0002\"3\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u0015\u0001!)QD\u0001a\u0001?\u00051Q\u000f\u001d3bi\u0016$b\u0001K\u00164k]J\u0004C\u0001\r*\u0013\tQ\u0013D\u0001\u0003V]&$\b\"\u0002\u0017\u0004\u0001\u0004i\u0013\u0001C1mYN#\u0018\r^:\u0011\u0007aq\u0003'\u0003\u000203\t)\u0011I\u001d:bsB\u0011\u0001$M\u0005\u0003ee\u0011a\u0001R8vE2,\u0007\"\u0002\u001b\u0004\u0001\u0004y\u0012AB8gMN,G\u000fC\u00037\u0007\u0001\u0007\u0001'A\u0003mC\n,G\u000eC\u00039\u0007\u0001\u0007q$\u0001\u0006ok6\u001c\u0016-\u001c9mKNDQAO\u0002A\u0002A\nAb]1na2,w+Z5hQR\fQbZ3u\u0007\u0006d7-\u001e7bi>\u0014HcA\u001fA\u0003B\u0011ACP\u0005\u0003\u007f\u0019\u0011\u0011#\u00128ue>\u0004\u0018pQ1mGVd\u0017\r^8s\u0011\u0015aC\u00011\u0001.\u0011\u0015!D\u00011\u0001 \u0001")
public class EntropyAggregator
extends ImpurityAggregator {
    private final int numClasses;

    @Override
    public void update(double[] allStats, int offset, double label, int numSamples, double sampleWeight) {
        if (label >= (double)this.numClasses) {
            throw new IllegalArgumentException(new StringBuilder(68).append("EntropyAggregator given label ").append(label).append(" but requires label < numClasses (= ").append(this.numClasses).append(").").toString());
        }
        if (label < 0.0) {
            throw new IllegalArgumentException(new StringBuilder(65).append("EntropyAggregator given label ").append(label).append("but requires label is non-negative.").toString());
        }
        int n = offset + (int)label;
        allStats[n] = allStats[n] + (double)numSamples * sampleWeight;
        int n2 = offset + this.statsSize() - 1;
        allStats[n2] = allStats[n2] + (double)numSamples;
    }

    @Override
    public EntropyCalculator getCalculator(double[] allStats, int offset) {
        return new EntropyCalculator((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(allStats)).view().slice(offset, offset + this.statsSize() - 1).toArray(ClassTag$.MODULE$.Double()), (long)allStats[offset + this.statsSize() - 1]);
    }

    public EntropyAggregator(int numClasses) {
        this.numClasses = numClasses;
        super(numClasses + 1);
    }
}

