/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.CoalescedPartitionSpec$;
import org.apache.spark.sql.execution.PartialReducerPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AQEShuffleReadExec$;
import org.apache.spark.sql.execution.adaptive.AQEShuffleReadRule;
import org.apache.spark.sql.execution.adaptive.ShufflePartitionsUtil$;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.exchange.REBALANCE_PARTITIONS_BY_COL$;
import org.apache.spark.sql.execution.exchange.REBALANCE_PARTITIONS_BY_NONE$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class OptimizeSkewInRebalancePartitions$
extends Rule<SparkPlan>
implements AQEShuffleReadRule {
    public static final OptimizeSkewInRebalancePartitions$ MODULE$ = new OptimizeSkewInRebalancePartitions$();
    private static final Seq<ShuffleOrigin> supportedShuffleOrigins;

    static {
        AQEShuffleReadRule.$init$(MODULE$);
        supportedShuffleOrigins = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{REBALANCE_PARTITIONS_BY_NONE$.MODULE$, REBALANCE_PARTITIONS_BY_COL$.MODULE$}));
    }

    @Override
    public boolean isSupported(ShuffleExchangeLike shuffle) {
        return AQEShuffleReadRule.isSupported$(this, shuffle);
    }

    @Override
    public Seq<ShuffleOrigin> supportedShuffleOrigins() {
        return supportedShuffleOrigins;
    }

    private Seq<ShufflePartitionSpec> optimizeSkewedPartitions(int shuffleId, long[] bytesByPartitionId, long targetSize) {
        double smallPartitionFactor = BoxesRunTime.unboxToDouble((Object)this.conf().getConf(SQLConf$.MODULE$.ADAPTIVE_REBALANCE_PARTITIONS_SMALL_PARTITION_FACTOR()));
        return (Seq)ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.longArrayOps(bytesByPartitionId)).flatMap((Function1 & Serializable)reduceIndex -> OptimizeSkewInRebalancePartitions$.$anonfun$optimizeSkewedPartitions$1(bytesByPartitionId, targetSize, shuffleId, smallPartitionFactor, BoxesRunTime.unboxToInt((Object)reduceIndex)));
    }

    public SparkPlan org$apache$spark$sql$execution$adaptive$OptimizeSkewInRebalancePartitions$$tryOptimizeSkewedPartitions(ShuffleQueryStageExec shuffle) {
        long defaultAdvisorySize = BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES()));
        long advisorySize = BoxesRunTime.unboxToLong((Object)shuffle.advisoryPartitionSize().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> defaultAdvisorySize));
        Option<MapOutputStatistics> mapStats = shuffle.mapStats();
        if (mapStats.isEmpty() || ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.longArrayOps(((MapOutputStatistics)mapStats.get()).bytesByPartitionId()), (Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 <= advisorySize)) {
            return shuffle;
        }
        Seq<ShufflePartitionSpec> newPartitionsSpec = this.optimizeSkewedPartitions(((MapOutputStatistics)mapStats.get()).shuffleId(), ((MapOutputStatistics)mapStats.get()).bytesByPartitionId(), advisorySize);
        return newPartitionsSpec.length() == ((MapOutputStatistics)mapStats.get()).bytesByPartitionId().length ? shuffle : AQEShuffleReadExec$.MODULE$.apply(shuffle, newPartitionsSpec);
    }

    public SparkPlan apply(SparkPlan plan) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ADAPTIVE_OPTIMIZE_SKEWS_IN_REBALANCE_PARTITIONS_ENABLED()))) {
            return plan;
        }
        return (SparkPlan)plan.transformUp((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                A1 A1 = x1;
                Object object = A1 instanceof ShuffleQueryStageExec && OptimizeSkewInRebalancePartitions$.MODULE$.isSupported((shuffleQueryStageExec = (ShuffleQueryStageExec)A1).shuffle()) ? OptimizeSkewInRebalancePartitions$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewInRebalancePartitions$$tryOptimizeSkewedPartitions(shuffleQueryStageExec) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof ShuffleQueryStageExec && OptimizeSkewInRebalancePartitions$.MODULE$.isSupported((shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan).shuffle());
                return bl;
            }
        });
    }

    public static final /* synthetic */ IterableOnce $anonfun$optimizeSkewedPartitions$1(long[] bytesByPartitionId$1, long targetSize$1, int shuffleId$1, double smallPartitionFactor$1, int reduceIndex) {
        List list;
        long bytes = bytesByPartitionId$1[reduceIndex];
        if (bytes > targetSize$1) {
            Option<Seq<PartialReducerPartitionSpec>> newPartitionSpec = ShufflePartitionsUtil$.MODULE$.createSkewPartitionSpecs(shuffleId$1, reduceIndex, targetSize$1, smallPartitionFactor$1);
            if (newPartitionSpec.isEmpty()) {
                CoalescedPartitionSpec coalescedPartitionSpec = CoalescedPartitionSpec$.MODULE$.apply(reduceIndex, reduceIndex + 1, bytes);
                list = package$.MODULE$.Nil().$colon$colon((Object)coalescedPartitionSpec);
            } else {
                MODULE$.logDebug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(34).append("For shuffle ").append(shuffleId$1).append(", partition ").append(reduceIndex).append(" is skew, ").toString()).append(new StringBuilder(21).append("split it into ").append(((SeqOps)newPartitionSpec.get()).size()).append(" parts.").toString()).toString());
                list = (IterableOnce)newPartitionSpec.get();
            }
        } else {
            CoalescedPartitionSpec coalescedPartitionSpec = CoalescedPartitionSpec$.MODULE$.apply(reduceIndex, reduceIndex + 1, bytes);
            list = package$.MODULE$.Nil().$colon$colon((Object)coalescedPartitionSpec);
        }
        return list;
    }

    private OptimizeSkewInRebalancePartitions$() {
    }
}

