/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.sql.execution.streaming.MetadataVersionUtil$;
import org.apache.spark.sql.internal.SQLConf$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\teg\u0001\u0002\u00192\u0001yB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A\u0011\u000e\u0001B\u0002B\u0003-!\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0004x\u0001\t\u0007I1\u0002=\t\u000f\u0005\r\u0002\u0001)A\u0005s\"I\u0011Q\u0005\u0001C\u0002\u0013-\u0011q\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002*!I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u00026!I\u0011q\t\u0001C\u0002\u0013E\u0011\u0011\n\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002L!I\u00111\u000b\u0001C\u0002\u0013E\u0011Q\u000b\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002X!Q\u0011q\f\u0001C\u0002\u0013EQ'!\u0019\t\u0011\u0005e\u0004\u0001)A\u0005\u0003GB\u0011\"a\u001f\u0001\u0005\u0004%\t\"! \t\u0011\u0005\r\u0005\u0001)A\u0005\u0003\u007fBq!a&\u0001\t#\tI\nC\u0004\u0002 \u0002!\t\"!)\t\u000f\u0005\u0015\u0006\u0001\"\u0005\u0002(\"9\u00111\u0016\u0001\u0005\u0012\u00055\u0006bBAe\u0001\u0011E\u00111\u001a\u0005\b\u0003/\u0004A\u0011IAm\u0011\u001d\ty\u000e\u0001C!\u0003CDq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002t\u0002!\t!!>\t\u0013\te\u0001!%A\u0005\u0002\tm\u0001b\u0002B\u001b\u0001\u0011E!q\u0007\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBq!a8\u0001\t\u0003\u0012\t\u0006C\u0004\u0003h\u0001!\tA!\u001b\t\u000f\t-\u0004\u0001\"\u0011\u0003n!9!\u0011\u000f\u0001\u0005\u0002\tM\u0004\"\u0003B?\u0001\u0001\u0007I\u0011\u0002B@\u0011%\u0011\t\t\u0001a\u0001\n\u0013\u0011\u0019\t\u0003\u0005\u0003\n\u0002\u0001\u000b\u0015BA:\u0011\u001d\u0011Y\t\u0001C!\u0005\u001bCqAa%\u0001\t\u0003\u0011)\nC\u0004\u0003\u001a\u0002!\tBa'\t\u000f\t}\u0005\u0001\"\u0001\u0003\u001c\"A!\u0011\u0015\u0001\u0005\u0002U\u0012\u0019kB\u0004\u00034FB\tA!.\u0007\rA\n\u0004\u0012\u0001B\\\u0011\u0019\u0001X\u0006\"\u0001\u0003:\"9!1X\u0017\u0005\u0002\tu&a\u0004%E\rNkU\r^1eCR\fGj\\4\u000b\u0005I\u001a\u0014!C:ue\u0016\fW.\u001b8h\u0015\t!T'A\u0005fq\u0016\u001cW\u000f^5p]*\u0011agN\u0001\u0004gFd'B\u0001\u001d:\u0003\u0015\u0019\b/\u0019:l\u0015\tQ4(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002y\u0005\u0019qN]4\u0004\u0001U\u0011q\bT\n\u0005\u0001\u00013%\u000b\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%I\u0001\u0004B]f\u0014VM\u001a\t\u0004\u000f\"SU\"A\u0019\n\u0005%\u000b$aC'fi\u0006$\u0017\r^1M_\u001e\u0004\"a\u0013'\r\u0001\u0011)Q\n\u0001b\u0001\u001d\n\tA+\u0005\u0002P\u0001B\u0011\u0011\tU\u0005\u0003#\n\u0013qAT8uQ&tw\r\u0005\u0002T-6\tAK\u0003\u0002Vo\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002X)\n9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001.\\\u001b\u0005)\u0014B\u0001/6\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005}3gB\u00011e!\t\t')D\u0001c\u0015\t\u0019W(\u0001\u0004=e>|GOP\u0005\u0003K\n\u000ba\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011QMQ\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA6o\u00156\tAN\u0003\u0002n\u0005\u00069!/\u001a4mK\u000e$\u0018BA8m\u0005!\u0019E.Y:t)\u0006<\u0017A\u0002\u001fj]&$h\bF\u0002skZ$\"a\u001d;\u0011\u0007\u001d\u0003!\nC\u0003j\t\u0001\u000f!\u000eC\u0003Y\t\u0001\u0007\u0011\fC\u0003^\t\u0001\u0007a,A\u0004g_Jl\u0017\r^:\u0016\u0003e\u0014BA\u001f!\u0002\u0004\u0019!1\u0010\u0001\u0001z\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0013\t9X0\u0003\u0002\u007f\u007f\ni1+\u001a:jC2L'0\u0019;j_:T1!!\u0001<\u0003\u0019Q7o\u001c85gB!\u0011QAA\u0004\u001b\u0005y\u0018bAA\u0005\u007f\n9ai\u001c:nCR\u001c\b\"CA\u0007u\n\u0007I\u0011AA\b\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0003\u0003#\u0001B!!\u0002\u0002\u0014%\u0019\u0011QC@\u0003\u0015\u0011\u000bG/\u001a$pe6\fG\u000fC\u0005\u0002\u001ai\u0014\r\u0011\"\u0011\u0002\u001c\u0005IA/\u001f9f\u0011&tGo]\u000b\u0003\u0003;\u0001B!!\u0002\u0002 %\u0019\u0011\u0011E@\u0003\u0013QK\b/\u001a%j]R\u001c\u0018\u0001\u00034pe6\fGo\u001d\u0011\u0002\u00115\fg.\u001b4fgR,\"!!\u000b\u0011\t-\fYCS\u0005\u0004\u0003[a'\u0001C'b]&4Wm\u001d;\u0002\u00135\fg.\u001b4fgR\u0004\u0013\u0001D7fi\u0006$\u0017\r^1QCRDWCAA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t!AZ:\u000b\u0007\u0005}\u0012(\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u0007\nID\u0001\u0003QCRD\u0017!D7fi\u0006$\u0017\r^1QCRD\u0007%A\u0006gS2,W*\u00198bO\u0016\u0014XCAA&!\r9\u0015QJ\u0005\u0004\u0003\u001f\n$!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0001\rM&dW-T1oC\u001e,'\u000fI\u0001\u0015[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3F]\u0006\u0014G.\u001a3\u0016\u0005\u0005]\u0003cA!\u0002Z%\u0019\u00111\f\"\u0003\u000f\t{w\u000e\\3b]\u0006)R.\u001a;bI\u0006$\u0018mQ1dQ\u0016,e.\u00192mK\u0012\u0004\u0013A\u00032bi\u000eD7)Y2iKV\u0011\u00111\r\t\b\u0003K\ny'a\u001dK\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014\u0001B;uS2T!!!\u001c\u0002\t)\fg/Y\u0005\u0005\u0003c\n9GA\u0002NCB\u00042!QA;\u0013\r\t9H\u0011\u0002\u0005\u0019>tw-A\u0006cCR\u001c\u0007nQ1dQ\u0016\u0004\u0013\u0001\u00052bi\u000eDg)\u001b7fg\u001aKG\u000e^3s+\t\tyH\u0005\u0004\u0002\u0002\u0006\u0015\u0015\u0011\u0013\u0004\u0006wJ\u0001\u0011qP\u0001\u0012E\u0006$8\r\u001b$jY\u0016\u001ch)\u001b7uKJ\u0004\u0003\u0003BAD\u0003\u001bk!!!#\u000b\t\u0005-\u00151N\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u0010\u0006%%AB(cU\u0016\u001cG\u000f\u0005\u0003\u00028\u0005M\u0015\u0002BAK\u0003s\u0011!\u0002U1uQ\u001aKG\u000e^3s\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR!\u0011QGAN\u0011\u001d\tij\u0005a\u0001\u0003g\nqAY1uG\"LE-A\u0007qCRDGk\u001c\"bi\u000eD\u0017\n\u001a\u000b\u0005\u0003g\n\u0019\u000b\u0003\u0004^)\u0001\u0007\u0011QG\u0001\fSN\u0014\u0015\r^2i\r&dW\r\u0006\u0003\u0002X\u0005%\u0006BB/\u0016\u0001\u0004\t)$A\u0005tKJL\u0017\r\\5{KR1\u0011qVA[\u0003s\u00032!QAY\u0013\r\t\u0019L\u0011\u0002\u0005+:LG\u000f\u0003\u0004\u00028Z\u0001\rAS\u0001\t[\u0016$\u0018\rZ1uC\"9\u00111\u0018\fA\u0002\u0005u\u0016aA8viB!\u0011qXAc\u001b\t\t\tM\u0003\u0003\u0002D\u0006-\u0014AA5p\u0013\u0011\t9-!1\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u0015\u00065\u0007bBAh/\u0001\u0007\u0011\u0011[\u0001\u0003S:\u0004B!a0\u0002T&!\u0011Q[Aa\u0005-Ie\u000e];u'R\u0014X-Y7\u0002\u0007\u0005$G\r\u0006\u0004\u0002X\u0005m\u0017Q\u001c\u0005\b\u0003;C\u0002\u0019AA:\u0011\u0019\t9\f\u0007a\u0001\u0015\u0006\u0019q-\u001a;\u0015\t\u0005\r\u0018\u0011\u001e\t\u0005\u0003\u0006\u0015(*C\u0002\u0002h\n\u0013aa\u00149uS>t\u0007bBAO3\u0001\u0007\u00111O\u0001\u0018O\u0016$\bK]3w\u0005\u0006$8\r\u001b$s_6\u001cFo\u001c:bO\u0016$B!a<\u0002rB)\u0011)!:\u0002t!9\u0011Q\u0014\u000eA\u0002\u0005M\u0014AF1qa2LhI\u001c+p\u0005\u0006$8\r\u001b\"z'R\u0014X-Y7\u0016\t\u0005]\u0018Q \u000b\u0007\u0003s\u0014\u0019B!\u0006\u0015\t\u0005m(\u0011\u0002\t\u0004\u0017\u0006uHaBA\u00007\t\u0007!\u0011\u0001\u0002\u0004%\u0016#\u0016cA(\u0003\u0004A\u0019\u0011I!\u0002\n\u0007\t\u001d!IA\u0002B]fDqAa\u0003\u001c\u0001\u0004\u0011i!\u0001\u0002g]B9\u0011Ia\u0004\u0002R\u0006m\u0018b\u0001B\t\u0005\nIa)\u001e8di&|g.\r\u0005\b\u0003;[\u0002\u0019AA:\u0011%\u00119b\u0007I\u0001\u0002\u0004\t9&A\ttW&\u0004X\t_5ti&twm\u00115fG.\f\u0001%\u00199qYf4e\u000eV8CCR\u001c\u0007NQ=TiJ,\u0017-\u001c\u0013eK\u001a\fW\u000f\u001c;%eU!!Q\u0004B\u001a+\t\u0011yB\u000b\u0003\u0002X\t\u00052F\u0001B\u0012!\u0011\u0011)Ca\f\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5\")\u0001\u0006b]:|G/\u0019;j_:LAA!\r\u0003(\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005}HD1\u0001\u0003\u0002\u0005)qO]5uKR1\u0011q\u0016B\u001d\u0005{AqAa\u000f\u001e\u0001\u0004\t)$A\tcCR\u001c\u0007.T3uC\u0012\fG/\u0019$jY\u0016DqAa\u0003\u001e\u0001\u0004\u0011y\u0004E\u0004B\u0005\u001f\ti,a,\u0002'\u0005$GMT3x\u0005\u0006$8\r\u001b\"z'R\u0014X-Y7\u0015\t\t\u0015#\u0011\n\u000b\u0005\u0003/\u00129\u0005C\u0004\u0003\fy\u0001\rAa\u0010\t\u000f\u0005ue\u00041\u0001\u0002t\u0005\u0001r-\u001a;Fq&\u001cH/\u001b8h\u0005\u0006$8\r\u001b\u000b\u0004\u0015\n=\u0003bBAO?\u0001\u0007\u00111\u000f\u000b\u0007\u0005'\u0012yFa\u0019\u0011\u000b\u0005\u0013)F!\u0017\n\u0007\t]#IA\u0003BeJ\f\u0017\u0010\u0005\u0004B\u00057\n\u0019HS\u0005\u0004\u0005;\u0012%A\u0002+va2,'\u0007C\u0004\u0003b\u0001\u0002\r!a<\u0002\u000fM$\u0018M\u001d;JI\"9!Q\r\u0011A\u0002\u0005=\u0018!B3oI&#\u0017\u0001E4fi2\u000bG/Z:u\u0005\u0006$8\r[%e)\t\ty/A\u0005hKRd\u0015\r^3tiR\u0011!q\u000e\t\u0006\u0003\u0006\u0015(\u0011L\u0001\u0015O\u0016$xJ\u001d3fe\u0016$')\u0019;dQ\u001aKG.Z:\u0015\u0005\tU\u0004#B!\u0003V\t]\u0004\u0003BA\u001c\u0005sJAAa\u001f\u0002:\tQa)\u001b7f'R\fG/^:\u0002#1\f7\u000f\u001e)ve\u001e,GMQ1uG\"LE-\u0006\u0002\u0002t\u0005)B.Y:u!V\u0014x-\u001a3CCR\u001c\u0007.\u00133`I\u0015\fH\u0003BAX\u0005\u000bC\u0011Ba\"&\u0003\u0003\u0005\r!a\u001d\u0002\u0007a$\u0013'\u0001\nmCN$\b+\u001e:hK\u0012\u0014\u0015\r^2i\u0013\u0012\u0004\u0013!\u00029ve\u001e,G\u0003BAX\u0005\u001fCqA!%(\u0001\u0004\t\u0019(\u0001\tuQJ,7\u000f[8mI\n\u000bGo\u00195JI\u0006Q\u0001/\u001e:hK\u00063G/\u001a:\u0015\t\u0005=&q\u0013\u0005\b\u0005#C\u0003\u0019AA:\u0003-a\u0017n\u001d;CCR\u001c\u0007.Z:\u0016\u0005\tu\u0005#B!\u0003V\u0005M\u0014!\u00057jgR\u0014\u0015\r^2iKN|e\u000eR5tW\u0006ya/\u00197jI\u0006$XMV3sg&|g\u000e\u0006\u0004\u0003&\n-&q\u0016\t\u0004\u0003\n\u001d\u0016b\u0001BU\u0005\n\u0019\u0011J\u001c;\t\r\t56\u00061\u0001_\u0003\u0011!X\r\u001f;\t\u000f\tE6\u00061\u0001\u0003&\u0006\u0019R.\u0019=TkB\u0004xN\u001d;fIZ+'o]5p]\u0006y\u0001\n\u0012$T\u001b\u0016$\u0018\rZ1uC2{w\r\u0005\u0002H[M\u0011Q\u0006\u0011\u000b\u0003\u0005k\u000baB^3sS\u001aL()\u0019;dQ&#7\u000f\u0006\u0005\u00020\n}&Q\u001bBl\u0011\u001d\u0011\tm\fa\u0001\u0005\u0007\f\u0001BY1uG\"LEm\u001d\t\u0007\u0005\u000b\u0014y-a\u001d\u000f\t\t\u001d'1\u001a\b\u0004C\n%\u0017\"A\"\n\u0007\t5')A\u0004qC\u000e\\\u0017mZ3\n\t\tE'1\u001b\u0002\u0004'\u0016\f(b\u0001Bg\u0005\"9!\u0011M\u0018A\u0002\u0005=\bb\u0002B3_\u0001\u0007\u0011q\u001e")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final boolean metadataCacheEnabled;
    private final Map<Object, T> batchCache;
    private final PathFilter batchFilesFilter;
    private long lastPurgedBatchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> batchIds, Option<Object> startId, Option<Object> endId) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(batchIds, startId, endId);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public boolean metadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public Map<Object, T> batchCache() {
        return this.batchCache;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), Long.toString(batchId));
    }

    public long pathToBatchId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot written to a metadata log");
        boolean res = this.addNewBatchByStream(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        });
        Object object = this.metadataCacheEnabled() && res ? this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata) : BoxedUnit.UNIT;
        return res;
    }

    @Override
    public Option<T> get(long batchId) {
        None$ none$;
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
            Predef$.MODULE$.assert(metadata != null);
            return new Some(metadata);
        }
        try {
            none$ = (Option)this.applyFnToBatchByStream(batchId, this.applyFnToBatchByStream$default$2(), (Function1 & Serializable)input -> new Some(this.deserialize((InputStream)input)));
        }
        catch (FileNotFoundException fne) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> fne.getMessage());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> getPrevBatchFromStorage(long batchId) {
        Option option;
        Object object = new Object();
        try {
            long[] batchFiles = this.listBatchesOnDisk();
            ObjectRef prev = ObjectRef.create((Object)None$.MODULE$);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchFiles), (Ordering)Ordering.Long$.MODULE$)), (Function1)(JFunction1.mcVJ.sp & Serializable)file -> {
                if (file >= batchId) {
                    throw new NonLocalReturnControl(object, (Object)((Option)prev$1.elem));
                }
                prev$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file));
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public <RET> RET applyFnToBatchByStream(long batchId, boolean skipExistingCheck, Function1<InputStream, RET> fn) {
        Object object;
        block6: {
            Path batchMetadataFile = this.batchIdToPath(batchId);
            if (skipExistingCheck || this.fileManager().exists(batchMetadataFile)) {
                FSDataInputStream input = this.fileManager().open(batchMetadataFile);
                try {
                    try {
                        object = fn.apply((Object)input);
                        break block6;
                    }
                    catch (IllegalStateException ise) {
                        throw new IllegalStateException(new StringBuilder(26).append("Failed to read log file ").append(batchMetadataFile).append(". ").append(ise.getMessage()).toString(), ise);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            throw QueryExecutionErrors$.MODULE$.batchMetadataFileNotFoundError(batchMetadataFile);
        }
        return (RET)object;
    }

    public <RET> boolean applyFnToBatchByStream$default$2() {
        return false;
    }

    public void write(Path batchMetadataFile, Function1<OutputStream, BoxedUnit> fn) {
        CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(batchMetadataFile, false);
        try {
            fn.apply((Object)output);
            output.close();
        }
        catch (FileAlreadyExistsException e) {
            throw QueryExecutionErrors$.MODULE$.multiStreamingQueriesUsingPathConcurrentlyError(this.path, e);
        }
        finally {
            output.cancel();
        }
    }

    public boolean addNewBatchByStream(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        boolean bl;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.metadataCacheEnabled() && this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId)) || this.fileManager().exists(batchMetadataFile)) {
            bl = false;
        } else {
            this.write(batchMetadataFile, fn);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private T getExistingBatch(long batchId) {
        void var3_2;
        T metadata = this.batchCache().get(BoxesRunTime.boxToLong((long)batchId));
        return (T)(metadata == null ? this.applyFnToBatchByStream(batchId, true, (Function1 & Serializable)input -> this.deserialize((InputStream)input)) : var3_2);
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        long[] batchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get())))), (Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)batchIds), startId, endId);
        return (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$get$4(this, BoxesRunTime.unboxToLong((Object)batchId)), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Option<Object> getLatestBatchId() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        return ArrayOps$.MODULE$.lastOption$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Ordering)Ordering.Long$.MODULE$))).map((Function1 & Serializable)batchId -> HDFSMetadataLog.$anonfun$getLatest$1(this, BoxesRunTime.unboxToLong((Object)batchId)));
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$)));
    }

    private long lastPurgedBatchId() {
        return this.lastPurgedBatchId;
    }

    private void lastPurgedBatchId_$eq(long x$1) {
        this.lastPurgedBatchId = x$1;
    }

    @Override
    public void purge(long thresholdBatchId) {
        NumericRange.Exclusive possibleTargetBatchIds = new RichLong(Predef$.MODULE$.longWrapper(this.lastPurgedBatchId() + 1L)).until((Object)BoxesRunTime.boxToLong((long)thresholdBatchId));
        if (possibleTargetBatchIds.length() <= 3) {
            possibleTargetBatchIds.foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
            });
        } else {
            ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(this.listBatches()), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
                Path path = this.batchIdToPath(batchId);
                this.fileManager().delete(path);
                Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
                this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
            });
        }
        this.lastPurgedBatchId_$eq(thresholdBatchId - 1L);
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long());
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.longArrayOps(batchIds), (Function1)(JFunction1.mcZJ.sp & Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            Object object = this.metadataCacheEnabled() ? this.batchCache().remove(BoxesRunTime.boxToLong((long)batchId)) : BoxedUnit.UNIT;
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public long[] listBatches() {
        long[] lArray;
        Map<Object, T> map = this.batchCache();
        synchronized (map) {
            lArray = (long[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.batchCache().keySet()).asScala()).toArray((ClassTag)ClassTag$.MODULE$.Long());
        }
        long[] batchIds = (long[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)f.isFile()))), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Object)lArray, (ClassTag)ClassTag$.MODULE$.Long());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("BatchIds found from listing: ").append(Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps(batchIds), (Ordering)Ordering.Long$.MODULE$)).mkString(", ")).toString());
        return ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(batchIds)) ? (long[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Long()) : (long[])new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(batchIds).min((Ordering)Ordering.Long$.MODULE$)))).to(Predef$.MODULE$.wrapLongArray(batchIds).max((Ordering)Ordering.Long$.MODULE$)).toArray((ClassTag)ClassTag$.MODULE$.Long());
    }

    public long[] listBatchesOnDisk() {
        return (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())), (Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Ordering)Ordering.Long$.MODULE$);
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        return MetadataVersionUtil$.MODULE$.validateVersion(text, maxSupportedVersion);
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$4(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLatest$1(HDFSMetadataLog $this, long batchId) {
        $this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Getting latest batch ").append(batchId).toString());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.getExistingBatch(batchId));
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.path = path;
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.metadataCacheEnabled = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_METADATA_CACHE_ENABLED()));
        this.batchCache = Collections.synchronizedMap(new LinkedHashMap<Object, T>(null){

            public boolean removeEldestEntry(Map.Entry<Object, T> e) {
                return this.size() > 2;
            }
        });
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.lastPurgedBatchId = -1L;
    }
}

