/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.mesos;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.mesos.Protos;
import org.apache.mesos.protobuf.ByteString;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.deploy.mesos.config.package;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.cluster.mesos.MesosProtoUtils$;
import org.slf4j.Logger;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MesosSchedulerBackendUtil$
implements Logging {
    public static final MesosSchedulerBackendUtil$ MODULE$ = new MesosSchedulerBackendUtil$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<Protos.Volume> parseVolumesSpec(Seq<String> volumes) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)volumes.map((Function1 & Serializable)x$1 -> x$1.split(":"))).flatMap((Function1 & Serializable)spec -> {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Protos.Volume.Builder vol = Protos.Volume.newBuilder().setMode(Protos.Volume.Mode.RW);
            String[] stringArray = spec;
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object6 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object6)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object6), 1) == 0) {
                String container_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object6), 0);
                return new Some((Object)vol.setContainerPath(container_path));
            }
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object5 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5), 2) == 0) {
                String container_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5), 0);
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object5), 1);
                if ("rw".equals(string)) {
                    return new Some((Object)vol.setContainerPath(container_path));
                }
            }
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object4 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4), 2) == 0) {
                String container_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4), 0);
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object4), 1);
                if ("ro".equals(string)) {
                    return new Some((Object)vol.setContainerPath(container_path).setMode(Protos.Volume.Mode.RO));
                }
            }
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object3 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 2) == 0) {
                String host_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 0);
                String container_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object3), 1);
                return new Some((Object)vol.setContainerPath(container_path).setHostPath(host_path));
            }
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 3) == 0) {
                String host_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                String container_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2);
                if ("rw".equals(string)) {
                    return new Some((Object)vol.setContainerPath(container_path).setHostPath(host_path));
                }
            }
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) == 0) {
                String host_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String container_path = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                if ("ro".equals(string)) {
                    return new Some((Object)vol.setContainerPath(container_path).setHostPath(host_path).setMode(Protos.Volume.Mode.RO));
                }
            }
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append(new StringBuilder(32).append("Unable to parse volume specs: ").append(volumes).append(". ").toString()).append("Expected form: \"[host-dir:]container-dir[:rw|:ro](, ...)\"").toString());
            return None$.MODULE$;
        })).map((Function1 & Serializable)x$2 -> x$2.build())).toList();
    }

    public List<Protos.ContainerInfo.DockerInfo.PortMapping> parsePortMappingsSpec(Seq<String> portmaps) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)portmaps.map((Function1 & Serializable)x$3 -> x$3.split(":"))).flatMap((Function1 & Serializable)spec -> {
            Object object;
            None$ none$;
            Object object2;
            Protos.ContainerInfo.DockerInfo.PortMapping.Builder portmap = Protos.ContainerInfo.DockerInfo.PortMapping.newBuilder().setProtocol("tcp");
            String[] stringArray = spec;
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                String host_port = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                String container_port = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                none$ = new Some((Object)portmap.setHostPort(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(host_port))).setContainerPort(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(container_port))));
            } else if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) == 0) {
                String host_port = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String container_port = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                String protocol = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                none$ = new Some((Object)portmap.setHostPort(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(host_port))).setContainerPort(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(container_port))).setProtocol(protocol));
            } else {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append(new StringBuilder(38).append("Unable to parse port mapping specs: ").append(portmaps).append(". ").toString()).append("Expected form: \"host_port:container_port[:udp|:tcp](, ...)\"").toString());
                none$ = None$.MODULE$;
            }
            return none$;
        })).map((Function1 & Serializable)x$4 -> x$4.build())).toList();
    }

    private List<Protos.Parameter> parseParamsSpec(Seq<String> params) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)params.map((Function1 & Serializable)x$5 -> x$5.split("=", 2))).flatMap((Function1 & Serializable)spec -> {
            None$ none$;
            Object object;
            Protos.Parameter.Builder param = Protos.Parameter.newBuilder();
            String[] stringArray = spec;
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String key = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String value = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                none$ = new Some((Object)param.setKey(key).setValue(value));
            } else {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append(new StringBuilder(40).append("Unable to parse arbitrary parameters: ").append(params).append(". ").toString()).append("Expected form: \"key=value(, ...)\"").toString());
                none$ = None$.MODULE$;
            }
            return none$;
        })).map((Function1 & Serializable)x$6 -> x$6.build())).toList();
    }

    /*
     * Unable to fully structure code
     */
    public Protos.ContainerInfo.Builder buildContainerInfo(SparkConf conf) {
        if (!conf.contains(org.apache.spark.deploy.mesos.config.package$.MODULE$.EXECUTOR_DOCKER_IMAGE())) ** GOTO lbl-1000
        v0 = conf.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.CONTAINERIZER());
        var3_2 = "docker";
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            v1 = Protos.ContainerInfo.Type.DOCKER;
        } else lbl-1000:
        // 2 sources

        {
            v1 = Protos.ContainerInfo.Type.MESOS;
        }
        containerType = v1;
        containerInfo = Protos.ContainerInfo.newBuilder().setType(containerType);
        ((Option)conf.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.EXECUTOR_DOCKER_IMAGE())).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildContainerInfo$1$adapted(org.apache.spark.SparkConf org.apache.mesos.Protos$ContainerInfo$Type org.apache.mesos.Protos$ContainerInfo$Builder java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((SparkConf)conf, (Protos.ContainerInfo.Type)containerType, (Protos.ContainerInfo.Builder)containerInfo));
        ((Option)conf.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.NETWORK_NAME())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildContainerInfo$9(org.apache.spark.SparkConf org.apache.mesos.Protos$ContainerInfo$Builder java.lang.String ), (Ljava/lang/String;)Lorg/apache/mesos/Protos$ContainerInfo$Builder;)((SparkConf)conf, (Protos.ContainerInfo.Builder)containerInfo));
        return containerInfo;
    }

    private Seq<Protos.Secret> getSecrets(SparkConf conf, package.MesosSecretConfig secretConfig) {
        Seq referenceSecrets = (Seq)((IterableOps)((Option)conf.get(secretConfig.SECRET_NAMES())).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil())).map((Function1 & Serializable)s -> MesosSchedulerBackendUtil$.createReferenceSecret$1(s));
        Seq valueSecrets = (Seq)((IterableOps)((Option)conf.get(secretConfig.SECRET_VALUES())).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil())).map((Function1 & Serializable)s -> MesosSchedulerBackendUtil$.createValueSecret$1(s));
        if (valueSecrets.nonEmpty() && referenceSecrets.nonEmpty()) {
            throw new SparkException("Cannot specify both value-type and reference-type secrets.");
        }
        return referenceSecrets.nonEmpty() ? referenceSecrets : valueSecrets;
    }

    private boolean illegalSecretInput(Seq<String> dest, Seq<Protos.Secret> secrets) {
        return dest.nonEmpty() && dest.length() != secrets.length();
    }

    public List<Protos.Volume> getSecretVolume(SparkConf conf, package.MesosSecretConfig secretConfig) {
        Seq<Protos.Secret> secrets = this.getSecrets(conf, secretConfig);
        Seq secretPaths = (Seq)((Option)conf.get(secretConfig.SECRET_FILENAMES())).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
        if (this.illegalSecretInput((Seq<String>)secretPaths, secrets)) {
            throw new SparkException(new StringBuilder(0).append("Need to give equal numbers of secrets and file paths for file-based ").append(new StringBuilder(42).append("reference secrets got secrets ").append(secrets).append(", and paths ").append(secretPaths).toString()).toString());
        }
        return ((IterableOnceOps)((IterableOps)secrets.zip((IterableOnce)secretPaths)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Protos.Secret s = (Protos.Secret)tuple2._1();
            String p = (String)tuple2._2();
            Protos.Volume.Source.Builder source = Protos.Volume.Source.newBuilder().setType(Protos.Volume.Source.Type.SECRET).setSecret(s);
            Protos.Volume volume = Protos.Volume.newBuilder().setContainerPath(p).setSource(source).setMode(Protos.Volume.Mode.RO).build();
            return volume;
        })).toList();
    }

    public List<Protos.Environment.Variable> getSecretEnvVar(SparkConf conf, package.MesosSecretConfig secretConfig) {
        Seq<Protos.Secret> secrets = this.getSecrets(conf, secretConfig);
        Seq secretEnvKeys = (Seq)((Option)conf.get(secretConfig.SECRET_ENVKEYS())).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
        if (this.illegalSecretInput((Seq<String>)secretEnvKeys, secrets)) {
            throw new SparkException(new StringBuilder(0).append("Need to give equal numbers of secrets and environment keys ").append(new StringBuilder(54).append("for environment-based reference secrets got secrets ").append(secrets).append(", ").toString()).append(new StringBuilder(9).append("and keys ").append(secretEnvKeys).toString()).toString());
        }
        return ((IterableOnceOps)((IterableOps)secrets.zip((IterableOnce)secretEnvKeys)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Protos.Secret s = (Protos.Secret)tuple2._1();
            String k = (String)tuple2._2();
            Protos.Environment.Variable variable = Protos.Environment.Variable.newBuilder().setName(k).setType(Protos.Environment.Variable.Type.SECRET).setSecret(s).build();
            return variable;
        })).toList();
    }

    private Protos.ContainerInfo.DockerInfo dockerInfo(String image, boolean forcePullImage, List<Protos.ContainerInfo.DockerInfo.PortMapping> portMaps, List<Protos.Parameter> params, Option<String> networkName) {
        Protos.ContainerInfo.DockerInfo.Builder dockerBuilder = Protos.ContainerInfo.DockerInfo.newBuilder().setImage(image).setForcePullImage(forcePullImage);
        portMaps.foreach((Function1 & Serializable)x$9 -> dockerBuilder.addPortMappings(x$9));
        params.foreach((Function1 & Serializable)x$10 -> dockerBuilder.addParameters(x$10));
        networkName.foreach((Function1 & Serializable)net -> {
            Protos.Parameter network = Protos.Parameter.newBuilder().setKey("net").setValue(net).build();
            dockerBuilder.setNetwork(Protos.ContainerInfo.DockerInfo.Network.USER);
            return dockerBuilder.addParameters(network);
        });
        return dockerBuilder.build();
    }

    private Protos.ContainerInfo.MesosInfo mesosInfo(String image, boolean forcePullImage) {
        Protos.Image.Builder imageProto = Protos.Image.newBuilder().setType(Protos.Image.Type.DOCKER).setDocker(Protos.Image.Docker.newBuilder().setName(image)).setCached(!forcePullImage);
        return Protos.ContainerInfo.MesosInfo.newBuilder().setImage(imageProto).build();
    }

    public Protos.TaskState taskStateToMesos(Enumeration.Value state) {
        Protos.TaskState taskState;
        Enumeration.Value value = state;
        Enumeration.Value value2 = TaskState$.MODULE$.LAUNCHING();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            taskState = Protos.TaskState.TASK_STARTING;
        } else {
            Enumeration.Value value4 = TaskState$.MODULE$.RUNNING();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                taskState = Protos.TaskState.TASK_RUNNING;
            } else {
                Enumeration.Value value6 = TaskState$.MODULE$.FINISHED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    taskState = Protos.TaskState.TASK_FINISHED;
                } else {
                    Enumeration.Value value8 = TaskState$.MODULE$.FAILED();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        taskState = Protos.TaskState.TASK_FAILED;
                    } else {
                        Enumeration.Value value10 = TaskState$.MODULE$.KILLED();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            taskState = Protos.TaskState.TASK_KILLED;
                        } else {
                            Enumeration.Value value12 = TaskState$.MODULE$.LOST();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                taskState = Protos.TaskState.TASK_LOST;
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                }
            }
        }
        return taskState;
    }

    public static final /* synthetic */ void $anonfun$buildContainerInfo$1(SparkConf conf$1, Protos.ContainerInfo.Type containerType$1, Protos.ContainerInfo.Builder containerInfo$1, String image) {
        boolean forcePullImage = ((Option)conf$1.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.EXECUTOR_DOCKER_FORCE_PULL_IMAGE())).contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
        List portMaps = (List)((Option)conf$1.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.EXECUTOR_DOCKER_PORT_MAPS())).map((Function1 & Serializable)portmaps -> MODULE$.parsePortMappingsSpec((Seq<String>)portmaps)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
        List params2 = (List)((Option)conf$1.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.EXECUTOR_DOCKER_PARAMETERS())).map((Function1 & Serializable)params -> MODULE$.parseParamsSpec((Seq<String>)params)).getOrElse((Function0 & Serializable)() -> package$.MODULE$.List().empty());
        Protos.ContainerInfo.Type type = containerType$1;
        Protos.ContainerInfo.Type type2 = Protos.ContainerInfo.Type.DOCKER;
        Protos.ContainerInfo.Builder builder = !(type != null ? !type.equals(type2) : type2 != null) ? containerInfo$1.setDocker(MODULE$.dockerInfo(image, forcePullImage, (List<Protos.ContainerInfo.DockerInfo.PortMapping>)portMaps, (List<Protos.Parameter>)params2, (Option<String>)((Option)conf$1.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.NETWORK_NAME())))) : containerInfo$1.setMesos(MODULE$.mesosInfo(image, forcePullImage));
        Option volumes2 = ((Option)conf$1.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.EXECUTOR_DOCKER_VOLUMES())).map((Function1 & Serializable)volumes -> MODULE$.parseVolumesSpec((Seq<String>)volumes));
        volumes2.foreach((Function1 & Serializable)x$7 -> {
            x$7.foreach((Function1 & Serializable)x$8 -> containerInfo$1.addVolumes(x$8));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Protos.ContainerInfo.Builder $anonfun$buildContainerInfo$9(SparkConf conf$1, Protos.ContainerInfo.Builder containerInfo$1, String name) {
        Protos.Labels.Builder networkLabels = MesosProtoUtils$.MODULE$.mesosLabels((String)((Option)conf$1.get(org.apache.spark.deploy.mesos.config.package$.MODULE$.NETWORK_LABELS())).getOrElse((Function0 & Serializable)() -> ""));
        Protos.NetworkInfo info = Protos.NetworkInfo.newBuilder().setName(name).setLabels(networkLabels).build();
        return containerInfo$1.addNetworkInfos(info);
    }

    private static final Protos.Secret createValueSecret$1(String data) {
        return Protos.Secret.newBuilder().setType(Protos.Secret.Type.VALUE).setValue(Protos.Secret.Value.newBuilder().setData(ByteString.copyFrom((byte[])data.getBytes()))).build();
    }

    private static final Protos.Secret createReferenceSecret$1(String name) {
        return Protos.Secret.newBuilder().setReference(Protos.Secret.Reference.newBuilder().setName(name)).setType(Protos.Secret.Type.REFERENCE).build();
    }

    private MesosSchedulerBackendUtil$() {
    }

    public static final /* synthetic */ Object $anonfun$buildContainerInfo$1$adapted(SparkConf conf$1, Protos.ContainerInfo.Type containerType$1, Protos.ContainerInfo.Builder containerInfo$1, String image) {
        MesosSchedulerBackendUtil$.$anonfun$buildContainerInfo$1(conf$1, containerType$1, containerInfo$1, image);
        return BoxedUnit.UNIT;
    }
}

