/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayRepeat$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(element, count) - Returns the array containing element count times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       [\"123\",\"123\"]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tMb\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u00151\b\u0001\"\u0011x\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u00111\f\u0001\u0005R\u0005u\u0003\"CA4\u0001\u0005\u0005I\u0011AA5\u0011%\ty\u0007AI\u0001\n\u0003\t\t\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002r!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u00037\u0003\u0011\u0011!C\u0001\u0003;C\u0011\"!*\u0001\u0003\u0003%\t!a*\t\u0013\u00055\u0006!!A\u0005B\u0005=\u0006\"CA_\u0001\u0005\u0005I\u0011AA`\u0011%\t\u0019\rAA\u0001\n\u0003\n)\rC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\u001eI\u0011q\u001e\u0012\u0002\u0002#\u0005\u0011\u0011\u001f\u0004\tC\t\n\t\u0011#\u0001\u0002t\"1\u0011k\u0007C\u0001\u0005\u0017A\u0011B!\u0004\u001c\u0003\u0003%)Ea\u0004\t\u0013\tE1$!A\u0005\u0002\nM\u0001\"\u0003B\r7\u0005\u0005I\u0011\u0011B\u000e\u0011%\u0011IcGA\u0001\n\u0013\u0011YCA\u0006BeJ\f\u0017PU3qK\u0006$(BA\u0012%\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00152\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001DgN\u001f\u0011\u0005E\u0012T\"\u0001\u0012\n\u0005M\u0012#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tT'\u0003\u00027E\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u000fA\u0013x\u000eZ;diB\u0011aH\u0012\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0014BA#:\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0015K\u0014\u0001\u00027fMR,\u0012a\u0013\t\u0003c1K!!\u0014\u0012\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M#V\u000b\u0005\u00022\u0001!)\u0011*\u0002a\u0001\u0017\")q*\u0002a\u0001\u0017\u0006AA-\u0019;b)f\u0004X-F\u0001Y!\tIF,D\u0001[\u0015\tYf%A\u0003usB,7/\u0003\u0002^5\nI\u0011I\u001d:bsRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00011\u0011\u0007y\n7-\u0003\u0002c\u0011\n\u00191+Z9\u0011\u0005e#\u0017BA3[\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005A\u0007C\u0001\u001dj\u0013\tQ\u0017HA\u0004C_>dW-\u00198\u0002\t\u00154\u0018\r\u001c\u000b\u0003[B\u0004\"\u0001\u000f8\n\u0005=L$aA!os\"9\u0011/\u0003I\u0001\u0002\u0004\u0011\u0018!B5oaV$\bCA:u\u001b\u0005!\u0013BA;%\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001y!\tIXP\u0004\u0002{wB\u0011\u0001)O\u0005\u0003yf\na\u0001\u0015:fI\u00164\u0017B\u0001@\u0000\u0005\u0019\u0019FO]5oO*\u0011A0O\u0001\nI><UM\\\"pI\u0016$b!!\u0002\u0002\u0012\u0005m\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-!%A\u0004d_\u0012,w-\u001a8\n\t\u0005=\u0011\u0011\u0002\u0002\t\u000bb\u0004(oQ8eK\"9\u00111C\u0006A\u0002\u0005U\u0011aA2uqB!\u0011qAA\f\u0013\u0011\tI\"!\u0003\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011QD\u0006A\u0002\u0005\u0015\u0011AA3w\u0003YqW\u000f\u001c7FY\u0016lWM\u001c;t!J|G/Z2uS>tGc\u0002=\u0002$\u0005\u0015\u0012\u0011\u0006\u0005\b\u0003;a\u0001\u0019AA\u0003\u0011\u0019\t9\u0003\u0004a\u0001q\u0006Y!/[4ii&\u001bh*\u001e7m\u0011\u0019\tY\u0003\u0004a\u0001q\u0006I1m\u001c:f\u0019><\u0017nY\u0001\u001bO\u0016t7i\u001c3f\r>\u0014h*^7cKJ|e-\u00127f[\u0016tGo\u001d\u000b\u0007\u0003c\t9$!\u000f\u0011\u000ba\n\u0019\u0004\u001f=\n\u0007\u0005U\u0012H\u0001\u0004UkBdWM\r\u0005\b\u0003'i\u0001\u0019AA\u000b\u0011\u0019\tY$\u0004a\u0001q\u0006)1m\\;oi\u0006\tr-\u001a8D_\u0012,gi\u001c:FY\u0016lWM\u001c;\u0015\u001ba\f\t%a\u0011\u0002N\u0005E\u00131KA,\u0011\u001d\t\u0019B\u0004a\u0001\u0003+Aq!!\u0012\u000f\u0001\u0004\t9%A\u0006fY\u0016lWM\u001c;UsB,\u0007cA-\u0002J%\u0019\u00111\n.\u0003\u0011\u0011\u000bG/\u0019+za\u0016Da!a\u0014\u000f\u0001\u0004A\u0018aB3mK6,g\u000e\u001e\u0005\u0007\u0003wq\u0001\u0019\u0001=\t\r\u0005Uc\u00021\u0001y\u0003)aWM\u001a;Jg:+H\u000e\u001c\u0005\u0007\u00033r\u0001\u0019\u0001=\u0002\u001b\u0005\u0014(/Y=ECR\fg*Y7f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003T\u0003?\n\u0019\u0007\u0003\u0004\u0002b=\u0001\raS\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t)g\u0004a\u0001\u0017\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B*\u0002l\u00055\u0004bB%\u0011!\u0003\u0005\ra\u0013\u0005\b\u001fB\u0001\n\u00111\u0001L\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001d+\u0007-\u000b)h\u000b\u0002\u0002xA!\u0011\u0011PAB\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014!C;oG\",7m[3e\u0015\r\t\t)O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAC\u0003w\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000bA\u0001\\1oO*\u0011\u0011qS\u0001\u0005U\u00064\u0018-C\u0002\u007f\u0003#\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a(\u0011\u0007a\n\t+C\u0002\u0002$f\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!\\AU\u0011%\tY+FA\u0001\u0002\u0004\ty*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0003R!a-\u0002:6l!!!.\u000b\u0007\u0005]\u0016(\u0001\u0006d_2dWm\u0019;j_:LA!a/\u00026\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA\u0017\u0011\u0019\u0005\t\u0003W;\u0012\u0011!a\u0001[\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti)a2\t\u0013\u0005-\u0006$!AA\u0002\u0005}\u0015AB3rk\u0006d7\u000fF\u0002i\u0003\u001bD\u0001\"a+\u001a\u0003\u0003\u0005\r!\u001c\u0015\u0014\u0001\u0005E\u0017q[Am\u0003;\fy.a9\u0002f\u0006%\u00181\u001e\t\u0004c\u0005M\u0017bAAkE\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAn\u0003){f)\u0016(D?\"*G.Z7f]Rd\u0003eY8v]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u0019:sCf\u00043m\u001c8uC&t\u0017N\\4!K2,W.\u001a8uA\r|WO\u001c;!i&lWm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!9\u0002\u000f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a4O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n$g\r\u0012-EE\u00124GI/\u000bA\u0001\nQa\u001a:pkB\f#!a:\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003[\fQA\r\u00185]A\n1\"\u0011:sCf\u0014V\r]3biB\u0011\u0011gG\n\u00067\u0005U(\u0011\u0001\t\b\u0003o\fipS&T\u001b\t\tIPC\u0002\u0002|f\nqA];oi&lW-\u0003\u0003\u0002\u0000\u0006e(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!!1\u0001B\u0005\u001b\t\u0011)A\u0003\u0003\u0003\b\u0005U\u0015AA5p\u0013\r9%Q\u0001\u000b\u0003\u0003c\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\u000bQ!\u00199qYf$Ra\u0015B\u000b\u0005/AQ!\u0013\u0010A\u0002-CQa\u0014\u0010A\u0002-\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u001e\t\u0015\u0002#\u0002\u001d\u0003 \t\r\u0012b\u0001B\u0011s\t1q\n\u001d;j_:\u0004R\u0001OA\u001a\u0017.C\u0001Ba\n \u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0017!\u0011\tyIa\f\n\t\tE\u0012\u0011\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayRepeat
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayRepeat x$0) {
        return ArrayRepeat$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayRepeat> tupled() {
        return ArrayRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayRepeat>> curried() {
        return ArrayRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public ArrayType dataType() {
        return new ArrayType(this.left().dataType(), this.left().nullable());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{AnyDataType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public boolean nullable() {
        return this.right().nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        GenericArrayData genericArrayData;
        Object count = this.right().eval(input);
        if (count == null) {
            genericArrayData = null;
        } else {
            if (BoxesRunTime.unboxToInt((Object)count) > 0x7FFFFFF0) {
                throw QueryExecutionErrors$.MODULE$.createArrayWithElementsExceedLimitError(count);
            }
            Object element = this.left().eval(input);
            genericArrayData = new GenericArrayData((Object[])Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)count), (Function0 & Serializable)() -> element, ClassTag$.MODULE$.Any()));
        }
        return genericArrayData;
    }

    @Override
    public String prettyName() {
        return "array_repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        ExprValue element = leftGen.value();
        ExprValue count = rightGen.value();
        DataType et = this.dataType().elementType();
        String coreLogic = this.genCodeForElement(ctx, et, ExprValue$.MODULE$.exprValueToString(element), ExprValue$.MODULE$.exprValueToString(count), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), ExprValue$.MODULE$.exprValueToString(ev.value()));
        String resultCode = this.nullElementsProtection(ev, ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), coreLogic);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " =\n         |  ", ";\n         |", "\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), leftGen.code(), rightGen.code(), CodeGenerator$.MODULE$.javaType((DataType)this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue((DataType)this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private String nullElementsProtection(ExprCode ev, String rightIsNull, String coreLogic) {
        return this.nullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(91).append("\n         |if (").append(rightIsNull).append(") {\n         |  ").append(ev.isNull()).append(" = true;\n         |} else {\n         |  ").append(coreLogic).append("\n         |}\n       ").toString())) : coreLogic;
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx, String count) {
        String numElements = ctx.freshName("numElements");
        String numElementsCode = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |int ").append(numElements).append(" = 0;\n         |if (").append(count).append(" > 0) {\n         |  ").append(numElements).append(" = ").append(count).append(";\n         |}\n       ").toString()));
        return new Tuple2((Object)numElements, (Object)numElementsCode);
    }

    private String genCodeForElement(CodegenContext ctx, DataType elementType, String element, String count, String leftIsNull, String arrayDataName) {
        String tempArrayDataName = ctx.freshName("tempArrayData");
        String k = ctx.freshName("k");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx, count);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemName = (String)tuple2._1();
        String numElemCode = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemName, (Object)numElemCode);
        Tuple2 tuple23 = tuple22;
        String numElemName2 = (String)tuple23._1();
        String numElemCode2 = (String)tuple23._2();
        String allocation = CodeGenerator$.MODULE$.createArrayData(tempArrayDataName, elementType, numElemName2, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.setArrayElement(tempArrayDataName, elementType, k, element, CodeGenerator$.MODULE$.setArrayElement$default$5());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(244).append("\n       |").append(numElemCode2).append("\n       |").append(allocation).append("\n       |if (!").append(leftIsNull).append(") {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(assignment).append("\n       |  }\n       |} else {\n       |  for (int ").append(k).append(" = 0; ").append(k).append(" < ").append(tempArrayDataName).append(".numElements(); ").append(k).append("++) {\n       |    ").append(tempArrayDataName).append(".setNullAt(").append(k).append(");\n       |  }\n       |}\n       |").append(arrayDataName).append(" = ").append(tempArrayDataName).append(";\n     ").toString()));
    }

    @Override
    public ArrayRepeat withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayRepeat copy(Expression left, Expression right) {
        return new ArrayRepeat(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayRepeat;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayRepeat arrayRepeat = (ArrayRepeat)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayRepeat.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayRepeat.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayRepeat.canEqual(this)) return false;
        return true;
    }

    public ArrayRepeat(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

