/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class EstimationUtils$ {
    public static final EstimationUtils$ MODULE$ = new EstimationUtils$();

    public boolean rowCountsExist(Seq<LogicalPlan> plans2) {
        return plans2.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$rowCountsExist$1(x$1)));
    }

    public boolean columnStatsExist(Seq<Tuple2<Statistics, Attribute>> statsAndAttr) {
        return statsAndAttr.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$columnStatsExist$1(x0$1)));
    }

    public boolean columnStatsWithCountsExist(Seq<Tuple2<Statistics, Attribute>> statsAndAttr) {
        return statsAndAttr.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$columnStatsWithCountsExist$1(x0$1)));
    }

    public ColumnStat nullColumnStat(DataType dataType, BigInt rowCount) {
        return new ColumnStat((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<BigInt>)new Some((Object)rowCount), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dataType.defaultSize())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dataType.defaultSize())), ColumnStat$.MODULE$.apply$default$7(), ColumnStat$.MODULE$.apply$default$8());
    }

    public Option<BigInt> updateStat(BigInt oldNumRows, BigInt newNumRows, Option<BigInt> oldStatOpt, Option<BigInt> updatedStatOpt) {
        return oldStatOpt.isDefined() && updatedStatOpt.isDefined() && ((Ordered)updatedStatOpt.get()).$greater((Object)BigInt$.MODULE$.int2bigInt(1)) && newNumRows.$less((Object)oldNumRows) ? new Some((Object)this.ceil(package$.MODULE$.BigDecimal().apply((BigInt)oldStatOpt.get()).$times(package$.MODULE$.BigDecimal().apply(newNumRows)).$div(package$.MODULE$.BigDecimal().apply(oldNumRows)))) : updatedStatOpt;
    }

    public BigInt ceil(BigDecimal bigDecimal) {
        return bigDecimal.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING()).toBigInt();
    }

    public AttributeMap<ColumnStat> getOutputMap(AttributeMap<ColumnStat> inputMap, Seq<Attribute> output) {
        return AttributeMap$.MODULE$.apply((Seq)output.flatMap((Function1 & Serializable)a -> inputMap.get((Attribute)a).map((Function1 & Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a), x$3))));
    }

    public Seq<Tuple2<Attribute, ColumnStat>> getAliasStats(Seq<Expression> expressions, AttributeMap<ColumnStat> attributeStats, BigInt rowCount) {
        return (Seq)expressions.collect((PartialFunction)new Serializable(attributeStats, rowCount){
            private static final long serialVersionUID = 0L;
            private final AttributeMap attributeStats$1;
            private final BigInt rowCount$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Expression expression;
                Expression expr;
                Object object;
                boolean bl = false;
                Alias alias = null;
                A1 A1 = x1;
                if (A1 instanceof Alias) {
                    Attribute attribute;
                    bl = true;
                    alias = (Alias)A1;
                    Expression attr = alias.child();
                    if (attr instanceof Attribute && this.attributeStats$1.contains(attribute = (Attribute)attr)) {
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias.toAttribute()), this.attributeStats$1.apply(attribute));
                        return (B1)object;
                    }
                }
                if (bl && (expr = alias.child()) != null && (expression = expr).foldable() && expression.deterministic()) {
                    Object value = expression.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow());
                    int size = expression.dataType().defaultSize();
                    ColumnStat columnStat = value == null ? new ColumnStat((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<BigInt>)new Some((Object)this.rowCount$1), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Histogram>)None$.MODULE$, 2) : new ColumnStat((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option<Object>)new Some(value), (Option<Object>)new Some(value), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)size)), (Option<Histogram>)None$.MODULE$, 2);
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias.toAttribute()), (Object)columnStat);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                Alias alias = null;
                Expression expression = x1;
                if (expression instanceof Alias) {
                    Attribute attribute;
                    bl = true;
                    alias = (Alias)expression;
                    Expression attr = alias.child();
                    if (attr instanceof Attribute && this.attributeStats$1.contains(attribute = (Attribute)attr)) {
                        return true;
                    }
                }
                if (!bl) return false;
                Expression expr = alias.child();
                if (expr == null) return false;
                Expression expression2 = expr;
                if (!expression2.foldable()) return false;
                if (!expression2.deterministic()) return false;
                return true;
            }
            {
                this.attributeStats$1 = attributeStats$1;
                this.rowCount$1 = rowCount$1;
            }
        });
    }

    public BigInt getSizePerRow(Seq<Attribute> attributes, AttributeMap<ColumnStat> attrStats) {
        return BigInt$.MODULE$.long2bigInt(8L + BoxesRunTime.unboxToLong((Object)((IterableOnceOps)attributes.map((Function1 & Serializable)attr -> BoxesRunTime.boxToLong((long)EstimationUtils$.$anonfun$getSizePerRow$1(attrStats, attr)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
    }

    public AttributeMap<ColumnStat> getSizePerRow$default$2() {
        return AttributeMap$.MODULE$.apply(package$.MODULE$.Nil());
    }

    public BigInt getOutputSize(Seq<Attribute> attributes, BigInt outputRowCount, AttributeMap<ColumnStat> attrStats) {
        return outputRowCount.$greater((Object)BigInt$.MODULE$.int2bigInt(0)) ? outputRowCount.$times(this.getSizePerRow(attributes, attrStats)) : BigInt$.MODULE$.int2bigInt(1);
    }

    public AttributeMap<ColumnStat> getOutputSize$default$3() {
        return AttributeMap$.MODULE$.apply(package$.MODULE$.Nil());
    }

    public double toDouble(Object value, DataType dataType) {
        double d;
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2));
        if (bl) {
            d = StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value.toString()));
        } else if (BooleanType$.MODULE$.equals(dataType2)) {
            d = BoxesRunTime.unboxToBoolean((Object)value) ? 1.0 : 0.0;
        } else {
            throw new MatchError((Object)dataType2);
        }
        return d;
    }

    public Object fromDouble(double d, DataType dataType) {
        Comparable<Boolean> comparable;
        DataType dataType2 = dataType;
        if (BooleanType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToBoolean(((int)d == 1 ? 1 : 0) != 0);
        } else if (DateType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToInteger((int)((int)d));
        } else if (TimestampType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToLong((long)((long)d));
        } else if (ByteType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToByte((byte)((byte)d));
        } else if (ShortType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToShort((short)((short)d));
        } else if (IntegerType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToInteger((int)((int)d));
        } else if (LongType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToLong((long)((long)d));
        } else if (FloatType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToFloat((float)((float)d));
        } else if (DoubleType$.MODULE$.equals(dataType2)) {
            comparable = BoxesRunTime.boxToDouble((double)d);
        } else if (dataType2 instanceof DecimalType) {
            comparable = Decimal$.MODULE$.apply(d);
        } else {
            throw new MatchError((Object)dataType2);
        }
        return comparable;
    }

    private int findFirstBinForValue(double value, HistogramBin[] bins) {
        int i;
        for (i = 0; i < bins.length && value > bins[i].hi(); ++i) {
        }
        return i;
    }

    private int findLastBinForValue(double value, HistogramBin[] bins) {
        int i;
        for (i = bins.length - 1; i >= 0 && value < bins[i].lo(); --i) {
        }
        return i;
    }

    private double binHoldingRangePossibility(double upperBound, double lowerBound, HistogramBin bin) {
        Predef$.MODULE$.assert(bin.lo() <= lowerBound && lowerBound <= upperBound && upperBound <= bin.hi());
        return bin.hi() == bin.lo() ? 1.0 : (upperBound == lowerBound ? 1.0 / (double)bin.ndv() : scala.math.package$.MODULE$.min((upperBound - lowerBound) / (bin.hi() - bin.lo()), 1.0));
    }

    public double numBinsHoldingRange(double upperBound, boolean upperBoundInclusive, double lowerBound, boolean lowerBoundInclusive, HistogramBin[] bins) {
        double d;
        Predef$.MODULE$.assert(((HistogramBin)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])bins))).lo() <= lowerBound && lowerBound <= upperBound && upperBound <= ((HistogramBin)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])bins))).hi(), (Function0 & Serializable)() -> "Given range does not fit in the given histogram.");
        Predef$.MODULE$.assert(upperBound != lowerBound || upperBoundInclusive || lowerBoundInclusive, (Function0 & Serializable)() -> new StringBuilder(34).append("'").append(lowerBound).append(" < value < ").append(upperBound).append("' is an invalid range.").toString());
        int upperBinIndex = upperBoundInclusive ? this.findLastBinForValue(upperBound, bins) : this.findFirstBinForValue(upperBound, bins);
        int lowerBinIndex = lowerBoundInclusive ? this.findFirstBinForValue(lowerBound, bins) : this.findLastBinForValue(lowerBound, bins);
        Predef$.MODULE$.assert(lowerBinIndex <= upperBinIndex, (Function0 & Serializable)() -> "Invalid histogram data.");
        if (lowerBinIndex == upperBinIndex) {
            d = this.binHoldingRangePossibility(upperBound, lowerBound, bins[lowerBinIndex]);
        } else {
            HistogramBin lowerBin = bins[lowerBinIndex];
            double lowerPart = this.binHoldingRangePossibility(lowerBin.hi(), lowerBound, lowerBin);
            HistogramBin higherBin = bins[upperBinIndex];
            double higherPart = this.binHoldingRangePossibility(upperBound, higherBin.lo(), higherBin);
            d = lowerPart + higherPart + (double)upperBinIndex - (double)lowerBinIndex - 1.0;
        }
        return d;
    }

    public Seq<EstimationUtils.OverlappedRange> getOverlappedRanges(Histogram leftHistogram, Histogram rightHistogram, double lowerBound, double upperBound) {
        ArrayBuffer overlappedRanges = new ArrayBuffer();
        HistogramBin[] leftBins = (HistogramBin[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])leftHistogram.bins()), (Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$getOverlappedRanges$1(upperBound, lowerBound, b)));
        HistogramBin[] rightBins = (HistogramBin[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])rightHistogram.bins()), (Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$getOverlappedRanges$2(upperBound, lowerBound, b)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])leftBins), (Function1 & Serializable)lb -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])rightBins), (Function1 & Serializable)rb -> {
                BoxedUnit boxedUnit;
                Tuple2<HistogramBin, Object> tuple2 = EstimationUtils$.MODULE$.trimBin(lb, leftHistogram$1.height(), lowerBound$2, upperBound$2);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                HistogramBin left = (HistogramBin)tuple2._1();
                double leftHeight = tuple2._2$mcD$sp();
                Tuple2 tuple22 = new Tuple2((Object)left, (Object)BoxesRunTime.boxToDouble((double)leftHeight));
                Tuple2 tuple23 = tuple22;
                HistogramBin left2 = (HistogramBin)tuple23._1();
                double leftHeight2 = tuple23._2$mcD$sp();
                Tuple2<HistogramBin, Object> tuple24 = EstimationUtils$.MODULE$.trimBin((HistogramBin)rb, rightHistogram$1.height(), lowerBound$2, upperBound$2);
                if (tuple24 == null) {
                    throw new MatchError(tuple24);
                }
                HistogramBin right = (HistogramBin)tuple24._1();
                double rightHeight = tuple24._2$mcD$sp();
                Tuple2 tuple25 = new Tuple2((Object)right, (Object)BoxesRunTime.boxToDouble((double)rightHeight));
                Tuple2 tuple26 = tuple25;
                HistogramBin right2 = (HistogramBin)tuple26._1();
                double rightHeight2 = tuple26._2$mcD$sp();
                if (left2.lo() <= right2.hi() && left2.hi() >= right2.lo()) {
                    EstimationUtils.OverlappedRange overlappedRange;
                    if (right2.lo() >= left2.lo() && right2.hi() >= left2.hi()) {
                        if (left2.hi() == right2.lo()) {
                            overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), right2.lo(), 1.0, 1.0, leftHeight2 / (double)left2.ndv(), rightHeight2 / (double)right2.ndv());
                        } else {
                            double leftRatio = (left2.hi() - right2.lo()) / (left2.hi() - left2.lo());
                            double rightRatio = (left2.hi() - right2.lo()) / (right2.hi() - right2.lo());
                            overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), left2.hi(), (double)left2.ndv() * leftRatio, (double)right2.ndv() * rightRatio, leftHeight2 * leftRatio, rightHeight2 * rightRatio);
                        }
                    } else if (right2.lo() <= left2.lo() && right2.hi() <= left2.hi()) {
                        if (right2.hi() == left2.lo()) {
                            overlappedRange = new EstimationUtils.OverlappedRange(right2.hi(), right2.hi(), 1.0, 1.0, leftHeight2 / (double)left2.ndv(), rightHeight2 / (double)right2.ndv());
                        } else {
                            double leftRatio = (right2.hi() - left2.lo()) / (left2.hi() - left2.lo());
                            double rightRatio = (right2.hi() - left2.lo()) / (right2.hi() - right2.lo());
                            overlappedRange = new EstimationUtils.OverlappedRange(left2.lo(), right2.hi(), (double)left2.ndv() * leftRatio, (double)right2.ndv() * rightRatio, leftHeight2 * leftRatio, rightHeight2 * rightRatio);
                        }
                    } else if (right2.lo() >= left2.lo() && right2.hi() <= left2.hi()) {
                        double leftRatio = (right2.hi() - right2.lo()) / (left2.hi() - left2.lo());
                        overlappedRange = new EstimationUtils.OverlappedRange(right2.lo(), right2.hi(), (double)left2.ndv() * leftRatio, right2.ndv(), leftHeight2 * leftRatio, rightHeight2);
                    } else {
                        Predef$.MODULE$.assert(right2.lo() <= left2.lo() && right2.hi() >= left2.hi());
                        double rightRatio = (left2.hi() - left2.lo()) / (right2.hi() - right2.lo());
                        overlappedRange = new EstimationUtils.OverlappedRange(left2.lo(), left2.hi(), left2.ndv(), (double)right2.ndv() * rightRatio, leftHeight2, rightHeight2 * rightRatio);
                    }
                    EstimationUtils.OverlappedRange range = overlappedRange;
                    boxedUnit = overlappedRanges$1.$plus$eq((Object)range);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
            return BoxedUnit.UNIT;
        });
        return overlappedRanges.toSeq();
    }

    public Tuple2<HistogramBin, Object> trimBin(HistogramBin bin, double height, double lowerBound, double upperBound) {
        Tuple2 tuple2;
        Tuple2.mcDD.sp sp2;
        Tuple2.mcDD.sp sp3;
        if (bin.lo() <= lowerBound && bin.hi() >= upperBound) {
            sp3 = new Tuple2.mcDD.sp(lowerBound, upperBound);
        } else if (bin.lo() <= lowerBound && bin.hi() >= lowerBound) {
            sp3 = new Tuple2.mcDD.sp(lowerBound, bin.hi());
        } else if (bin.lo() <= upperBound && bin.hi() >= upperBound) {
            sp3 = new Tuple2.mcDD.sp(bin.lo(), upperBound);
        } else {
            Predef$.MODULE$.assert(bin.lo() >= lowerBound && bin.hi() <= upperBound);
            sp3 = sp2 = new Tuple2.mcDD.sp(bin.lo(), bin.hi());
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double lo = sp2._1$mcD$sp();
        double hi = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(lo, hi);
        Tuple2.mcDD.sp sp5 = sp4;
        double lo2 = sp5._1$mcD$sp();
        double hi2 = sp5._2$mcD$sp();
        if (hi2 == lo2) {
            tuple2 = new Tuple2((Object)new HistogramBin(lo2, hi2, 1L), (Object)BoxesRunTime.boxToDouble((double)(height / (double)bin.ndv())));
        } else {
            Predef$.MODULE$.assert(bin.hi() != bin.lo());
            double ratio = (hi2 - lo2) / (bin.hi() - bin.lo());
            tuple2 = new Tuple2((Object)new HistogramBin(lo2, hi2, (long)scala.math.package$.MODULE$.ceil((double)bin.ndv() * ratio)), (Object)BoxesRunTime.boxToDouble((double)(height * ratio)));
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$rowCountsExist$1(LogicalPlan x$1) {
        return x$1.stats().rowCount().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$columnStatsExist$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Statistics stats = (Statistics)tuple2._1();
        Attribute attr = (Attribute)tuple2._2();
        boolean bl = stats.attributeStats().contains(attr);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$columnStatsWithCountsExist$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Statistics stats = (Statistics)tuple2._1();
        Attribute attr = (Attribute)tuple2._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)stats.attributeStats().get(attr).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.hasCountStats())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getSizePerRow$2(ColumnStat x$4) {
        return x$4.avgLen().isDefined();
    }

    public static final /* synthetic */ long $anonfun$getSizePerRow$1(AttributeMap attrStats$1, Attribute attr) {
        long l;
        if (BoxesRunTime.unboxToBoolean((Object)attrStats$1.get(attr).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EstimationUtils$.$anonfun$getSizePerRow$2(x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            DataType dataType = attr.dataType();
            long l2 = StringType$.MODULE$.equals(dataType) ? BoxesRunTime.unboxToLong((Object)((ColumnStat)attrStats$1.apply(attr)).avgLen().get()) + 8L + 4L : BoxesRunTime.unboxToLong((Object)((ColumnStat)attrStats$1.apply(attr)).avgLen().get());
            l = l2;
        } else {
            l = attr.dataType().defaultSize();
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$getOverlappedRanges$1(double upperBound$2, double lowerBound$2, HistogramBin b) {
        return b.lo() <= upperBound$2 && b.hi() >= lowerBound$2;
    }

    public static final /* synthetic */ boolean $anonfun$getOverlappedRanges$2(double upperBound$2, double lowerBound$2, HistogramBin b) {
        return b.lo() <= upperBound$2 && b.hi() >= lowerBound$2;
    }

    private EstimationUtils$() {
    }
}

