/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0014)\u0001VB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t5\u0002\u0011\t\u0012)A\u0005\u0017\"A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005a\u0001\tE\t\u0015!\u0003^\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u00151\u0007\u0001\"\u0011h\u0011\u001dI\u0007A1A\u0005F)Dq!a\u0001\u0001A\u000351\u000eC\u0004\u0002\u0006\u0001!\t&a\u0002\t\u0015\u0005M\u0001\u0001#b\u0001\n\u0003\n)\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!1\u0011q\t\u0001\u0005B\u001dDq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002P\u0001!\t%!\u0015\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!1Q\u0006\u0001C!\u0003sBq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u001a\u0002!\t%a'\t\u0013\u0005\u0005\u0006!!A\u0005\u0002\u0005\r\u0006\"CAU\u0001E\u0005I\u0011AAV\u0011%\t\t\rAI\u0001\n\u0003\t\u0019\rC\u0005\u0002H\u0002\t\t\u0011\"\u0011\u0002J\"I\u0011\u0011\u001c\u0001\u0002\u0002\u0013\u0005\u00111\u001c\u0005\n\u0003G\u0004\u0011\u0011!C\u0001\u0003KD\u0011\"a;\u0001\u0003\u0003%\t%!<\t\u0013\u0005m\b!!A\u0005\u0002\u0005u\b\"\u0003B\u0001\u0001\u0005\u0005I\u0011\tB\u0002\u000f\u001d\u0011i\u0003\u000bE\u0001\u0005_1aa\n\u0015\t\u0002\tE\u0002BB1\u001f\t\u0003\u0011I\u0004C\u0004\u0003<y!\tA!\u0010\t\u000f\t\rc\u0004\"\u0001\u0003F!I!1\b\u0010\u0002\u0002\u0013\u0005%\u0011\n\u0005\n\u0005\u001fr\u0012\u0013!C\u0001\u0003\u0007D\u0011B!\u0015\u001f\u0003\u0003%\tIa\u0015\t\u0013\tuc$%A\u0005\u0002\u0005\r\u0007\"\u0003B0=\u0005\u0005I\u0011\u0002B1\u0005!\u0019\u0015m]3XQ\u0016t'BA\u0015+\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005-b\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00055r\u0013aA:rY*\u0011q\u0006M\u0001\u0006gB\f'o\u001b\u0006\u0003cI\na!\u00199bG\",'\"A\u001a\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00011$(\u0010!G!\t9\u0004(D\u0001)\u0013\tI\u0004F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"aN\u001e\n\u0005qB#\u0001H\"p[BdW\r\u001f+za\u0016lUM]4j]\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003oyJ!a\u0010\u0015\u0003+\r{g\u000eZ5uS>t\u0017\r\\#yaJ,7o]5p]B\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA!H\u0013\tA%I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005ce\u0006t7\r[3t+\u0005Y\u0005c\u0001'U/:\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!R\na\u0001\u0010:p_Rt\u0014\"A\"\n\u0005M\u0013\u0015a\u00029bG.\fw-Z\u0005\u0003+Z\u00131aU3r\u0015\t\u0019&\t\u0005\u0003B1Z2\u0014BA-C\u0005\u0019!V\u000f\u001d7fe\u0005I!M]1oG\",7\u000fI\u0001\nK2\u001cXMV1mk\u0016,\u0012!\u0018\t\u0004\u0003z3\u0014BA0C\u0005\u0019y\u0005\u000f^5p]\u0006QQ\r\\:f-\u0006dW/\u001a\u0011\u0002\rqJg.\u001b;?)\r\u0019G-\u001a\t\u0003o\u0001AQ!S\u0003A\u0002-CqaW\u0003\u0011\u0002\u0003\u0007Q,\u0001\u0005dQ&dGM]3o+\u0005A\u0007c\u0001'Um\u0005aan\u001c3f!\u0006$H/\u001a:ogV\t1\u000eE\u0002M)2\u0004\"!\u001c@\u000f\u00059\\hBA8z\u001d\t\u0001\bP\u0004\u0002ro:\u0011!O\u001e\b\u0003gVt!A\u0014;\n\u0003MJ!!\r\u001a\n\u0005=\u0002\u0014BA\u0017/\u0013\tYC&\u0003\u0002{U\u0005)AO]3fg&\u0011A0`\u0001\f)J,W\rU1ui\u0016\u0014hN\u0003\u0002{U%\u0019q0!\u0001\u0003\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0003yv\fQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r1\u0014\u0011\u0002\u0005\b\u0003\u0017I\u0001\u0019AA\u0007\u0003-qWm^\"iS2$'/\u001a8\u0011\t1\u000byAN\u0005\u0004\u0003#1&AC%oI\u0016DX\rZ*fc\u0006!\u0012N\u001c9viRK\b/Z:G_JlUM]4j]\u001e,\"!a\u0006\u0011\t1#\u0016\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u0017\u0002\u000bQL\b/Z:\n\t\u0005\r\u0012Q\u0004\u0002\t\t\u0006$\u0018\rV=qK\"\u001a!\"a\n\u0011\u0007\u0005\u000bI#C\u0002\u0002,\t\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00119,H\u000e\\1cY\u0016,\"!!\r\u0011\u0007\u0005\u000b\u0019$C\u0002\u00026\t\u0013qAQ8pY\u0016\fg.A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B)\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u000b\nyDA\bUsB,7\t[3dWJ+7/\u001e7u\u0003U\tGn^1zg\u00163\u0018\r\\;bi\u0016$\u0017J\u001c9viN\fAB\u0019:b]\u000eDwI]8vaN,\"!!\u0014\u0011\u00071#\u0006.\u0001\u0003fm\u0006dG\u0003BA*\u00033\u00022!QA+\u0013\r\t9F\u0011\u0002\u0004\u0003:L\b\"CA.\u001fA\u0005\t\u0019AA/\u0003\u0015Ig\u000e];u!\u0011\ty&!\u0019\u000e\u0003)J1!a\u0019+\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001b\u0011\t\u0005-\u00141\u000f\b\u0005\u0003[\ny\u0007\u0005\u0002O\u0005&\u0019\u0011\u0011\u000f\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t)(a\u001e\u0003\rM#(/\u001b8h\u0015\r\t\tHQ\u000b\u0003\u0003S\nA#\\;mi&\u0014%/\u00198dQ\u0016\u001c8i\u001c3fO\u0016tGCBA@\u0003\u0017\u000b)\n\u0005\u0003\u0002\u0002\u0006\u001dUBAAB\u0015\r\t)\tK\u0001\bG>$WmZ3o\u0013\u0011\tI)a!\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!$\u0013\u0001\u0004\ty)A\u0002dib\u0004B!!!\u0002\u0012&!\u00111SAB\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a&\u0013\u0001\u0004\ty(\u0001\u0002fm\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u007f\ni*a(\t\u000f\u000555\u00031\u0001\u0002\u0010\"9\u0011qS\nA\u0002\u0005}\u0014\u0001B2paf$RaYAS\u0003OCq!\u0013\u000b\u0011\u0002\u0003\u00071\nC\u0004\\)A\u0005\t\u0019A/\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0016\u0016\u0004\u0017\u0006=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m&)\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0019\u0016\u0004;\u0006=\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002LB!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017\u0001\u00027b]\u001eT!!!6\u0002\t)\fg/Y\u0005\u0005\u0003k\ny-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002^B\u0019\u0011)a8\n\u0007\u0005\u0005(IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002T\u0005\u001d\b\"CAu3\u0005\u0005\t\u0019AAo\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001e\t\u0007\u0003c\f90a\u0015\u000e\u0005\u0005M(bAA{\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00181\u001f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00022\u0005}\b\"CAu7\u0005\u0005\t\u0019AA*\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0007B\u0003\u0011%\tI\u000fHA\u0001\u0002\u0004\t\u0019\u0006K\f\u0001\u0005\u0013\u0011yA!\u0005\u0003\u0016\t]!1\u0004B\u000f\u0005C\u0011\u0019Ca\n\u0003*A\u0019qGa\u0003\n\u0007\t5\u0001FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tM\u0011!a\u0017D\u0003N+\u0005e\u0016%F\u001d\u0002*\u0007\u0010\u001d:2AQCUI\u0014\u0011fqB\u0014(\u0007I.X\u0011\u0016s\u0005%\u001a=qeN\u0002C\u000bS#OA\u0015D\bO\u001d\u001b^U\u0001ZV\tT*FA\u0015D\bO]\u001b^A\u0015sE\tI\u0017!/\",g\u000e\t1fqB\u0014\u0018\u0007\u0019\u0011>AQ\u0014X/\u001a\u0017!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:3An\u0002S\r\\:fA]DWM\u001c\u0011aKb\u0004(o\r1!{\u0001\"(/^3-AI,G/\u001e:og\u0002\u0002W\r\u001f9si\u0001\\\u0004%\u001a7tK\u0002\u0012X\r^;s]N\u0004\u0003-\u001a=qeV\u0002g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012!\u0011D\u0001\u0002z*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeN\u0002S\u0006\t;iK\u0002\u0012'/\u00198dQ\u0002\u001awN\u001c3ji&|g\u000eI3yaJ,7o]5p]N\u00043\u000f[8vY\u0012\u0004\u0013\r\u001c7!E\u0016\u0004#m\\8mK\u0006t\u0007\u0005^=qK:R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeJb\u0003%\u001a=qeRb\u0003%\u001a=qeV\u0002S\u0006\t;iK\u0002\u0012'/\u00198dQ\u00022\u0018\r\\;fA\u0015D\bO]3tg&|gn\u001d\u0011b]\u0012\u0004S\r\\:fAY\fG.^3!Kb\u0004(/Z:tS>t\u0007e\u001d5pk2$\u0007%\u00197mA\t,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011d_\u0016\u00148-\u001b2mK\u0002\"x\u000eI1!G>lWn\u001c8!if\u0004XM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003 \u0005\u0011)A\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011D\u0003N+\u0005e\u0016%F\u001d\u0002\n\u0004E\u0010\u00111AQCUI\u0014\u00112A]CUI\u0014\u00113Ay\u0002\u0003\u0007\t+I\u000b:\u0003#G\f\u0019!\u000b2\u001bV\tI\u0019/e\u0001*e\nR\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\"B'\u0016\u0003s\u000bS#OAE\u0002C\b\t\u0019!)\"+e\nI\u0019!/\"+e\n\t\u001a!}\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\u0012d\u0006\r\u0011F\u0019N+\u0005%\r\u00183A\u0015sEi\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113]AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001b\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011=AA\u0002C\u000bS#OAIr\u0003\u0007I#O\tnR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u0013\u0003\u0015\td\u0006\r\u00182\u0003\u00159'o\\;qC\t\u0011Y#A\td_:$\u0017\u000e^5p]\u0006dwLZ;oGN\f\u0001bQ1tK^CWM\u001c\t\u0003oy\u0019BA\bB\u001a\rB\u0019\u0011I!\u000e\n\u0007\t]\"I\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005_\tQ!\u00199qYf$Ra\u0019B \u0005\u0003BQ!\u0013\u0011A\u0002-CQa\u0017\u0011A\u0002Y\n\u0001c\u0019:fCR,gI]8n!\u0006\u00148/\u001a:\u0015\u0007\r\u00149\u0005C\u0003JC\u0001\u0007\u0001\u000eF\u0003d\u0005\u0017\u0012i\u0005C\u0003JE\u0001\u00071\nC\u0004\\EA\u0005\t\u0019A/\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003V\te\u0003\u0003B!_\u0005/\u0002B!\u0011-L;\"A!1\f\u0013\u0002\u0002\u0003\u00071-A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0019\u0011\t\u00055'QM\u0005\u0005\u0005O\nyM\u0001\u0004PE*,7\r\u001e")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
ConditionalExpression,
scala.Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private final Seq<Enumeration.Value> nodePatterns;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen caseWhen) {
        return CaseWhen$.MODULE$.unapply(caseWhen);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static CaseWhen createFromParser(Seq<Expression> seq) {
        return CaseWhen$.MODULE$.createFromParser(seq);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((TraversableLike)this.branches().flatMap((Function1 & Serializable & scala.Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression);
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return super.legacyWithNewChildren(newChildren);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$4 -> ((Expression)x$4._2()).dataType(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.dataType())), Seq$.MODULE$.canBuildFrom());
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if (!this.bitmap$trans$0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$6))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$8)))) {
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
            int index = this.branches().indexWhere((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$3(x$9)));
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Integer.toString(index + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr((Expression)((Tuple2)this.branches().apply(index))._1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)((Expression)((Tuple2)this.branches().apply(index))._1()).dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)TypeUtils$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((TraversableOnce)this.inputTypesForMerging().map((Function1 & Serializable & scala.Serializable)t -> TypeUtils$.MODULE$.toSQLType((AbstractDataType)t), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]"))}))));
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = (Expression)this.children().head();
        return Nil$.MODULE$.$colon$colon((Object)expression);
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        Nil$ conditions = this.branches().length() > 1 ? (Seq)this.branches().map((Function1 & Serializable & scala.Serializable)x$11 -> (Expression)x$11._1(), Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
        Nil$ values = this.elseValue().nonEmpty() ? (Seq)((TraversableLike)this.branches().map((Function1 & Serializable & scala.Serializable)x$12 -> (Expression)x$12._2(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.elseValue()), Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
        return (Seq)new .colon.colon((Object)conditions, (List)new .colon.colon((Object)values, (List)Nil$.MODULE$));
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        if (this.elseValue().isDefined()) {
            return ((Expression)this.elseValue().get()).eval(input);
        }
        return null;
    }

    @Override
    public String toString() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression c = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                return new StringBuilder(12).append(" WHEN ").append(c).append(" THEN ").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$13 -> new StringBuilder(6).append(" ELSE ").append(x$13).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((TraversableOnce)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression c = (Expression)tuple2._1();
                Expression v = (Expression)tuple2._2();
                return new StringBuilder(12).append(" WHEN ").append(c.sql()).append(" THEN ").append(v.sql()).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(6).append(" ELSE ").append(x$14.sql()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression condExpr = (Expression)tuple2._1();
                Expression valueExpr = (Expression)tuple2._2();
                ExprCode cond = condExpr.genCode(ctx);
                ExprCode res = valueExpr.genCode(ctx);
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(cond.code()).append("\n         |if (!").append(cond.isNull()).append(" && ").append(cond.value()).append(") {\n         |  ").append(res.code()).append("\n         |  ").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |  ").append(ev.value()).append(" = ").append(res.value()).append(";\n         |  continue;\n         |}\n       ").toString())).stripMargin();
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        Option elseCode = this.elseValue().map((Function1 & Serializable & scala.Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n         |").append(res.code()).append("\n         |").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |").append(ev.value()).append(" = ").append(res.value()).append(";\n       ").toString())).stripMargin();
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(elseCode), Seq$.MODULE$.canBuildFrom());
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)func -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append("byte").append(" ").append(resultState).append(" = ").append(NOT_MATCHED).append(";\n           |do {\n           |  ").append((String)func).append("\n           |} while (false);\n           |return ").append(resultState).append(";\n         ").toString())).stripMargin();
        Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)x$15 -> ((TraversableOnce)x$15.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(resultState).append(" = ").append((String)funcCall).append(";\n           |if (").append(resultState).append(" != ").append(NOT_MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, x$2, x$6, x$3, (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        if (this.branches().length() == 1) {
            return new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev);
        }
        return this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.branches();
            }
            case 1: {
                return this.elseValue();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$6) {
        return ((Expression)x$6._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$8) {
        DataType dataType = ((Expression)x$8._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$3(Tuple2 x$9) {
        DataType dataType = ((Expression)x$9._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
        ConditionalExpression.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.CASE_WHEN(), (List)Nil$.MODULE$);
    }
}

