/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Levenshtein$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str1, str2[, threshold]) - Returns the Levenshtein distance between the two given strings. If threshold is set and distance more than it, return -1.", examples="\n    Examples:\n      > SELECT _FUNC_('kitten', 'sitting');\n       3\n      > SELECT _FUNC_('kitten', 'sitting', 2);\n       -1\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0005c\u0001\u0002\u0015*\u0001ZB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005o!A\u0011\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005S\u0001\tE\t\u0015!\u00038\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A0\t\u000be\u0003A\u0011A2\t\u000b\u0019\u0004A\u0011I4\t\u000b9\u0004A\u0011I8\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\n\u0001\u0011E\u0013Q\u0003\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\tY\u0003\u0001C!\u0003GAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004\"CA;\u0001\u0005\u0005I\u0011AA<\u0011%\ty\bAI\u0001\n\u0003\t\t\tC\u0005\u0002\u0018\u0002\t\n\u0011\"\u0001\u0002\u0002\"I\u0011\u0011\u0014\u0001\u0012\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003?\u0003\u0011\u0011!C!\u0003CC\u0011\"a-\u0001\u0003\u0003%\t!!.\t\u0013\u0005u\u0006!!A\u0005\u0002\u0005}\u0006\"CAc\u0001\u0005\u0005I\u0011IAd\u0011%\t)\u000eAA\u0001\n\u0003\t9\u000eC\u0005\u0002\\\u0002\t\t\u0011\"\u0011\u0002^\u001eI!\u0011A\u0015\u0002\u0002#\u0005!1\u0001\u0004\tQ%\n\t\u0011#\u0001\u0003\u0006!1\u0011\f\tC\u0001\u0005'A\u0011B!\u0006!\u0003\u0003%)Ea\u0006\t\u0013\te\u0001%!A\u0005\u0002\nm\u0001\"\u0003B\u0012AE\u0005I\u0011AAN\u0011%\u0011)\u0003IA\u0001\n\u0003\u00139\u0003C\u0005\u00036\u0001\n\n\u0011\"\u0001\u0002\u001c\"I!q\u0007\u0011\u0002\u0002\u0013%!\u0011\b\u0002\f\u0019\u00164XM\\:ii\u0016LgN\u0003\u0002+W\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\taS&\u0001\u0005dCR\fG._:u\u0015\tqs&A\u0002tc2T!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'\u0019\u0001qg\u000f F\u0017B\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001d=\u0013\ti\u0014F\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\ty$I\u0004\u00029\u0001&\u0011\u0011)K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EI\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005\u0005K\u0003C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%a\u0002)s_\u0012,8\r\u001e\t\u0003\r2K!!T$\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002o\u0005)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0016\u0003U\u00032A\u0012,8\u0013\t9vI\u0001\u0004PaRLwN\\\u0001\u000bi\"\u0014Xm\u001d5pY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003\\9vs\u0006C\u0001\u001d\u0001\u0011\u0015qu\u00011\u00018\u0011\u0015\tv\u00011\u00018\u0011\u001d\u0019v\u0001%AA\u0002U#Ba\u00171bE\")a\n\u0003a\u0001o!)\u0011\u000b\u0003a\u0001o!)1\u000b\u0003a\u0001oQ\u00191\fZ3\t\u000b9K\u0001\u0019A\u001c\t\u000bEK\u0001\u0019A\u001c\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003!\u0004\"!\u001b7\u000e\u0003)T!a[\u0016\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001c6\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0001\bcA9yw:\u0011!o\u001e\b\u0003gZl\u0011\u0001\u001e\u0006\u0003kV\na\u0001\u0010:p_Rt\u0014\"\u0001%\n\u0005\u0005;\u0015BA={\u0005\r\u0019V-\u001d\u0006\u0003\u0003\u001e\u0003\"\u0001`@\u000e\u0003uT!A`\u0017\u0002\u000bQL\b/Z:\n\u0007\u0005\u0005QP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006A1\r[5mIJ,g.\u0006\u0002\u0002\bA\u0019\u0011\u000f_\u001c\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!!\u0004\u0011\u0007q\fy!C\u0002\u0002\u0012u\u0014\u0001\u0002R1uCRK\b/Z\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2aNA\f\u0011\u001d\tIB\u0004a\u0001\u00037\t1B\\3x\u0007\"LG\u000e\u001a:f]B!\u0011/!\b8\u0013\r\tyB\u001f\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005\u0015\u0002c\u0001$\u0002(%\u0019\u0011\u0011F$\u0003\u000f\t{w\u000e\\3b]\u0006Aam\u001c7eC\ndW-\u0001\u0003fm\u0006dG\u0003BA\u0019\u0003o\u00012ARA\u001a\u0013\r\t)d\u0012\u0002\u0004\u0003:L\b\"CA\u001d#A\u0005\t\u0019AA\u001e\u0003\u0015Ig\u000e];u!\u0011\ti$a\u0010\u000e\u0003-J1!!\u0011,\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA$\u0003'\ni\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti%K\u0001\bG>$WmZ3o\u0013\u0011\t\t&a\u0013\u0003\u0011\u0015C\bO]\"pI\u0016Dq!!\u0016\u0013\u0001\u0004\t9&A\u0002dib\u0004B!!\u0013\u0002Z%!\u00111LA&\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!a\u0018\u0013\u0001\u0004\t9%\u0001\u0002fm\u0006!r-\u001a8D_\u0012,w+\u001b;i)\"\u0014Xm\u001d5pY\u0012$\u0002\"a\u0012\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\b\u0003+\u001a\u0002\u0019AA,\u0011\u001d\tyf\u0005a\u0001\u0003\u000fBa!a\u001b\u0014\u0001\u00049\u0014!\u0004;ie\u0016\u001c\bn\u001c7e\u000bb\u0004(/A\fhK:\u001cu\u000eZ3XSRDw.\u001e;UQJ,7\u000f[8mIR1\u0011qIA9\u0003gBq!!\u0016\u0015\u0001\u0004\t9\u0006C\u0004\u0002`Q\u0001\r!a\u0012\u0002\t\r|\u0007/\u001f\u000b\b7\u0006e\u00141PA?\u0011\u001dqU\u0003%AA\u0002]Bq!U\u000b\u0011\u0002\u0003\u0007q\u0007C\u0004T+A\u0005\t\u0019A+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0011\u0016\u0004o\u0005\u00155FAAD!\u0011\tI)a%\u000e\u0005\u0005-%\u0002BAG\u0003\u001f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Eu)\u0001\u0006b]:|G/\u0019;j_:LA!!&\u0002\f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAAOU\r)\u0016QQ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0006\u0003BAS\u0003_k!!a*\u000b\t\u0005%\u00161V\u0001\u0005Y\u0006twM\u0003\u0002\u0002.\u0006!!.\u0019<b\u0013\u0011\t\t,a*\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\fE\u0002G\u0003sK1!a/H\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t$!1\t\u0013\u0005\r7$!AA\u0002\u0005]\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JB1\u00111ZAi\u0003ci!!!4\u000b\u0007\u0005=w)\u0001\u0006d_2dWm\u0019;j_:LA!a5\u0002N\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)#!7\t\u0013\u0005\rW$!AA\u0002\u0005E\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002&\u0005}\u0007\"CAb=\u0005\u0005\t\u0019AA\u0019QM\u0001\u00111]Au\u0003W\fy/!=\u0002v\u0006]\u00181`A\u007f!\rA\u0014Q]\u0005\u0004\u0003OL#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\f\u0011\u0011\t\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:2Y\u0001\u001aHO\u001d\u001a\\Y\u0001\"\bN]3tQ>dG-X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!\u0019\u00164XM\\:ii\u0016Lg\u000e\t3jgR\fgnY3!E\u0016$x/Z3oAQDW\r\t;x_\u0002:\u0017N^3oAM$(/\u001b8hg:\u0002\u0013J\u001a\u0011uQJ,7\u000f[8mI\u0002J7\u000fI:fi\u0002\ng\u000e\u001a\u0011eSN$\u0018M\\2fA5|'/\u001a\u0011uQ\u0006t\u0007%\u001b;-AI,G/\u001e:oA5\nd&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u00190A@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ\u0017\u000e\u001e;f]\u001eb\u0003eJ:jiRLgnZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014lSR$XM\\\u0014-A\u001d\u001a\u0018\u000e\u001e;j]\u001e<C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tI0A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002\u0000\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006YA*\u001a<f]NDG/Z5o!\tA\u0004e\u0005\u0003!\u0005\u000fY\u0005\u0003\u0003B\u0005\u0005\u001f9t'V.\u000e\u0005\t-!b\u0001B\u0007\u000f\u00069!/\u001e8uS6,\u0017\u0002\u0002B\t\u0005\u0017\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\u0011\u0019!\u0001\u0005u_N#(/\u001b8h)\t\t\u0019+A\u0003baBd\u0017\u0010F\u0004\\\u0005;\u0011yB!\t\t\u000b9\u001b\u0003\u0019A\u001c\t\u000bE\u001b\u0003\u0019A\u001c\t\u000fM\u001b\u0003\u0013!a\u0001+\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t%\"\u0011\u0007\t\u0005\rZ\u0013Y\u0003\u0005\u0004G\u0005[9t'V\u0005\u0004\u0005_9%A\u0002+va2,7\u0007\u0003\u0005\u00034\u0015\n\t\u00111\u0001\\\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005w\u0001B!!*\u0003>%!!qHAT\u0005\u0019y%M[3di\u0002")
public class Levenshtein
extends Expression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<Expression> threshold;

    public static Option<Expression> $lessinit$greater$default$3() {
        return Levenshtein$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(Levenshtein levenshtein) {
        return Levenshtein$.MODULE$.unapply(levenshtein);
    }

    public static Option<Expression> apply$default$3() {
        return Levenshtein$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, Levenshtein> tupled() {
        return Levenshtein$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, Levenshtein>>> curried() {
        return Levenshtein$.MODULE$.curried();
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Option<Expression> threshold() {
        return this.threshold;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().length() > 3 || this.children().length() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
        }
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression value = (Expression)some.value();
            return (Seq)new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
        }
        return (Seq)new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)x$39.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)x$40.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Object leftEval = this.left().eval(input);
        if (leftEval == null) {
            return null;
        }
        Object rightEval = this.right().eval(input);
        if (rightEval == null) {
            return null;
        }
        Option thresholdEval = this.threshold().map((Function1 & Serializable & scala.Serializable)x$41 -> x$41.eval(input));
        Option option = thresholdEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval, BoxesRunTime.unboxToInt((Object)v)));
        }
        return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.genCodeWithThreshold(ctx, ev, (Expression)this.children().apply(2));
        }
        return this.genCodeWithoutThreshold(ctx, ev);
    }

    private ExprCode genCodeWithThreshold(CodegenContext ctx, ExprCode ev, Expression thresholdExpr) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        ExprCode thresholdGen = thresholdExpr.genCode(ctx);
        String resultCode = new StringBuilder(28).append(ev.value()).append(" = ").append(leftGen.value()).append(".levenshteinDistance(").append(rightGen.value()).append(", ").append(thresholdGen.value()).append(");").toString();
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)rightGen.code()), ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)thresholdGen.code()), ctx.nullSafeExec(thresholdExpr.nullable(), ExprValue$.MODULE$.exprValueToString(thresholdGen.isNull()), new StringBuilder(53).append("\n              ").append(ev.isNull()).append(" = false;\n              ").append(resultCode).append("\n             ").toString()))))));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code()).$plus(thresholdGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private ExprCode genCodeWithoutThreshold(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        String resultCode = new StringBuilder(26).append(ev.value()).append(" = ").append(leftGen.value()).append(".levenshteinDistance(").append(rightGen.value()).append(");").toString();
        if (this.nullable()) {
            String nullSafeEval = Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)leftGen.code()), ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)rightGen.code()), ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), new StringBuilder(47).append("\n            ").append(ev.isNull()).append(" = false;\n            ").append(resultCode).append("\n           ").toString()))));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Levenshtein copy(Expression left, Expression right, Option<Expression> threshold) {
        return new Levenshtein(left, right, threshold);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Expression> copy$default$3() {
        return this.threshold();
    }

    @Override
    public String productPrefix() {
        return "Levenshtein";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.threshold();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Levenshtein;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Levenshtein)) return false;
        boolean bl = true;
        if (!bl) return false;
        Levenshtein levenshtein = (Levenshtein)x$1;
        Expression expression = this.left();
        Expression expression2 = levenshtein.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = levenshtein.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.threshold();
        Option<Expression> option2 = levenshtein.threshold();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!levenshtein.canEqual(this)) return false;
        return true;
    }

    public Levenshtein(Expression left, Expression right, Option<Expression> threshold) {
        this.left = left;
        this.right = right;
        this.threshold = threshold;
        ExpectsInputTypes.$init$(this);
    }

    public Levenshtein(Expression left, Expression right, Expression threshold) {
        this(left, right, (Option<Expression>)Option$.MODULE$.apply((Object)threshold));
    }

    public Levenshtein(Expression left, Expression right) {
        this(left, right, (Option<Expression>)None$.MODULE$);
    }
}

