/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HllSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, lgConfigK) - Returns the HllSketch's updatable binary representation.\n      `lgConfigK` (optional) the log-base-2 of K, with K is the number of buckets or\n      slots for the HllSketch. ", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(col, 12)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="agg_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u001c9\u0001\u001eC\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\tY\u0002\u0011\t\u0012)A\u00055\"AQ\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005o\u0001\tE\t\u0015!\u0003[\u0011!y\u0007A!f\u0001\n\u0003\u0001\b\u0002\u0003;\u0001\u0005#\u0005\u000b\u0011B9\t\u0011U\u0004!Q3A\u0005\u0002AD\u0001B\u001e\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\t}\u0002A)\u0019!C\u0001a\"Aq\u0010\u0001b\u0001\n\u0013\t\t\u0001\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0002\u0011\u00199\b\u0001\"\u0001\u0002\f!1q\u000f\u0001C\u0001\u0003#Aaa\u001e\u0001\u0005\u0002\u0005]\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\ti\u0003\u0001C)\u0003_Aq!!\u000f\u0001\t\u0003\nY\u0004C\u0004\u0002T\u0001!\t%!\u0016\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!!+\u0001\t\u0003\nY\u000bC\u0004\u00026\u0002!\t%a.\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u00037\u0004\u0011\u0013!C\u0001\u0003;D\u0011\"a=\u0001#\u0003%\t!!8\t\u0013\u0005U\b!%A\u0005\u0002\u0005]\b\"CA~\u0001E\u0005I\u0011AA|\u0011%\ti\u0010AA\u0001\n\u0003\ny\u0010\u0003\u0005\u0003\u0010\u0001\t\t\u0011\"\u0001q\u0011%\u0011\t\u0002AA\u0001\n\u0003\u0011\u0019\u0002C\u0005\u0003\u001a\u0001\t\t\u0011\"\u0011\u0003\u001c!I!\u0011\u0006\u0001\u0002\u0002\u0013\u0005!1\u0006\u0005\n\u0005_\u0001\u0011\u0011!C!\u0005c9qA!\u00169\u0011\u0003\u00119F\u0002\u00048q!\u0005!\u0011\f\u0005\u0007o&\"\tA!\u0019\t\u0011\t\r\u0014F1A\u0005\nADqA!\u001a*A\u0003%\u0011\u000f\u0003\u0005\u0003h%\u0012\r\u0011\"\u0003q\u0011\u001d\u0011I'\u000bQ\u0001\nEDqAa\u001b*\t\u0003\u0011i\u0007C\u0005\u0003x%\n\t\u0011\"!\u0003z!I!1Q\u0015\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0005\u000bK\u0013\u0013!C\u0001\u0003oD\u0011Ba\"*\u0003\u0003%\tI!#\t\u0013\tm\u0015&%A\u0005\u0002\u0005]\b\"\u0003BOSE\u0005I\u0011AA|\u0011%\u0011y*KA\u0001\n\u0013\u0011\tK\u0001\u0007IY2\u001c6.\u001a;dQ\u0006;wM\u0003\u0002:u\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003wq\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QHP\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\bQ\u0001\u0004gFd'BA!C\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\u0004\u0001M1\u0001\u0001\u0013+_C\u001e\u00042!\u0013&M\u001b\u0005A\u0014BA&9\u0005a!\u0016\u0010]3e\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000b1\u0001\u001b7m\u0015\t\t&)\u0001\u0007eCR\f7o[3uG\",7/\u0003\u0002T\u001d\nI\u0001\n\u001c7TW\u0016$8\r\u001b\t\u0004+bSV\"\u0001,\u000b\u0005]c\u0014!\u0002;sK\u0016\u001c\u0018BA-W\u0005)\u0011\u0015N\\1ss2K7.\u001a\t\u00037rk\u0011AO\u0005\u0003;j\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tYv,\u0003\u0002au\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005\t,W\"A2\u000b\u0003\u0011\fQa]2bY\u0006L!AZ2\u0003\u000fA\u0013x\u000eZ;diB\u0011!\r[\u0005\u0003S\u000e\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\t!,A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\t\u0011\u000f\u0005\u0002ce&\u00111o\u0019\u0002\u0004\u0013:$\u0018aF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013A\u0002\u001fj]&$h\bF\u0003zundX\u0010\u0005\u0002J\u0001!)!.\u0003a\u00015\")Q.\u0003a\u00015\"9q.\u0003I\u0001\u0002\u0004\t\bbB;\n!\u0003\u0005\r!]\u0001\nY\u001e\u001cuN\u001c4jO.\u000b!\u0002^1sO\u0016$H+\u001f9f+\t\t\u0019\u0001E\u0002N\u0003\u000bI1!a\u0002O\u0005)!v\r\u001e%mYRK\b/Z\u0001\fi\u0006\u0014x-\u001a;UsB,\u0007\u0005F\u0002z\u0003\u001bAa!a\u0004\u000e\u0001\u0004Q\u0016!B2iS2$G#B=\u0002\u0014\u0005U\u0001BBA\b\u001d\u0001\u0007!\fC\u0003\u007f\u001d\u0001\u0007!\fF\u0003z\u00033\tY\u0002\u0003\u0004\u0002\u0010=\u0001\rA\u0017\u0005\u0006}>\u0001\r!]\u0001\u001eo&$\bNT3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019\u00110!\t\t\r\u0005\r\u0002\u00031\u0001r\u0003eqWm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u00027]LG\u000f\u001b(fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u)\rI\u0018\u0011\u0006\u0005\u0007\u0003W\t\u0002\u0019A9\u0002/9,w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015I\u0018\u0011GA\u001b\u0011\u0019\t\u0019D\u0005a\u00015\u00069a.Z<MK\u001a$\bBBA\u001c%\u0001\u0007!,\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003{\u0001B!a\u0010\u0002N9!\u0011\u0011IA%!\r\t\u0019eY\u0007\u0003\u0003\u000bR1!a\u0012G\u0003\u0019a$o\\8u}%\u0019\u00111J2\u0002\rA\u0013X\rZ3g\u0013\u0011\ty%!\u0015\u0003\rM#(/\u001b8h\u0015\r\tYeY\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA,!\u0019\tI&a\u0019\u0002j9!\u00111LA0\u001d\u0011\t\u0019%!\u0018\n\u0003\u0011L1!!\u0019d\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001a\u0002h\t\u00191+Z9\u000b\u0007\u0005\u00054\r\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\tyGP\u0001\u0006if\u0004Xm]\u0005\u0005\u0003g\niG\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002zA!\u00111NA>\u0013\u0011\ti(!\u001c\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003\u0007\u00032AYAC\u0013\r\t9i\u0019\u0002\b\u0005>|G.Z1o\u0003]\u0019'/Z1uK\u0006;wM]3hCRLwN\u001c\"vM\u001a,'\u000fF\u0001M\u0003\u0019)\b\u000fZ1uKR)A*!%\u0002\u0016\"1\u00111\u0013\rA\u00021\u000baa]6fi\u000eD\u0007bBAL1\u0001\u0007\u0011\u0011T\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u00037\u000bi*D\u0001=\u0013\r\ty\n\u0010\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003nKJ<W\rF\u0003M\u0003K\u000b9\u000b\u0003\u0004\u0002\u0014f\u0001\r\u0001\u0014\u0005\u0007\u0003/K\u0002\u0019\u0001'\u0002\t\u00154\u0018\r\u001c\u000b\u0005\u0003[\u000b\u0019\fE\u0002c\u0003_K1!!-d\u0005\r\te.\u001f\u0005\u0007\u0003'S\u0002\u0019\u0001'\u0002\u0013M,'/[1mSj,G\u0003BA]\u0003\u000b\u0004RAYA^\u0003\u007fK1!!0d\u0005\u0015\t%O]1z!\r\u0011\u0017\u0011Y\u0005\u0004\u0003\u0007\u001c'\u0001\u0002\"zi\u0016Da!a%\u001c\u0001\u0004a\u0015a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2\u0001TAf\u0011\u001d\ti\r\ba\u0001\u0003s\u000baAY;gM\u0016\u0014\u0018\u0001B2paf$\u0012\"_Aj\u0003+\f9.!7\t\u000f)l\u0002\u0013!a\u00015\"9Q.\bI\u0001\u0002\u0004Q\u0006bB8\u001e!\u0003\u0005\r!\u001d\u0005\bkv\u0001\n\u00111\u0001r\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a8+\u0007i\u000b\to\u000b\u0002\u0002dB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018!C;oG\",7m[3e\u0015\r\tioY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAy\u0003O\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002z*\u001a\u0011/!9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0001\u0011\t\t\r!QB\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u0005!A.\u00198h\u0015\t\u0011Y!\u0001\u0003kCZ\f\u0017\u0002BA(\u0005\u000b\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002.\nU\u0001\u0002\u0003B\fI\u0005\u0005\t\u0019A9\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0002\u0005\u0004\u0003 \t\u0015\u0012QV\u0007\u0003\u0005CQ1Aa\td\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005O\u0011\tC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAB\u0005[A\u0011Ba\u0006'\u0003\u0003\u0005\r!!,\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019Ia\r\t\u0013\t]q%!AA\u0002\u00055\u0006f\u0005\u0001\u00038\tu\"q\bB\"\u0005\u000b\u0012IEa\u0013\u0003P\tE\u0003cA.\u0003:%\u0019!1\b\u001e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011I\u0001\u0002\u001a*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014H\u0006\t7h\u0007>tg-[4LS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002BE\u000e\\*lKR\u001c\u0007nJ:!kB$\u0017\r^1cY\u0016\u0004#-\u001b8bef\u0004#/\u001a9sKN,g\u000e^1uS>tgF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00197h\u0007>tg-[4LA\u0002Bs\u000e\u001d;j_:\fG.\u000b\u0011uQ\u0016\u0004Cn\\4.E\u0006\u001cX-\f\u001a!_\u001a\u00043\n\f\u0011xSRD\u0007e\u0013\u0011jg\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002\u0012WoY6fiN\u0004sN\u001d\u0006!A\u0001\u0002\u0003\u0005I:m_R\u001c\bEZ8sAQDW\r\t%mYN[W\r^2i]\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u000f\nAP\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011iY2|6o[3uG\"|Vm\u001d;j[\u0006$X\rK0G+:\u001bu\fK2pY2\u0002\u0013GM\u0015*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c%b\u0003\u0005K\u0019*Y\u0001B#'\u000b\u0017!QIJC\u0006\t\u00154S\u0001\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa\u001a:pkB\f#A!\u0014\u0002\u0013\u0005<wm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B*\u0003\u0015\u0019d&\u000e\u00181\u00031AE\u000e\\*lKR\u001c\u0007.Q4h!\tI\u0015f\u0005\u0003*\u00057:\u0007c\u00012\u0003^%\u0019!qL2\u0003\r\u0005s\u0017PU3g)\t\u00119&\u0001\u0007nS:dumQ8oM&<7*A\u0007nS:dumQ8oM&<7\nI\u0001\r[\u0006DHjZ\"p]\u001aLwmS\u0001\u000e[\u0006DHjZ\"p]\u001aLwm\u0013\u0011\u0002\u0011\rDWmY6MO.#BAa\u001c\u0003vA\u0019!M!\u001d\n\u0007\tM4M\u0001\u0003V]&$\b\"\u0002@0\u0001\u0004\t\u0018!B1qa2LH#C=\u0003|\tu$q\u0010BA\u0011\u0015Q\u0007\u00071\u0001[\u0011\u0015i\u0007\u00071\u0001[\u0011\u001dy\u0007\u0007%AA\u0002EDq!\u001e\u0019\u0011\u0002\u0003\u0007\u0011/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0017\u00139\nE\u0003c\u0005\u001b\u0013\t*C\u0002\u0003\u0010\u000e\u0014aa\u00149uS>t\u0007c\u00022\u0003\u0014jS\u0016/]\u0005\u0004\u0005+\u001b'A\u0002+va2,G\u0007\u0003\u0005\u0003\u001aN\n\t\u00111\u0001z\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0006\u0003\u0002B\u0002\u0005KKAAa*\u0003\u0006\t1qJ\u00196fGR\u0004")
public class HllSketchAgg
extends TypedImperativeAggregate<HllSketch>
implements BinaryLike<Expression>,
ExpectsInputTypes,
Serializable {
    private int lgConfigK;
    private final Expression left;
    private final Expression right;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final TgtHllType targetType;
    private transient Seq<Expression> children;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$4() {
        return HllSketchAgg$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HllSketchAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HllSketchAgg hllSketchAgg) {
        return HllSketchAgg$.MODULE$.unapply(hllSketchAgg);
    }

    public static int apply$default$4() {
        return HllSketchAgg$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HllSketchAgg$.MODULE$.apply$default$3();
    }

    public static void checkLgK(int n) {
        HllSketchAgg$.MODULE$.checkLgK(n);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HllSketchAgg hllSketchAgg = this;
        synchronized (hllSketchAgg) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    /*
     * WARNING - void declaration
     */
    private int lgConfigK$lzycompute() {
        HllSketchAgg hllSketchAgg = this;
        synchronized (hllSketchAgg) {
            if (!this.bitmap$0) {
                void var2_2;
                int lgConfigK = BoxesRunTime.unboxToInt((Object)this.right().eval(this.right().eval$default$1()));
                HllSketchAgg$.MODULE$.checkLgK(lgConfigK);
                this.lgConfigK = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.lgConfigK;
    }

    public int lgConfigK() {
        if (!this.bitmap$0) {
            return this.lgConfigK$lzycompute();
        }
        return this.lgConfigK;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HllSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public HllSketchAgg withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "hll_sketch_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$, StringType$.MODULE$, BinaryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public HllSketch createAggregationBuffer() {
        return new HllSketch(this.lgConfigK(), this.targetType());
    }

    @Override
    public HllSketch update(HllSketch sketch, InternalRow input) {
        Object v = this.left().eval(input);
        if (v != null) {
            DataType dataType = this.left().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                sketch.update((long)BoxesRunTime.unboxToInt((Object)v));
            } else if (LongType$.MODULE$.equals(dataType)) {
                sketch.update(BoxesRunTime.unboxToLong((Object)v));
            } else if (StringType$.MODULE$.equals(dataType)) {
                sketch.update(((UTF8String)v).toString());
            } else if (BinaryType$.MODULE$.equals(dataType)) {
                sketch.update((byte[])v);
            } else {
                throw new UnsupportedOperationException(new StringBuilder(57).append("A HllSketch instance cannot be updates with a Spark ").append(dataType.toString()).append(" type").toString());
            }
        }
        return sketch;
    }

    @Override
    public HllSketch merge(HllSketch sketch, HllSketch input) {
        Union union = new Union(sketch.getLgConfigK());
        union.update(sketch);
        union.update(input);
        return union.getResult(this.targetType());
    }

    @Override
    public Object eval(HllSketch sketch) {
        return sketch.toUpdatableByteArray();
    }

    @Override
    public byte[] serialize(HllSketch sketch) {
        return sketch.toUpdatableByteArray();
    }

    @Override
    public HllSketch deserialize(byte[] buffer) {
        return HllSketch.heapify((byte[])buffer);
    }

    public HllSketchAgg copy(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HllSketchAgg(left, right, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HllSketchAgg";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllSketchAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllSketchAgg hllSketchAgg = (HllSketchAgg)x$1;
        Expression expression = this.left();
        Expression expression2 = hllSketchAgg.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = hllSketchAgg.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.mutableAggBufferOffset() != hllSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hllSketchAgg.inputAggBufferOffset()) return false;
        if (!hllSketchAgg.canEqual(this)) return false;
        return true;
    }

    public HllSketchAgg(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.left = left;
        this.right = right;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllSketchAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)), 0, 0);
    }

    public HllSketchAgg(Expression child, Expression lgConfigK) {
        this(child, lgConfigK, 0, 0);
    }

    public HllSketchAgg(Expression child, int lgConfigK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)lgConfigK)), 0, 0);
    }
}

