/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class StructuredNetworkWordCount$ {
    public static StructuredNetworkWordCount$ MODULE$;

    static {
        new StructuredNetworkWordCount$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: StructuredNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredNetworkWordCount").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).load();
        Dataset words = lines.as(spark.implicits().newStringEncoder()).flatMap((Function1 & java.io.Serializable & Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "))), spark.implicits().newStringEncoder());
        Dataset wordCounts = words.groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }

    private StructuredNetworkWordCount$() {
        MODULE$ = this;
    }
}

