% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/column.R
\name{dropFields}
\alias{dropFields}
\alias{dropFields,Column-method}
\title{dropFields}
\usage{
dropFields(x, ...)

\S4method{dropFields}{Column}(x, ...)
}
\arguments{
\item{x}{a Column}

\item{...}{names of the fields to be dropped.}
}
\description{
Drops fields in a struct \code{Column} by name.
}
\note{
dropFields since 3.1.0
}
\examples{
\dontrun{
df <- select(
  createDataFrame(iris),
  alias(
    struct(
      column("Sepal_Width"), column("Sepal_Length"),
      alias(
        struct(
          column("Petal_Width"), column("Petal_Length"),
          alias(
            column("Petal_Width") * column("Petal_Length"),
            "Petal_Product"
          )
        ),
        "Petal"
      )
    ),
    "dimensions"
  )
)
head(withColumn(df, "dimensions", dropFields(df$dimensions, "Petal")))

head(
  withColumn(
    df, "dimensions",
    dropFields(df$dimensions, "Sepal_Width", "Sepal_Length")
  )
)

# This method supports dropping multiple nested fields directly e.g.
head(
  withColumn(
    df, "dimensions",
    dropFields(df$dimensions, "Petal.Petal_Width", "Petal.Petal_Length")
  )
)

# However, if you are going to add/replace multiple nested fields,
# it is preferred to extract out the nested struct before
# adding/replacing multiple fields e.g.
head(
  withColumn(
    df, "dimensions",
    withField(
      column("dimensions"),
      "Petal",
      dropFields(column("dimensions.Petal"), "Petal_Width", "Petal_Length")
    )
  )
)
}
}
