% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_clustering.R
\name{spark.assignClusters}
\alias{spark.assignClusters}
\alias{spark.assignClusters,SparkDataFrame-method}
\title{PowerIterationClustering}
\usage{
spark.assignClusters(data, ...)

\S4method{spark.assignClusters}{SparkDataFrame}(
  data,
  k = 2L,
  initMode = c("random", "degree"),
  maxIter = 20L,
  sourceCol = "src",
  destinationCol = "dst",
  weightCol = NULL
)
}
\arguments{
\item{data}{a SparkDataFrame.}

\item{...}{additional argument(s) passed to the method.}

\item{k}{the number of clusters to create.}

\item{initMode}{the initialization algorithm; "random" or "degree"}

\item{maxIter}{the maximum number of iterations.}

\item{sourceCol}{the name of the input column for source vertex IDs.}

\item{destinationCol}{the name of the input column for destination vertex IDs}

\item{weightCol}{weight column name. If this is not set or \code{NULL},
we treat all instance weights as 1.0.}
}
\value{
A dataset that contains columns of vertex id and the corresponding cluster for the id.
        The schema of it will be: \code{id: integer}, \code{cluster: integer}
}
\description{
A scalable graph clustering algorithm. Users can call \code{spark.assignClusters} to
return a cluster assignment for each input vertex.
Run the PIC algorithm and returns a cluster assignment for each input vertex.
}
\note{
spark.assignClusters(SparkDataFrame) since 3.0.0
}
\examples{
\dontrun{
df <- createDataFrame(list(list(0L, 1L, 1.0), list(0L, 2L, 1.0),
                           list(1L, 2L, 1.0), list(3L, 4L, 1.0),
                           list(4L, 0L, 0.1)),
                      schema = c("src", "dst", "weight"))
clusters <- spark.assignClusters(df, initMode = "degree", weightCol = "weight")
showDF(clusters)
}
}
