/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.correlation;

import breeze.linalg.DenseMatrix;
import breeze.linalg.Matrix;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.stat.correlation.Correlation;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.StringContext;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class PearsonCorrelation$
implements Correlation,
Logging {
    public static final PearsonCorrelation$ MODULE$ = new PearsonCorrelation$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Correlation.$init$(MODULE$);
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public double computeCorrelationWithMatrixImpl(RDD<Object> x, RDD<Object> y) {
        return Correlation.computeCorrelationWithMatrixImpl$(this, x, y);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public double computeCorrelation(RDD<Object> x, RDD<Object> y) {
        return this.computeCorrelationWithMatrixImpl(x, y);
    }

    @Override
    public org.apache.spark.mllib.linalg.Matrix computeCorrelationMatrix(RDD<Vector> X) {
        RowMatrix rowMatrix = new RowMatrix(X);
        org.apache.spark.mllib.linalg.Matrix cov = rowMatrix.computeCovariance();
        return this.computeCorrelationMatrixFromCovariance(cov);
    }

    public org.apache.spark.mllib.linalg.Matrix computeCorrelationMatrixFromCovariance(org.apache.spark.mllib.linalg.Matrix covarianceMatrix) {
        DenseMatrix cov;
        block6: {
            int i;
            cov = (DenseMatrix)covarianceMatrix.asBreeze();
            int n = cov.cols();
            for (i = 0; i < n; ++i) {
                cov.update$mcD$sp(i, i, this.closeToZero(cov.apply$mcD$sp(i, i), this.closeToZero$default$2()) ? 0.0 : package$.MODULE$.sqrt(cov.apply$mcD$sp(i, i)));
            }
            double sigma = 0.0;
            boolean containNaN = false;
            for (int j = 0; j < n; ++j) {
                sigma = cov.apply$mcD$sp(j, j);
                for (i = 0; i < j; ++i) {
                    double d;
                    if (sigma == 0.0 || cov.apply$mcD$sp(i, i) == 0.0) {
                        containNaN = true;
                        d = Double.NaN;
                    } else {
                        d = cov.apply$mcD$sp(i, j) / (sigma * cov.apply$mcD$sp(i, i));
                    }
                    double corr = d;
                    cov.update$mcD$sp(i, j, corr);
                    cov.update$mcD$sp(j, i, corr);
                }
            }
            for (i = 0; i < n; ++i) {
                cov.update$mcD$sp(i, i, 1.0);
            }
            if (!containNaN) break block6;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Pearson correlation matrix contains NaN values.");
        }
        return Matrices$.MODULE$.fromBreeze((Matrix<Object>)cov);
    }

    private boolean closeToZero(double value, double threshold) {
        return package$.MODULE$.abs(value) <= threshold;
    }

    private double closeToZero$default$2() {
        return 1.0E-12;
    }

    private PearsonCorrelation$() {
    }
}

